/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunctionMatcher;
import io.trino.sql.planner.assertions.AggregationMatcher;
import io.trino.sql.planner.assertions.AggregationStepMatcher;
import io.trino.sql.planner.assertions.AliasMatcher;
import io.trino.sql.planner.assertions.AliasPresent;
import io.trino.sql.planner.assertions.AnySymbol;
import io.trino.sql.planner.assertions.AssignUniqueIdMatcher;
import io.trino.sql.planner.assertions.ColumnHandleMatcher;
import io.trino.sql.planner.assertions.ColumnReference;
import io.trino.sql.planner.assertions.ConnectorAwareTableScanMatcher;
import io.trino.sql.planner.assertions.CorrelatedJoinMatcher;
import io.trino.sql.planner.assertions.CorrelationMatcher;
import io.trino.sql.planner.assertions.DistinctLimitMatcher;
import io.trino.sql.planner.assertions.DistinctMatcher;
import io.trino.sql.planner.assertions.EquiJoinClauseProvider;
import io.trino.sql.planner.assertions.ExchangeMatcher;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.FilterMatcher;
import io.trino.sql.planner.assertions.FunctionCallProvider;
import io.trino.sql.planner.assertions.GroupIdMatcher;
import io.trino.sql.planner.assertions.IdentityProjectionMatcher;
import io.trino.sql.planner.assertions.IndexJoinEquiClauseProvider;
import io.trino.sql.planner.assertions.IndexJoinMatcher;
import io.trino.sql.planner.assertions.IndexSourceMatcher;
import io.trino.sql.planner.assertions.JoinMatcher;
import io.trino.sql.planner.assertions.LimitMatcher;
import io.trino.sql.planner.assertions.MarkDistinctMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.NotPlanNodeMatcher;
import io.trino.sql.planner.assertions.OffsetMatcher;
import io.trino.sql.planner.assertions.OrdinalitySymbolMatcher;
import io.trino.sql.planner.assertions.OutputMatcher;
import io.trino.sql.planner.assertions.PatternRecognitionMatcher;
import io.trino.sql.planner.assertions.PlanMatchingState;
import io.trino.sql.planner.assertions.PlanNodeMatcher;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.PredicateMatcher;
import io.trino.sql.planner.assertions.RowNumberMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SemiJoinMatcher;
import io.trino.sql.planner.assertions.SortMatcher;
import io.trino.sql.planner.assertions.SpatialJoinMatcher;
import io.trino.sql.planner.assertions.SpecificationProvider;
import io.trino.sql.planner.assertions.StatsOutputRowCountMatcher;
import io.trino.sql.planner.assertions.StrictAssignedSymbolsMatcher;
import io.trino.sql.planner.assertions.StrictSymbolsMatcher;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.SymbolCardinalityMatcher;
import io.trino.sql.planner.assertions.TableExecuteMatcher;
import io.trino.sql.planner.assertions.TableFunctionMatcher;
import io.trino.sql.planner.assertions.TableFunctionProcessorMatcher;
import io.trino.sql.planner.assertions.TableScanMatcher;
import io.trino.sql.planner.assertions.TableWriterMatcher;
import io.trino.sql.planner.assertions.TopNMatcher;
import io.trino.sql.planner.assertions.TopNRankingMatcher;
import io.trino.sql.planner.assertions.UnnestMatcher;
import io.trino.sql.planner.assertions.UnnestedSymbolMatcher;
import io.trino.sql.planner.assertions.ValuesMatcher;
import io.trino.sql.planner.assertions.WindowFrameProvider;
import io.trino.sql.planner.assertions.WindowMatcher;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.SymbolMapper;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.WindowFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;

public final class PlanMatchPattern {
    private final List<Matcher> matchers = new ArrayList<Matcher>();
    private final List<PlanMatchPattern> sourcePatterns;
    private boolean anyTree;

    public static PlanMatchPattern node(Class<? extends PlanNode> nodeClass, PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).with(new PlanNodeMatcher(nodeClass));
    }

    public static PlanMatchPattern any(PlanMatchPattern ... sources) {
        return new PlanMatchPattern((List<PlanMatchPattern>)ImmutableList.copyOf((Object[])sources));
    }

    public static PlanMatchPattern anyTree(PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).matchToAnyNodeTree();
    }

    public static PlanMatchPattern anyNot(Class<? extends PlanNode> excludeNodeClass, PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).with(new NotPlanNodeMatcher(excludeNodeClass));
    }

    public static PlanMatchPattern tableScan(String expectedTableName) {
        return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new TableScanMatcher(expectedTableName, Optional.empty(), Optional.empty()));
    }

    public static PlanMatchPattern tableScan(String expectedTableName, Map<String, String> columnReferences) {
        PlanMatchPattern result = PlanMatchPattern.tableScan(expectedTableName);
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern tableScan(Predicate<ConnectorTableHandle> expectedTable, TupleDomain<Predicate<ColumnHandle>> enforcedConstraints, Map<String, Predicate<ColumnHandle>> expectedColumns) {
        return PlanMatchPattern.tableScan(expectedTable, enforcedConstraints, expectedColumns, statistics -> true);
    }

    public static PlanMatchPattern tableScan(Predicate<ConnectorTableHandle> expectedTable, TupleDomain<Predicate<ColumnHandle>> enforcedConstraints, Map<String, Predicate<ColumnHandle>> expectedColumns, Predicate<Optional<PlanNodeStatsEstimate>> expectedStatistics) {
        PlanMatchPattern pattern = ConnectorAwareTableScanMatcher.create(expectedTable, enforcedConstraints, expectedStatistics);
        expectedColumns.entrySet().forEach(column -> pattern.withAlias((String)column.getKey(), (RvalueMatcher)new ColumnHandleMatcher((Predicate)column.getValue())));
        return pattern;
    }

    public static PlanMatchPattern strictTableScan(String expectedTableName, Map<String, String> columnReferences) {
        return PlanMatchPattern.tableScan(expectedTableName, columnReferences).withExactAssignedOutputs((Collection)columnReferences.values().stream().map(columnName -> PlanMatchPattern.columnReference(expectedTableName, columnName)).collect(ImmutableList.toImmutableList()));
    }

    public static PlanMatchPattern strictConstrainedTableScan(String expectedTableName, Map<String, String> columnReferences, Map<String, Domain> constraint) {
        return PlanMatchPattern.strictTableScan(expectedTableName, columnReferences).with(new TableScanMatcher(expectedTableName, Optional.of(constraint), Optional.empty()));
    }

    public static PlanMatchPattern constrainedTableScan(String expectedTableName, Map<String, Domain> constraint) {
        return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new TableScanMatcher(expectedTableName, Optional.of(constraint), Optional.empty()));
    }

    public static PlanMatchPattern constrainedTableScan(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        PlanMatchPattern result = PlanMatchPattern.constrainedTableScan(expectedTableName, constraint);
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern constrainedTableScanWithTableLayout(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new TableScanMatcher(expectedTableName, Optional.of(constraint), Optional.of(true))).addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern indexJoin(IndexJoinNode.Type type, List<ExpectedValueProvider<IndexJoinNode.EquiJoinClause>> criteria, Optional<String> probeHashSymbol, Optional<String> indexHashSymbol, PlanMatchPattern probeSource, PlanMatchPattern indexSource) {
        return PlanMatchPattern.node(IndexJoinNode.class, probeSource, indexSource).with(new IndexJoinMatcher(type, criteria, probeHashSymbol.map(SymbolAlias::new), indexHashSymbol.map(SymbolAlias::new)));
    }

    public static ExpectedValueProvider<IndexJoinNode.EquiJoinClause> indexJoinEquiClause(String probe, String index) {
        return new IndexJoinEquiClauseProvider(new SymbolAlias(probe), new SymbolAlias(index));
    }

    public static PlanMatchPattern constrainedIndexSource(String expectedTableName, Map<String, String> columnReferences) {
        return PlanMatchPattern.node(IndexSourceNode.class, new PlanMatchPattern[0]).with(new IndexSourceMatcher(expectedTableName)).addColumnReferences(expectedTableName, columnReferences);
    }

    private PlanMatchPattern addColumnReferences(String expectedTableName, Map<String, String> columnReferences) {
        columnReferences.entrySet().forEach(reference -> this.withAlias((String)reference.getKey(), PlanMatchPattern.columnReference(expectedTableName, (String)reference.getValue())));
        return this;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source);
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, AggregationNode.Step step, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new AggregationStepMatcher(step));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, Predicate<AggregationNode> predicate, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new PredicateMatcher<AggregationNode>(predicate));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        return PlanMatchPattern.aggregation(groupingSets, aggregations, (List<String>)ImmutableList.of(), groupId, step, source);
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, List<String> preGroupedSymbols, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        return PlanMatchPattern.aggregation(groupingSets, aggregations, preGroupedSymbols, (List<String>)ImmutableList.of(), groupId, step, source);
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, List<String> preGroupedSymbols, List<String> masks, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new AggregationMatcher(groupingSets, preGroupedSymbols, masks, groupId, step));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((Optional)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern distinctLimit(long limit, List<String> distinctSymbols, PlanMatchPattern source) {
        return PlanMatchPattern.node(DistinctLimitNode.class, source).with(new DistinctLimitMatcher(limit, PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.empty()));
    }

    public static PlanMatchPattern distinctLimit(long limit, List<String> distinctSymbols, String hashSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(DistinctLimitNode.class, source).with(new DistinctLimitMatcher(limit, PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.of(new SymbolAlias(hashSymbol))));
    }

    public static PlanMatchPattern markDistinct(String markerSymbol, List<String> distinctSymbols, PlanMatchPattern source) {
        return PlanMatchPattern.node(MarkDistinctNode.class, source).with(new MarkDistinctMatcher(new SymbolAlias(markerSymbol), PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.empty()));
    }

    public static PlanMatchPattern markDistinct(String markerSymbol, List<String> distinctSymbols, String hashSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(MarkDistinctNode.class, source).with(new MarkDistinctMatcher(new SymbolAlias(markerSymbol), PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.of(new SymbolAlias(hashSymbol))));
    }

    public static ExpectedValueProvider<WindowNode.Frame> windowFrame(WindowFrame.Type type, FrameBound.Type startType, Optional<String> startValue, FrameBound.Type endType, Optional<String> endValue, Optional<String> sortKey) {
        return PlanMatchPattern.windowFrame(type, startType, startValue, sortKey, endType, endValue, sortKey);
    }

    public static ExpectedValueProvider<WindowNode.Frame> windowFrame(WindowFrame.Type type, FrameBound.Type startType, Optional<String> startValue, Optional<String> sortKeyForStartComparison, FrameBound.Type endType, Optional<String> endValue, Optional<String> sortKeyForEndComparison) {
        return new WindowFrameProvider(type, startType, startValue.map(SymbolAlias::new), sortKeyForStartComparison.map(SymbolAlias::new), endType, endValue.map(SymbolAlias::new), sortKeyForEndComparison.map(SymbolAlias::new));
    }

    public static PlanMatchPattern window(Consumer<WindowMatcher.Builder> handler, PlanMatchPattern source) {
        WindowMatcher.Builder builder = new WindowMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern rowNumber(Consumer<RowNumberMatcher.Builder> handler, PlanMatchPattern source) {
        RowNumberMatcher.Builder builder = new RowNumberMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern topNRanking(Consumer<TopNRankingMatcher.Builder> handler, PlanMatchPattern source) {
        TopNRankingMatcher.Builder builder = new TopNRankingMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern patternRecognition(Consumer<PatternRecognitionMatcher.Builder> handler, PlanMatchPattern source) {
        PatternRecognitionMatcher.Builder builder = new PatternRecognitionMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern join(JoinNode.Type type, Consumer<JoinMatcher.Builder> handler) {
        JoinMatcher.Builder builder = new JoinMatcher.Builder(type);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern sort(PlanMatchPattern source) {
        return PlanMatchPattern.node(SortNode.class, source);
    }

    public static PlanMatchPattern sort(List<Ordering> orderBy, PlanMatchPattern source) {
        return PlanMatchPattern.node(SortNode.class, source).with(new SortMatcher(orderBy));
    }

    public static PlanMatchPattern topN(long count, List<Ordering> orderBy, PlanMatchPattern source) {
        return PlanMatchPattern.topN(count, orderBy, TopNNode.Step.SINGLE, source);
    }

    public static PlanMatchPattern topN(long count, List<Ordering> orderBy, TopNNode.Step step, PlanMatchPattern source) {
        return PlanMatchPattern.node(TopNNode.class, source).with(new TopNMatcher(count, orderBy, step));
    }

    public static PlanMatchPattern output(PlanMatchPattern source) {
        return PlanMatchPattern.node(OutputNode.class, source);
    }

    public static PlanMatchPattern output(List<String> outputs, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.output(source);
        result.withOutputs(outputs);
        return result;
    }

    public static PlanMatchPattern strictOutput(List<String> outputs, PlanMatchPattern source) {
        return PlanMatchPattern.output(outputs, source).withExactOutputs(outputs);
    }

    public static PlanMatchPattern project(PlanMatchPattern source) {
        return PlanMatchPattern.node(ProjectNode.class, source);
    }

    public static PlanMatchPattern project(Map<String, ExpressionMatcher> assignments, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.project(source);
        assignments.entrySet().forEach(assignment -> result.withAlias((String)assignment.getKey(), (RvalueMatcher)assignment.getValue()));
        return result;
    }

    public static PlanMatchPattern identityProject(PlanMatchPattern source) {
        return PlanMatchPattern.node(ProjectNode.class, source).with(new IdentityProjectionMatcher());
    }

    public static PlanMatchPattern strictProject(Map<String, ExpressionMatcher> assignments, PlanMatchPattern source) {
        return PlanMatchPattern.project(assignments, source).withExactAssignedOutputs(assignments.values()).withExactAssignments(assignments.values());
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.semiJoin(sourceSymbolAlias, filteringSymbolAlias, outputAlias, Optional.empty(), Optional.empty(), source, filtering);
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, Optional<SemiJoinNode.DistributionType> distributionType, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.semiJoin(sourceSymbolAlias, filteringSymbolAlias, outputAlias, distributionType, Optional.empty(), source, filtering);
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, boolean hasDynamicFilter, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.semiJoin(sourceSymbolAlias, filteringSymbolAlias, outputAlias, Optional.empty(), Optional.of(hasDynamicFilter), source, filtering);
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, Optional<SemiJoinNode.DistributionType> distributionType, Optional<Boolean> hasDynamicFilter, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.node(SemiJoinNode.class, source, filtering).with(new SemiJoinMatcher(sourceSymbolAlias, filteringSymbolAlias, outputAlias, distributionType, hasDynamicFilter));
    }

    public static PlanMatchPattern spatialJoin(@Language(value="SQL") String expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.spatialJoin(expectedFilter, Optional.empty(), left, right);
    }

    public static PlanMatchPattern spatialJoin(@Language(value="SQL") String expectedFilter, Optional<String> kdbTree, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.spatialJoin(expectedFilter, kdbTree, Optional.empty(), left, right);
    }

    public static PlanMatchPattern spatialJoin(@Language(value="SQL") String expectedFilter, Optional<String> kdbTree, Optional<List<String>> outputSymbols, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(SpatialJoinNode.class, left, right).with(new SpatialJoinMatcher(SpatialJoinNode.Type.INNER, PlanBuilder.expression(expectedFilter), kdbTree, outputSymbols));
    }

    public static PlanMatchPattern spatialLeftJoin(@Language(value="SQL") String expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(SpatialJoinNode.class, left, right).with(new SpatialJoinMatcher(SpatialJoinNode.Type.LEFT, PlanBuilder.expression(expectedFilter), Optional.empty(), Optional.empty()));
    }

    public static PlanMatchPattern unnest(PlanMatchPattern source) {
        return PlanMatchPattern.node(UnnestNode.class, source);
    }

    public static PlanMatchPattern unnest(List<String> replicateSymbols, List<UnnestMapping> mappings, PlanMatchPattern source) {
        return PlanMatchPattern.unnest(replicateSymbols, mappings, Optional.empty(), JoinNode.Type.INNER, Optional.empty(), source);
    }

    public static PlanMatchPattern unnest(List<String> replicateSymbols, List<UnnestMapping> mappings, Optional<String> ordinalitySymbol, JoinNode.Type type, Optional<String> filter, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(UnnestNode.class, source).with(new UnnestMatcher(replicateSymbols, mappings, ordinalitySymbol, type, filter.map(predicate -> PlanBuilder.expression(predicate))));
        mappings.forEach(mapping -> {
            for (int i = 0; i < mapping.getOutputs().size(); ++i) {
                result.withAlias(mapping.getOutputs().get(i), (RvalueMatcher)new UnnestedSymbolMatcher(mapping.getInput(), i));
            }
        });
        ordinalitySymbol.ifPresent(symbol -> result.withAlias((String)symbol, (RvalueMatcher)new OrdinalitySymbolMatcher()));
        return result;
    }

    public static PlanMatchPattern exchange(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExchangeNode.class, sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, Optional.empty(), Optional.empty(), (List<Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, (List<Ordering>)ImmutableList.of(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, PartitioningHandle partitioningHandle, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, Optional.of(type), Optional.of(partitioningHandle), (List<Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, orderBy, (Set<String>)ImmutableSet.of(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, Set<String> partitionedBy, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, orderBy, partitionedBy, Optional.empty(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, Set<String> partitionedBy, Optional<List<List<String>>> inputs, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, Optional.of(type), Optional.empty(), orderBy, partitionedBy, inputs, sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, Optional<ExchangeNode.Type> type, Optional<PartitioningHandle> partitioningHandle, List<Ordering> orderBy, Set<String> partitionedBy, Optional<List<List<String>>> inputs, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, partitioningHandle, orderBy, partitionedBy, inputs, (List<String>)ImmutableList.of(), Optional.empty(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, Optional<Integer> partitionCount, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, Optional.empty(), Optional.empty(), (List<Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), (List<String>)ImmutableList.of(), Optional.of(partitionCount), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, Optional<Integer> partitionCount, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, Optional.of(type), Optional.empty(), (List<Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), (List<String>)ImmutableList.of(), Optional.of(partitionCount), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, PartitioningHandle partitioningHandle, Optional<Integer> partitionCount, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, Optional.empty(), Optional.of(partitioningHandle), (List<Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), (List<String>)ImmutableList.of(), Optional.of(partitionCount), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, Optional<ExchangeNode.Type> type, Optional<PartitioningHandle> partitioningHandle, List<Ordering> orderBy, Set<String> partitionedBy, Optional<List<List<String>>> inputs, List<String> outputSymbolAliases, Optional<Optional<Integer>> partitionCount, PlanMatchPattern ... sources) {
        PlanMatchPattern result = PlanMatchPattern.node(ExchangeNode.class, sources).with(new ExchangeMatcher(scope, type, partitioningHandle, orderBy, partitionedBy, inputs, partitionCount));
        int i = 0;
        while (i < outputSymbolAliases.size()) {
            String outputSymbol = outputSymbolAliases.get(i);
            int index = i++;
            result.withAlias(outputSymbol, (PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) -> {
                ExchangeNode exchangeNode = (ExchangeNode)node;
                List outputSymbols = exchangeNode.getPartitioningScheme().getOutputLayout();
                Preconditions.checkState((index < outputSymbols.size() ? 1 : 0) != 0, (Object)"outputSymbolAliases size is more than exchange output symbols");
                return Optional.ofNullable((Symbol)outputSymbols.get(index));
            });
        }
        return result;
    }

    public static PlanMatchPattern union(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(UnionNode.class, sources);
    }

    public static PlanMatchPattern assignUniqueId(String uniqueSymbolAlias, PlanMatchPattern source) {
        return PlanMatchPattern.node(AssignUniqueId.class, source).withAlias(uniqueSymbolAlias, (RvalueMatcher)new AssignUniqueIdMatcher());
    }

    public static PlanMatchPattern intersect(PlanMatchPattern ... sources) {
        return PlanMatchPattern.intersect(true, sources);
    }

    public static PlanMatchPattern intersect(boolean distinct, PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(IntersectNode.class, sources).with(new DistinctMatcher(distinct));
    }

    public static PlanMatchPattern except(PlanMatchPattern ... sources) {
        return PlanMatchPattern.except(true, sources);
    }

    public static PlanMatchPattern except(boolean distinct, PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExceptNode.class, sources).with(new DistinctMatcher(distinct));
    }

    public static ExpectedValueProvider<JoinNode.EquiJoinClause> equiJoinClause(String left, String right) {
        return new EquiJoinClauseProvider(new SymbolAlias(left), new SymbolAlias(right));
    }

    public static SymbolAlias symbol(String alias) {
        return new SymbolAlias(alias);
    }

    public static PlanMatchPattern filter(@Language(value="SQL") String expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.filter(PlanBuilder.expression(expectedPredicate), source);
    }

    public static PlanMatchPattern filter(Expression expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.node(FilterNode.class, source).with(new FilterMatcher(expectedPredicate, Optional.empty()));
    }

    public static PlanMatchPattern filter(Expression expectedPredicate, Expression dynamicFilter, PlanMatchPattern source) {
        return PlanMatchPattern.node(FilterNode.class, source).with(new FilterMatcher(expectedPredicate, Optional.of(dynamicFilter)));
    }

    public static PlanMatchPattern apply(List<String> correlationSymbolAliases, Map<String, ExpressionMatcher> subqueryAssignments, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        PlanMatchPattern result = PlanMatchPattern.node(ApplyNode.class, inputPattern, subqueryPattern).with(new CorrelationMatcher(correlationSymbolAliases));
        subqueryAssignments.entrySet().forEach(assignment -> result.withAlias((String)assignment.getKey(), (RvalueMatcher)assignment.getValue()));
        return result;
    }

    public static PlanMatchPattern correlatedJoin(List<String> correlationSymbolAliases, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        return PlanMatchPattern.node(CorrelatedJoinNode.class, inputPattern, subqueryPattern).with(new CorrelationMatcher(correlationSymbolAliases));
    }

    public static PlanMatchPattern correlatedJoin(List<String> correlationSymbolAliases, @Language(value="SQL") String filter, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        return PlanMatchPattern.correlatedJoin(correlationSymbolAliases, inputPattern, subqueryPattern).with(new CorrelatedJoinMatcher(PlanBuilder.expression(filter)));
    }

    public static PlanMatchPattern groupId(List<List<String>> groupingSets, String groupIdSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.groupId(groupingSets, (List<String>)ImmutableList.of(), groupIdSymbol, source);
    }

    public static PlanMatchPattern groupId(List<List<String>> groupingSets, List<String> aggregationArguments, String groupIdSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(GroupIdNode.class, source).with(new GroupIdMatcher(groupingSets, aggregationArguments, groupIdSymbol));
    }

    public static PlanMatchPattern values(Map<String, Integer> aliasToIndex, Optional<Integer> expectedOutputSymbolCount, Optional<List<Expression>> expectedRows) {
        return PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]).with(new ValuesMatcher(aliasToIndex, expectedOutputSymbolCount, expectedRows));
    }

    private static PlanMatchPattern values(List<String> aliases, Optional<List<List<Expression>>> expectedRows) {
        return PlanMatchPattern.values(PlanMatchPattern.aliasToIndex(aliases), Optional.of(aliases.size()), expectedRows.map(list -> (List)list.stream().map(Row::new).collect(ImmutableList.toImmutableList())));
    }

    public static Map<String, Integer> aliasToIndex(List<String> aliases) {
        return Maps.uniqueIndex(IntStream.range(0, aliases.size()).boxed().iterator(), aliases::get);
    }

    public static PlanMatchPattern values(Map<String, Integer> aliasToIndex) {
        return PlanMatchPattern.values(aliasToIndex, Optional.empty(), Optional.empty());
    }

    public static PlanMatchPattern values(String ... aliases) {
        return PlanMatchPattern.values((List<String>)ImmutableList.copyOf((Object[])aliases));
    }

    public static PlanMatchPattern values(int rowCount) {
        return PlanMatchPattern.values((List<String>)ImmutableList.of(), Collections.nCopies(rowCount, ImmutableList.of()));
    }

    public static PlanMatchPattern values(List<String> aliases, List<List<Expression>> expectedRows) {
        return PlanMatchPattern.values(aliases, Optional.of(expectedRows));
    }

    public static PlanMatchPattern values(List<String> aliases) {
        return PlanMatchPattern.values(aliases, Optional.empty());
    }

    public static PlanMatchPattern offset(long rowCount, PlanMatchPattern source) {
        return PlanMatchPattern.node(OffsetNode.class, source).with(new OffsetMatcher(rowCount));
    }

    public static PlanMatchPattern limit(long limit, PlanMatchPattern source) {
        return PlanMatchPattern.limit(limit, (List<Ordering>)ImmutableList.of(), false, source);
    }

    public static PlanMatchPattern limit(long limit, List<Ordering> tiesResolvers, PlanMatchPattern source) {
        return PlanMatchPattern.limit(limit, tiesResolvers, false, source);
    }

    public static PlanMatchPattern limit(long limit, List<Ordering> tiesResolvers, boolean partial, PlanMatchPattern source) {
        return PlanMatchPattern.limit(limit, tiesResolvers, partial, (List<String>)ImmutableList.of(), source);
    }

    public static PlanMatchPattern limit(long limit, List<Ordering> tiesResolvers, boolean partial, List<String> preSortedInputs, PlanMatchPattern source) {
        return PlanMatchPattern.node(LimitNode.class, source).with(new LimitMatcher(limit, tiesResolvers, partial, (List)preSortedInputs.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList())));
    }

    public static PlanMatchPattern enforceSingleRow(PlanMatchPattern source) {
        return PlanMatchPattern.node(EnforceSingleRowNode.class, source);
    }

    public static PlanMatchPattern mergeWriter(PlanMatchPattern source) {
        return PlanMatchPattern.node(MergeWriterNode.class, source);
    }

    public static PlanMatchPattern tableWriter(List<String> columns, List<String> columnNames, PlanMatchPattern source) {
        return PlanMatchPattern.node(TableWriterNode.class, source).with(new TableWriterMatcher(columns, columnNames));
    }

    public static PlanMatchPattern tableExecute(List<String> columns, List<String> columnNames, PlanMatchPattern source) {
        return PlanMatchPattern.node(TableExecuteNode.class, source).with(new TableExecuteMatcher(columns, columnNames));
    }

    public static PlanMatchPattern tableFunction(Consumer<TableFunctionMatcher.Builder> handler, PlanMatchPattern ... sources) {
        TableFunctionMatcher.Builder builder = new TableFunctionMatcher.Builder(sources);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern tableFunctionProcessor(Consumer<TableFunctionProcessorMatcher.Builder> handler, PlanMatchPattern source) {
        TableFunctionProcessorMatcher.Builder builder = new TableFunctionProcessorMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern tableFunctionProcessor(Consumer<TableFunctionProcessorMatcher.Builder> handler) {
        TableFunctionProcessorMatcher.Builder builder = new TableFunctionProcessorMatcher.Builder();
        handler.accept(builder);
        return builder.build();
    }

    public PlanMatchPattern(List<PlanMatchPattern> sourcePatterns) {
        Objects.requireNonNull(sourcePatterns, "sourcePatterns are null");
        this.sourcePatterns = ImmutableList.copyOf(sourcePatterns);
    }

    List<PlanMatchingState> shapeMatches(PlanNode node) {
        ImmutableList.Builder states = ImmutableList.builder();
        if (this.anyTree) {
            int sourcesCount = node.getSources().size();
            if (sourcesCount > 1) {
                states.add((Object)new PlanMatchingState(Collections.nCopies(sourcesCount, this)));
            } else {
                states.add((Object)new PlanMatchingState((List<PlanMatchPattern>)ImmutableList.of((Object)this)));
            }
        }
        if (node instanceof GroupReference) {
            if (this.sourcePatterns.isEmpty() && this.shapeMatchesMatchers(node)) {
                states.add((Object)new PlanMatchingState((List<PlanMatchPattern>)ImmutableList.of()));
            }
        } else if (node.getSources().size() == this.sourcePatterns.size() && this.shapeMatchesMatchers(node)) {
            states.add((Object)new PlanMatchingState(this.sourcePatterns));
        }
        return states.build();
    }

    private boolean shapeMatchesMatchers(PlanNode node) {
        return this.matchers.stream().allMatch(it -> it.shapeMatches(node));
    }

    MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        SymbolAliases.Builder newAliases = SymbolAliases.builder();
        for (Matcher matcher : this.matchers) {
            MatchResult matchResult = matcher.detailMatches(node, stats, session, metadata, symbolAliases);
            if (!matchResult.isMatch()) {
                return MatchResult.NO_MATCH;
            }
            newAliases.putAll(matchResult.getAliases());
        }
        return MatchResult.match(newAliases.build());
    }

    public <T extends PlanNode> PlanMatchPattern with(final Class<T> clazz, final Predicate<T> predicate) {
        return this.with(new Matcher(){

            @Override
            public boolean shapeMatches(PlanNode node) {
                return clazz.isInstance(node);
            }

            @Override
            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                if (predicate.test((PlanNode)clazz.cast(node))) {
                    return MatchResult.match();
                }
                return MatchResult.NO_MATCH;
            }
        });
    }

    public PlanMatchPattern with(Matcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public PlanMatchPattern withAlias(String alias) {
        return this.withAlias(Optional.of(alias), (RvalueMatcher)new AliasPresent(alias));
    }

    public PlanMatchPattern withAlias(String alias, RvalueMatcher matcher) {
        return this.withAlias(Optional.of(alias), matcher);
    }

    public PlanMatchPattern withAlias(Optional<String> alias, RvalueMatcher matcher) {
        this.matchers.add(new AliasMatcher(alias, matcher));
        return this;
    }

    public PlanMatchPattern withNumberOfOutputColumns(int numberOfSymbols) {
        this.matchers.add(new SymbolCardinalityMatcher(numberOfSymbols));
        return this;
    }

    public PlanMatchPattern withExactOutputs(String ... expectedAliases) {
        return this.withExactOutputs((List<String>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactOutputs(List<String> expectedAliases) {
        this.matchers.add(new StrictSymbolsMatcher(StrictSymbolsMatcher.actualOutputs(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withExactAssignedOutputs(RvalueMatcher ... expectedAliases) {
        return this.withExactAssignedOutputs((Collection<? extends RvalueMatcher>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactAssignedOutputs(Collection<? extends RvalueMatcher> expectedAliases) {
        this.matchers.add(new StrictAssignedSymbolsMatcher(StrictSymbolsMatcher.actualOutputs(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withExactAssignments(RvalueMatcher ... expectedAliases) {
        return this.withExactAssignments((Collection<? extends RvalueMatcher>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactAssignments(Collection<? extends RvalueMatcher> expectedAliases) {
        this.matchers.add(new StrictAssignedSymbolsMatcher(StrictAssignedSymbolsMatcher.actualAssignments(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withOutputRowCount(double expectedOutputRowCount) {
        this.matchers.add(new StatsOutputRowCountMatcher(expectedOutputRowCount));
        return this;
    }

    public static RvalueMatcher columnReference(String tableName, String columnName) {
        return new ColumnReference(tableName, columnName);
    }

    public static ExpressionMatcher expression(@Language(value="SQL") String expression) {
        return new ExpressionMatcher(expression);
    }

    public static ExpressionMatcher expression(Expression expression) {
        return new ExpressionMatcher(expression);
    }

    public PlanMatchPattern withOutputs(String ... aliases) {
        return this.withOutputs((List<String>)ImmutableList.copyOf((Object[])aliases));
    }

    public PlanMatchPattern withOutputs(List<String> aliases) {
        this.matchers.add(new OutputMatcher(aliases));
        return this;
    }

    PlanMatchPattern matchToAnyNodeTree() {
        this.anyTree = true;
        return this;
    }

    public boolean isTerminated() {
        return this.sourcePatterns.isEmpty();
    }

    public static PlanTestSymbol anySymbol() {
        return new AnySymbol();
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args));
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args, List<Ordering> orderBy) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args), orderBy);
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, Optional<WindowFrame> frame, List<String> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), frame, false, PlanMatchPattern.toSymbolAliases(args));
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, boolean distinct, List<PlanTestSymbol> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), distinct, args);
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args, String filter) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args), PlanMatchPattern.symbol(filter));
    }

    public static List<Expression> toSymbolReferences(List<PlanTestSymbol> aliases, SymbolAliases symbolAliases) {
        return (List)aliases.stream().map(arg -> arg.toSymbol(symbolAliases).toSymbolReference()).collect(ImmutableList.toImmutableList());
    }

    private static List<PlanTestSymbol> toSymbolAliases(List<String> aliases) {
        return (List)aliases.stream().map(PlanMatchPattern::symbol).collect(ImmutableList.toImmutableList());
    }

    public static ExpectedValueProvider<DataOrganizationSpecification> specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
        return new SpecificationProvider((List)partitionBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()), (List)orderBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()), (Map)orderings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new SymbolAlias((String)entry.getKey()), Map.Entry::getValue)));
    }

    public static Ordering sort(String field, SortItem.Ordering ordering, SortItem.NullOrdering nullOrdering) {
        return new Ordering(field, ordering, nullOrdering);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    private void toString(StringBuilder builder, int indent) {
        Preconditions.checkState((this.matchers.stream().filter(PlanNodeMatcher.class::isInstance).count() <= 1L ? 1 : 0) != 0);
        builder.append(PlanMatchPattern.indentString(indent)).append("- ");
        if (this.anyTree) {
            builder.append("anyTree");
        } else {
            builder.append("node");
        }
        Optional<PlanNodeMatcher> planNodeMatcher = this.matchers.stream().filter(PlanNodeMatcher.class::isInstance).map(PlanNodeMatcher.class::cast).findFirst();
        planNodeMatcher.ifPresent(nodeMatcher -> builder.append("(").append(nodeMatcher.getNodeClass().getSimpleName()).append(")"));
        builder.append("\n");
        List matchersToPrint = (List)this.matchers.stream().filter(matcher -> !(matcher instanceof PlanNodeMatcher)).collect(ImmutableList.toImmutableList());
        for (Matcher matcher2 : matchersToPrint) {
            builder.append(PlanMatchPattern.indentString(indent + 1)).append(matcher2.toString()).append("\n");
        }
        for (PlanMatchPattern pattern : this.sourcePatterns) {
            pattern.toString(builder, indent + 1);
        }
    }

    private static String indentString(int indent) {
        return "    ".repeat(indent);
    }

    public static GroupingSetDescriptor globalAggregation() {
        return PlanMatchPattern.singleGroupingSet(new String[0]);
    }

    public static GroupingSetDescriptor singleGroupingSet(String ... groupingKeys) {
        return PlanMatchPattern.singleGroupingSet((List<String>)ImmutableList.copyOf((Object[])groupingKeys));
    }

    public static GroupingSetDescriptor singleGroupingSet(List<String> groupingKeys) {
        ImmutableSet globalGroupingSets = groupingKeys.size() == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
        return new GroupingSetDescriptor(groupingKeys, 1, (Set<Integer>)globalGroupingSets);
    }

    public static class GroupingSetDescriptor {
        private final List<String> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        private GroupingSetDescriptor(List<String> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
            this.groupingKeys = groupingKeys;
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = globalGroupingSets;
        }

        public List<String> getGroupingKeys() {
            return this.groupingKeys;
        }

        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("keys", this.groupingKeys).add("count", this.groupingSetCount).add("globalSets", this.globalGroupingSets).toString();
        }
    }

    public static class Ordering {
        private final String field;
        private final SortItem.Ordering ordering;
        private final SortItem.NullOrdering nullOrdering;

        private Ordering(String field, SortItem.Ordering ordering, SortItem.NullOrdering nullOrdering) {
            this.field = field;
            this.ordering = ordering;
            this.nullOrdering = nullOrdering;
        }

        public String getField() {
            return this.field;
        }

        public SortItem.Ordering getOrdering() {
            return this.ordering;
        }

        public SortItem.NullOrdering getNullOrdering() {
            return this.nullOrdering;
        }

        public SortOrder getSortOrder() {
            Preconditions.checkState((this.nullOrdering != SortItem.NullOrdering.UNDEFINED ? 1 : 0) != 0, (Object)"nullOrdering is undefined");
            if (this.ordering == SortItem.Ordering.ASCENDING) {
                if (this.nullOrdering == SortItem.NullOrdering.FIRST) {
                    return SortOrder.ASC_NULLS_FIRST;
                }
                return SortOrder.ASC_NULLS_LAST;
            }
            Preconditions.checkState((this.ordering == SortItem.Ordering.DESCENDING ? 1 : 0) != 0);
            if (this.nullOrdering == SortItem.NullOrdering.FIRST) {
                return SortOrder.DESC_NULLS_FIRST;
            }
            return SortOrder.DESC_NULLS_LAST;
        }

        public String toString() {
            String result = this.field + " " + this.ordering;
            if (this.nullOrdering != SortItem.NullOrdering.UNDEFINED) {
                result = result + " NULLS " + this.nullOrdering;
            }
            return result;
        }
    }

    public static class UnnestMapping {
        private final String input;
        private final List<String> outputs;

        private UnnestMapping(String input, List<String> outputs) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.outputs = Objects.requireNonNull(outputs, "outputs is null");
        }

        public static UnnestMapping unnestMapping(String input, List<String> outputs) {
            return new UnnestMapping(input, outputs);
        }

        public String getInput() {
            return this.input;
        }

        public List<String> getOutputs() {
            return this.outputs;
        }
    }

    public static class DynamicFilterPattern {
        private final Expression probe;
        private final ComparisonExpression.Operator operator;
        private final SymbolAlias build;
        private final boolean nullAllowed;

        public DynamicFilterPattern(String probeExpression, ComparisonExpression.Operator operator, String buildAlias, boolean nullAllowed) {
            this(PlanBuilder.expression(probeExpression), operator, buildAlias, nullAllowed);
        }

        public DynamicFilterPattern(Expression probe, ComparisonExpression.Operator operator, String buildAlias, boolean nullAllowed) {
            this.probe = Objects.requireNonNull(probe, "probe is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
            this.build = new SymbolAlias(Objects.requireNonNull(buildAlias, "buildAlias is null"));
            this.nullAllowed = nullAllowed;
        }

        public DynamicFilterPattern(String probeAlias, ComparisonExpression.Operator operator, String buildAlias) {
            this(probeAlias, operator, buildAlias, false);
        }

        Expression getExpression(SymbolAliases aliases) {
            Expression probeMapped = DynamicFilterPattern.symbolMapper(aliases).map(this.probe);
            if (this.nullAllowed) {
                return new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, probeMapped, (Expression)this.build.toSymbol(aliases).toSymbolReference()));
            }
            return new ComparisonExpression(this.operator, probeMapped, (Expression)this.build.toSymbol(aliases).toSymbolReference());
        }

        private static SymbolMapper symbolMapper(SymbolAliases symbolAliases) {
            return new SymbolMapper(symbol -> Symbol.from((Expression)symbolAliases.get(symbol.getName())));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("probe", (Object)this.probe).add("operator", (Object)this.operator).add("build", (Object)this.build).toString();
        }
    }
}

