/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.TaskCountEstimator;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import io.trino.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.Test;

public class TestMultipleDistinctAggregationToMarkDistinct
extends BaseRuleTest {
    private static final int NODES_COUNT = 4;
    private static final TaskCountEstimator TASK_COUNT_ESTIMATOR = new TaskCountEstimator(() -> 4);

    public TestMultipleDistinctAggregationToMarkDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoDistinct() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"))))).doesNotFire();
    }

    @Test
    public void testSingleDistinct() {
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"))))).doesNotFire();
    }

    @Test
    public void testMultipleAggregations() {
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("sum(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input"))))).doesNotFire();
    }

    @Test
    public void testDistinctWithFilter() {
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1) filter (where filter1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(DISTINCT input2) filter (where filter2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentity(p.symbol("input1")).putIdentity(p.symbol("input2")).put(p.symbol("filter1"), PlanBuilder.expression("input2 > 0")).put(p.symbol("filter2"), PlanBuilder.expression("input1 > 0")).build(), (PlanNode)p.values(p.symbol("input1"), p.symbol("input2")))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1) filter (where filter1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(DISTINCT input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentity(p.symbol("input1")).putIdentity(p.symbol("input2")).put(p.symbol("filter1"), PlanBuilder.expression("input2 > 0")).put(p.symbol("filter2"), PlanBuilder.expression("input1 > 0")).build(), (PlanNode)p.values(p.symbol("input1"), p.symbol("input2")))))).doesNotFire();
    }

    @Test
    public void testGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(DISTINCT input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input1")), Optional.of("output2"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input2"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mark_input1", (Object)"mark_input2"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.markDistinct("mark_input2", (List<String>)ImmutableList.of((Object)"input2"), PlanMatchPattern.markDistinct("mark_input1", (List<String>)ImmutableList.of((Object)"input1"), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"input1", (Object)0, (Object)"input2", (Object)1))))));
    }

    @Test
    public void testAggregationNDV() {
        PlanNodeId aggregationNodeId = new PlanNodeId("aggregationNodeId");
        Function<PlanBuilder, PlanNode> plan = p -> p.aggregation(builder -> builder.nodeId(aggregationNodeId).singleGroupingSet(p.symbol("key")).addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("sum(input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input"), p.symbol("key"))));
        PlanMatchPattern expectedMarkDistinct = PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input")), Optional.of("output2"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"input"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mark_input"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.markDistinct("mark_input", (List<String>)ImmutableList.of((Object)"input", (Object)"key"), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"input", (Object)0, (Object)"key", (Object)1))));
        int clusterThreadCount = 4 * (Integer)this.tester().getSession().getSystemProperty("task_concurrency", Integer.class);
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(2 * clusterThreadCount)).build()).matches(expectedMarkDistinct);
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount(Double.NaN).build()).matches(expectedMarkDistinct);
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).setSystemProperty("optimize_mixed_distinct_aggregations", "true").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(50 * clusterThreadCount)).build()).matches(expectedMarkDistinct);
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).setSystemProperty("optimize_mixed_distinct_aggregations", "false").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(50 * clusterThreadCount)).build()).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.nodeId(aggregationNodeId).singleGroupingSet(p.symbol("key")).addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(DISTINCT input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"), p.symbol("key"))))).setSystemProperty("optimize_mixed_distinct_aggregations", "true").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(50 * clusterThreadCount)).build()).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(1000 * clusterThreadCount)).build()).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).setSystemProperty("mark_distinct_strategy", "always").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(1000 * clusterThreadCount)).build()).matches(expectedMarkDistinct);
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).setSystemProperty("use_mark_distinct", "true").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(1000 * clusterThreadCount)).build()).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).setSystemProperty("mark_distinct_strategy", "none").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(2 * clusterThreadCount)).build()).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(plan).setSystemProperty("use_mark_distinct", "false").overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(2 * clusterThreadCount)).build()).doesNotFire();
        this.tester().assertThat((Rule<?>)new MultipleDistinctAggregationToMarkDistinct(TASK_COUNT_ESTIMATOR)).on(p -> p.aggregation(builder -> builder.nodeId(aggregationNodeId).singleGroupingSet(p.symbol("key1"), p.symbol("key2")).addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("sum(input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input"), p.symbol("key1"), p.symbol("key2"))))).overrideStats(aggregationNodeId.toString(), PlanNodeStatsEstimate.builder().setOutputRowCount((double)(1000 * clusterThreadCount)).build()).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key1", "key2"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input")), Optional.of("output2"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"input"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mark_input"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.markDistinct("mark_input", (List<String>)ImmutableList.of((Object)"input", (Object)"key1", (Object)"key2"), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"input", (Object)0, (Object)"key1", (Object)1, (Object)"key2", (Object)2)))));
    }
}

