/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SchemaTableName;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneMergeSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneMergeSourceColumns
extends BaseRuleTest {
    public TestPruneMergeSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneInputColumn() {
        this.tester().assertThat((Rule<?>)new PruneMergeSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol mergeRow = p.symbol("merge_row");
            Symbol rowId = p.symbol("row_id");
            Symbol partialRows = p.symbol("partial_rows");
            Symbol fragment = p.symbol("fragment");
            return p.merge(new SchemaTableName("schema", "table"), (PlanNode)p.values(a, mergeRow, rowId), mergeRow, rowId, (List<Symbol>)ImmutableList.of((Object)partialRows, (Object)fragment));
        }).matches(PlanMatchPattern.node(MergeWriterNode.class, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_id", (Object)PlanMatchPattern.expression("row_id"), (Object)"merge_row", (Object)PlanMatchPattern.expression("merge_row")), PlanMatchPattern.values("a", "merge_row", "row_id"))));
    }

    @Test
    public void testDoNotPruneRowId() {
        this.tester().assertThat((Rule<?>)new PruneMergeSourceColumns()).on(p -> {
            Symbol mergeRow = p.symbol("merge_row");
            Symbol rowId = p.symbol("row_id");
            Symbol partialRows = p.symbol("partial_rows");
            Symbol fragment = p.symbol("fragment");
            return p.merge(new SchemaTableName("schema", "table"), (PlanNode)p.values(mergeRow, rowId), mergeRow, rowId, (List<Symbol>)ImmutableList.of((Object)partialRows, (Object)fragment));
        }).doesNotFire();
    }
}

