/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantPredicateAboveTableScan;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRemoveRedundantPredicateAboveTableScan
extends BaseRuleTest {
    private RemoveRedundantPredicateAboveTableScan removeRedundantPredicateAboveTableScan;
    private TableHandle nationTableHandle;
    private TableHandle ordersTableHandle;

    public TestRemoveRedundantPredicateAboveTableScan() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setUpBeforeClass() {
        this.removeRedundantPredicateAboveTableScan = new RemoveRedundantPredicateAboveTableScan(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer());
        CatalogHandle catalogHandle = this.tester().getCurrentCatalogHandle();
        TpchTableHandle nation = new TpchTableHandle("sf1", "nation", 1.0);
        this.nationTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)nation, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
        TpchTableHandle orders = new TpchTableHandle("sf1", "orders", 1.0);
        this.ordersTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)orders, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsSame() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsSame$1((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsWider$2((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsNarrower() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsNarrower$3((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.filter(PlanBuilder.expression("nationkey IN (BIGINT '44', BIGINT '45')"), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)44L, (Object)45L, (Object)46L))), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void doesNotConsumeRemainingPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotConsumeRemainingPredicateIfNewDomainIsWider$4((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.filter((Expression)LogicalExpression.and((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)FunctionCallBuilder.resolve((Session)this.tester().getSession(), (Metadata)this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "17")), (Expression)new GenericLiteral("BIGINT", "44"))), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void doesNotFireOnNonDeterministicPredicate() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotFireOnNonDeterministicPredicate$5((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void doesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(p -> p.filter(PlanBuilder.expression("nationkey % 17 = BIGINT '44' AND nationkey % 15 = BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all()))).doesNotFire();
    }

    @Test
    public void doesNotAddTableLayoutToFilterTableScan() {
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnNoTableScanPredicate() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotFireOnNoTableScanPredicate$8((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void doesNotFireOnNotFullyExtractedConjunct() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("name", (Type)VarcharType.VARCHAR);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotFireOnNotFullyExtractedConjunct$9((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void skipNotFullyExtractedConjunct() {
        TpchColumnHandle textColumnHandle = new TpchColumnHandle("name", (Type)VarcharType.VARCHAR);
        TpchColumnHandle nationKeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$skipNotFullyExtractedConjunct$10((ColumnHandle)textColumnHandle, (ColumnHandle)nationKeyColumnHandle, arg_0)).matches(PlanMatchPattern.filter(PlanBuilder.expression("if(name = 'x', true, false)"), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L), (Object)"name", (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name"))));
    }

    private /* synthetic */ PlanNode lambda$skipNotFullyExtractedConjunct$10(ColumnHandle textColumnHandle, ColumnHandle nationKeyColumnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("if(name = 'x', true, false) AND nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("name", (Type)VarcharType.VARCHAR), (Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("name", (Type)VarcharType.VARCHAR), (Object)textColumnHandle, (Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)nationKeyColumnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)textColumnHandle, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)nationKeyColumnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$doesNotFireOnNotFullyExtractedConjunct$9(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("name LIKE 'LARGE PLATED %'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("name", (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("name", (Type)VarcharType.VARCHAR), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))))));
    }

    private /* synthetic */ PlanNode lambda$doesNotFireOnNoTableScanPredicate$8(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("(nationkey > 3 OR nationkey > 0) AND (nationkey > 3 OR nationkey < 1)"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()));
    }

    private /* synthetic */ PlanNode lambda$doesNotFireOnNonDeterministicPredicate$5(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)FunctionCallBuilder.resolve((Session)this.tester().getSession(), (Metadata)this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()));
    }

    private /* synthetic */ PlanNode lambda$doesNotConsumeRemainingPredicateIfNewDomainIsWider$4(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)FunctionCallBuilder.resolve((Session)this.tester().getSession(), (Metadata)this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "17")), (Expression)new GenericLiteral("BIGINT", "44")), (Object)LogicalExpression.or((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "44")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "45"))))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsNarrower$3(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44' OR nationkey = BIGINT '45' OR nationkey = BIGINT '47'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)44L, (Object)45L, (Object)46L))))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsWider$2(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44' OR nationkey = BIGINT '45'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsSame$1(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }
}

