/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveTrivialFilters;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import org.testng.annotations.Test;

public class TestRemoveTrivialFilters
extends BaseRuleTest {
    public TestRemoveTrivialFilters() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter(PlanBuilder.expression("1 = 1"), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testRemovesTrueFilter() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter(PlanBuilder.expression("TRUE"), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.values(new String[0]));
    }

    @Test
    public void testRemovesFalseFilter() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter(PlanBuilder.expression("FALSE"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1"))))).matches(PlanMatchPattern.values("a"));
    }

    @Test
    public void testRemovesNullFilter() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter(PlanBuilder.expression("CAST(null AS boolean)"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1"))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of()));
    }
}

