/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.UseNonPartitionedJoinLookupSource;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestUseNonPartitionedJoinLookupSource
extends BaseRuleTest {
    public TestUseNonPartitionedJoinLookupSource() {
        super(new Plugin[0]);
    }

    @Test
    public void testLocalGatheringExchangeNotChanged() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.gatheringExchange(ExchangeNode.Scope.LOCAL, (PlanNode)p.values(b)), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testLocalRepartitioningExchangeChangedToGather() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)this.repartitioningExchange((PlanBuilder)p, b, (PlanNode)p.values(b)), new JoinNode.EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.values("b")))));
    }

    @Test
    public void testLeftRepartitionNotChanged() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)this.repartitioningExchange((PlanBuilder)p, a, (PlanNode)p.values(a)), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testRepartitioningExchangeNotChangedIfBuildSideTooBig() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)this.repartitioningExchange((PlanBuilder)p, b, (PlanNode)p.values(new PlanNodeId("source"), b)), new JoinNode.EquiJoinClause[0]);
        }).overrideStats("source", PlanNodeStatsEstimate.builder().setOutputRowCount(5000001.0).build()).doesNotFire();
    }

    @Test
    public void testRepartitioningExchangeNotChangedIfRuleDisabled() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)this.repartitioningExchange((PlanBuilder)p, b, (PlanNode)p.values(b)), new JoinNode.EquiJoinClause[0]);
        }).setSystemProperty("join_partitioned_build_min_row_count", "0").doesNotFire();
    }

    @Test
    public void testRepartitioningExchangeNotChangedIfBuildSideContainsJoin() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)this.repartitioningExchange((PlanBuilder)p, b, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(c), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0])), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testRepartitioningExchangeNotChangedIfBuildSideContainsUnnest() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)this.repartitioningExchange((PlanBuilder)p, b, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(c, (List)ImmutableList.of((Object)b))), (PlanNode)p.values(c))), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testRepartitioningExchangeNotChangedIfBuildSideRowCountUnknown() {
        this.tester().assertThat((Rule<?>)new UseNonPartitionedJoinLookupSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)this.repartitioningExchange((PlanBuilder)p, b, (PlanNode)p.values(new PlanNodeId("source"), b)), new JoinNode.EquiJoinClause[0]);
        }).overrideStats("source", PlanNodeStatsEstimate.builder().setOutputRowCount(Double.NaN).build()).doesNotFire();
    }

    private ExchangeNode repartitioningExchange(PlanBuilder p, Symbol symbol, PlanNode source) {
        return p.exchange(builder -> builder.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addSource(source).addInputsSet(symbol));
    }
}

