/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnector;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableProcedureExecutionMode;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TestTableScanNodePartitioning;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.testng.annotations.Test;

public class TestLimitMaxWriterNodesCount
extends BasePlanTest {
    private static final String partitionedTable = "partitioned_target_table";
    private static final String unPartitionedTable = "unpartitioned_target_table";
    private static final String bucketedTable = "partitioned_bucketed_target_table";
    private static final String sourceTable = "source_table";
    private static final String catalogName = "mock";
    private static final String catalogNameWithMaxWriterTasksSpecified = "mock_with_max_writer_tasks";
    public static final ConnectorPartitioningHandle SINGLE_BUCKET_HANDLE = new ConnectorPartitioningHandle(){};

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        ImmutableList tables = ImmutableList.of((Object)partitionedTable, (Object)unPartitionedTable, (Object)sourceTable, (Object)bucketedTable);
        Session session = TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("default").build();
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)session);
        queryRunner.createCatalog(catalogName, (ConnectorFactory)this.prepareConnectorFactory(catalogName, OptionalInt.empty(), (List<String>)tables), (Map)ImmutableMap.of());
        queryRunner.createCatalog(catalogNameWithMaxWriterTasksSpecified, (ConnectorFactory)this.prepareConnectorFactory(catalogNameWithMaxWriterTasksSpecified, OptionalInt.of(1), (List<String>)tables), (Map)ImmutableMap.of());
        return queryRunner;
    }

    private MockConnectorFactory prepareConnectorFactory(String catalogName, OptionalInt maxWriterTasks, List<String> tables) {
        return MockConnectorFactory.builder().withGetTableHandle((session, tableName) -> {
            if (tables.contains(tableName.getTableName())) {
                return new MockConnectorTableHandle((SchemaTableName)tableName);
            }
            return null;
        }).withGetInsertLayout((session, tableMetadata) -> {
            if (tableMetadata.getTableName().equals(partitionedTable)) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"column_a")));
            }
            if (tableMetadata.getTableName().equals(bucketedTable)) {
                return Optional.of(new ConnectorTableLayout(SINGLE_BUCKET_HANDLE, (List)ImmutableList.of((Object)"column_a")));
            }
            return Optional.empty();
        }).withGetNewTableLayout((session, tableMetadata) -> {
            if (tableMetadata.getTable().getTableName().equals(partitionedTable)) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"column_a")));
            }
            if (tableMetadata.getTable().getTableName().equals(bucketedTable)) {
                return Optional.of(new ConnectorTableLayout(SINGLE_BUCKET_HANDLE, (List)ImmutableList.of((Object)"column_a")));
            }
            return Optional.empty();
        }).withGetLayoutForTableExecute((session, tableHandle) -> {
            MockConnector.MockConnectorTableExecuteHandle tableExecuteHandle = (MockConnector.MockConnectorTableExecuteHandle)tableHandle;
            if (tableExecuteHandle.getSchemaTableName().getTableName().equals(partitionedTable)) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"column_a")));
            }
            return Optional.empty();
        }).withTableProcedures((Iterable<TableProcedureMetadata>)ImmutableSet.of((Object)new TableProcedureMetadata("OPTIMIZE", TableProcedureExecutionMode.distributedWithFilteringAndRepartitioning(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"file_size_threshold", (String)"file_size_threshold", (String)"10GB", (boolean)false))))).withPartitionProvider(new TestTableScanNodePartitioning.TestPartitioningProvider((InternalNodeManager)new InMemoryNodeManager(new InternalNode[0]))).withSupportsReportingWrittenBytes(true).withMaxWriterTasks(maxWriterTasks).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("column_a", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("column_b", (Type)VarcharType.VARCHAR))).withName(catalogName).build();
    }

    @Test
    public void testPlanWhenInsertToUnpartitionedTableScaleWritersDisabled() {
        String query = "INSERT INTO unpartitioned_target_table VALUES ('one', 'two')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("scale_writers", "false").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, Optional.of(2), PlanMatchPattern.values("column_a", "column_b"))))));
    }

    @Test
    public void testPlanWhenInsertToUnpartitionedTableScaleWritersEnabled() {
        String query = "INSERT INTO unpartitioned_target_table VALUES ('one', 'two')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("scale_writers", "true").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION, Optional.of(2), PlanMatchPattern.values("column_a", "column_b"))))));
    }

    @Test
    public void testPlanWhenInsertToUnpartitionedSourceDistribution() {
        String query = "INSERT INTO unpartitioned_target_table VALUES ('one', 'two')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("scale_writers", "false").setSystemProperty("redistribute_writes", "false").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), PlanMatchPattern.values("column_a", "column_b")))));
    }

    @Test
    public void testPlanWhenInsertToPartitionedTablePreferredPartitioningEnabled() {
        String query = "INSERT INTO partitioned_target_table VALUES ('one', 'two'), ('three', 'four')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("use_preferred_write_partitioning", "true").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, Optional.of(2), PlanMatchPattern.project(PlanMatchPattern.values("column_a", "column_b"))))))));
    }

    @Test
    public void testPlanWhenInsertToPartitionedAndBucketedTable() {
        String query = "INSERT INTO partitioned_bucketed_target_table VALUES ('one', 'two'), ('three', 'four')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.values("column_a", "column_b"))))));
    }

    @Test
    public void testPlanWhenMaxWriterTasksSpecified() {
        String query = "INSERT INTO partitioned_target_table VALUES ('one', 'two'), ('three', 'four')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("use_preferred_write_partitioning", "true").setCatalog(catalogNameWithMaxWriterTasksSpecified).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, Optional.of(1), PlanMatchPattern.project(PlanMatchPattern.values("column_a", "column_b"))))))));
    }

    @Test
    public void testPlanWhenRetryPolicyIsTask() {
        String query = "INSERT INTO partitioned_target_table VALUES ('one', 'two'), ('three', 'four')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("retry_policy", "TASK").setCatalog(catalogNameWithMaxWriterTasksSpecified).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, Optional.empty(), PlanMatchPattern.project(PlanMatchPattern.values("column_a", "column_b"))))))));
    }

    @Test
    public void testPlanWhenExecuteOnUnpartitionedTableScaleWritersDisabled() {
        String query = "ALTER TABLE unpartitioned_target_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("scale_writers", "false").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, Optional.of(2), PlanMatchPattern.tableScan(unPartitionedTable))))));
    }

    @Test
    public void testPlanWhenTableExecuteToUnpartitionedTableScaleWritersEnabled() {
        String query = "ALTER TABLE unpartitioned_target_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("scale_writers", "true").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION, Optional.of(2), PlanMatchPattern.tableScan(unPartitionedTable))))));
    }

    @Test
    public void testPlanWhenTableExecuteToUnpartitionedSourceDistribution() {
        String query = "ALTER TABLE unpartitioned_target_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("scale_writers", "false").setSystemProperty("redistribute_writes", "false").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), PlanMatchPattern.tableScan(unPartitionedTable)))));
    }

    @Test
    public void testPlanWhenTableExecuteToPartitionedTablePreferredPartitioningEnabled() {
        String query = "ALTER TABLE partitioned_target_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("use_preferred_write_partitioning", "true").setCatalog(catalogName).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, Optional.of(2), PlanMatchPattern.project(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testPlanTableExecuteWhenMaxWriterTasksSpecified() {
        String query = "ALTER TABLE partitioned_target_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("use_preferred_write_partitioning", "true").setCatalog(catalogNameWithMaxWriterTasksSpecified).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, Optional.of(1), PlanMatchPattern.project(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testPlanTableExecuteWhenRetryPolicyIsTask() {
        String query = "ALTER TABLE partitioned_target_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_writer_tasks_count", "2").setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("retry_policy", "TASK").setCatalog(catalogNameWithMaxWriterTasksSpecified).build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, Optional.empty(), PlanMatchPattern.project(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))));
    }
}

