/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.json.ir.IrAbsMethod;
import io.trino.json.ir.IrArithmeticBinary;
import io.trino.json.ir.IrArithmeticUnary;
import io.trino.json.ir.IrArrayAccessor;
import io.trino.json.ir.IrCeilingMethod;
import io.trino.json.ir.IrConstantJsonSequence;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrDatetimeMethod;
import io.trino.json.ir.IrDescendantMemberAccessor;
import io.trino.json.ir.IrDoubleMethod;
import io.trino.json.ir.IrFloorMethod;
import io.trino.json.ir.IrJsonNull;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrKeyValueMethod;
import io.trino.json.ir.IrLastIndexVariable;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrNamedJsonVariable;
import io.trino.json.ir.IrNamedValueVariable;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrSizeMethod;
import io.trino.json.ir.IrTypeMethod;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.PathNodes;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonPath2016Type;
import io.trino.type.TypeDeserializer;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.testng.annotations.Test;

public class TestJsonPath2016TypeSerialization {
    private static final Type JSON_PATH_2016 = new JsonPath2016Type(new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER), (BlockEncodingSerde)new TestingBlockEncodingSerde());
    private static final RecursiveComparisonConfiguration COMPARISON_CONFIGURATION = RecursiveComparisonConfiguration.builder().withStrictTypeChecking(true).build();

    @Test
    public void testJsonPathMode() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrJsonNull.JSON_NULL));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(false, (IrPathNode)IrJsonNull.JSON_NULL));
    }

    @Test
    public void testLiterals() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, PathNodes.literal((Type)DecimalType.createDecimalType((int)2, (int)1), 1L)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, PathNodes.literal((Type)DoubleType.DOUBLE, 1.0)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, PathNodes.literal((Type)IntegerType.INTEGER, 1L)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, PathNodes.literal((Type)BigintType.BIGINT, 1000000000000L)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"some_text"))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, PathNodes.literal((Type)BooleanType.BOOLEAN, false)));
    }

    @Test
    public void testContextVariable() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrContextVariable(Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrContextVariable(Optional.of(DoubleType.DOUBLE))));
    }

    @Test
    public void testNamedVariables() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrNamedJsonVariable(5, Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrNamedJsonVariable(5, Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrNamedValueVariable(5, Optional.of(DoubleType.DOUBLE))));
    }

    @Test
    public void testMethods() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrAbsMethod(PathNodes.literal((Type)DoubleType.DOUBLE, 1.0), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrCeilingMethod(PathNodes.literal((Type)DoubleType.DOUBLE, 1.0), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrDatetimeMethod(PathNodes.literal((Type)BigintType.BIGINT, 1L), Optional.of("some_time_format"), Optional.of(TimeType.createTimeType((int)3)))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrDoubleMethod(PathNodes.literal((Type)BigintType.BIGINT, 1L), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrFloorMethod(PathNodes.literal((Type)DoubleType.DOUBLE, 1.0), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrKeyValueMethod((IrPathNode)IrJsonNull.JSON_NULL)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrSizeMethod((IrPathNode)IrJsonNull.JSON_NULL, Optional.of(IntegerType.INTEGER))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrTypeMethod((IrPathNode)IrJsonNull.JSON_NULL, Optional.of(VarcharType.createVarcharType((int)7)))));
    }

    @Test
    public void testArrayAccessor() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArrayAccessor((IrPathNode)IrJsonNull.JSON_NULL, (List)ImmutableList.of(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArrayAccessor((IrPathNode)IrJsonNull.JSON_NULL, (List)ImmutableList.of((Object)new IrArrayAccessor.Subscript(PathNodes.literal((Type)IntegerType.INTEGER, 0L), Optional.of(PathNodes.literal((Type)IntegerType.INTEGER, 1L))), (Object)new IrArrayAccessor.Subscript(PathNodes.literal((Type)IntegerType.INTEGER, 3L), Optional.of(PathNodes.literal((Type)IntegerType.INTEGER, 5L))), (Object)new IrArrayAccessor.Subscript(PathNodes.literal((Type)IntegerType.INTEGER, 7L), Optional.empty())), Optional.of(VarcharType.VARCHAR))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArrayAccessor((IrPathNode)IrJsonNull.JSON_NULL, (List)ImmutableList.of((Object)new IrArrayAccessor.Subscript((IrPathNode)new IrLastIndexVariable(Optional.of(IntegerType.INTEGER)), Optional.empty())), Optional.empty())));
    }

    @Test
    public void testMemberAccessor() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrMemberAccessor((IrPathNode)IrJsonNull.JSON_NULL, Optional.empty(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrMemberAccessor((IrPathNode)IrJsonNull.JSON_NULL, Optional.of("some_key"), Optional.of(BigintType.BIGINT))));
    }

    @Test
    public void testDescendantMemberAccessor() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrDescendantMemberAccessor((IrPathNode)IrJsonNull.JSON_NULL, "some_key", Optional.empty())));
    }

    @Test
    public void testArithmeticBinary() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticBinary(IrArithmeticBinary.Operator.ADD, (IrPathNode)IrJsonNull.JSON_NULL, (IrPathNode)IrJsonNull.JSON_NULL, Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticBinary(IrArithmeticBinary.Operator.ADD, PathNodes.literal((Type)IntegerType.INTEGER, 1L), PathNodes.literal((Type)BigintType.BIGINT, 2L), Optional.of(BigintType.BIGINT))));
    }

    @Test
    public void testArithmeticUnary() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.PLUS, (IrPathNode)IrJsonNull.JSON_NULL, Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, (IrPathNode)IrJsonNull.JSON_NULL, Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, PathNodes.literal((Type)IntegerType.INTEGER, 1L), Optional.of(IntegerType.INTEGER))));
    }

    @Test
    public void testConstantJsonSequence() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrConstantJsonSequence.EMPTY_SEQUENCE));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrConstantJsonSequence.singletonSequence((JsonNode)NullNode.getInstance(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrConstantJsonSequence.singletonSequence((JsonNode)BooleanNode.TRUE, Optional.of(BooleanType.BOOLEAN))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrConstantJsonSequence((List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2), (Object)IntNode.valueOf((int)3)), Optional.of(IntegerType.INTEGER))));
    }

    @Test
    public void testNestedStructure() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrTypeMethod((IrPathNode)new IrArithmeticBinary(IrArithmeticBinary.Operator.MULTIPLY, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, (IrPathNode)new IrAbsMethod((IrPathNode)new IrFloorMethod(PathNodes.literal((Type)IntegerType.INTEGER, 1L), Optional.of(IntegerType.INTEGER)), Optional.of(IntegerType.INTEGER)), Optional.of(IntegerType.INTEGER)), (IrPathNode)new IrCeilingMethod((IrPathNode)new IrMemberAccessor((IrPathNode)new IrContextVariable(Optional.empty()), Optional.of("some_key"), Optional.of(BigintType.BIGINT)), Optional.of(BigintType.BIGINT)), Optional.of(BigintType.BIGINT)), Optional.of(VarcharType.createVarcharType((int)7)))));
    }

    private static void assertJsonRoundTrip(IrJsonPath object) {
        BlockBuilder blockBuilder = JSON_PATH_2016.createBlockBuilder(null, 1);
        JSON_PATH_2016.writeObject(blockBuilder, (Object)object);
        Block serialized = blockBuilder.build();
        Object deserialized = JSON_PATH_2016.getObject(serialized, 0);
        ((RecursiveComparisonAssert)Assertions.assertThat(() -> new RecursiveComparisonAssert(deserialized, COMPARISON_CONFIGURATION))).isEqualTo((Object)object);
    }
}

