/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import java.io.File;
import java.util.List;
import javax.validation.constraints.NotNull;

public class FileCatalogStoreConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private File catalogConfigurationDir = new File("etc/catalog/");
    private List<String> disabledCatalogs;
    private boolean readOnly;

    @NotNull
    public File getCatalogConfigurationDir() {
        return this.catalogConfigurationDir;
    }

    @LegacyConfig(value={"plugin.config-dir"})
    @Config(value="catalog.config-dir")
    public FileCatalogStoreConfig setCatalogConfigurationDir(File dir) {
        this.catalogConfigurationDir = dir;
        return this;
    }

    public List<String> getDisabledCatalogs() {
        return this.disabledCatalogs;
    }

    @Config(value="catalog.disabled-catalogs")
    public FileCatalogStoreConfig setDisabledCatalogs(String catalogs) {
        this.disabledCatalogs = catalogs == null ? null : SPLITTER.splitToList((CharSequence)catalogs);
        return this;
    }

    public FileCatalogStoreConfig setDisabledCatalogs(List<String> catalogs) {
        this.disabledCatalogs = catalogs == null ? null : ImmutableList.copyOf(catalogs);
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Config(value="catalog.read-only")
    public FileCatalogStoreConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }
}

