/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogProperties;
import io.trino.connector.ConnectorName;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.spi.connector.CatalogHandle;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WorkerDynamicCatalogManager
implements ConnectorServicesProvider {
    private static final Logger log = Logger.get(WorkerDynamicCatalogManager.class);
    private final CatalogFactory catalogFactory;
    private final Lock catalogsUpdateLock = new ReentrantLock();
    private final ConcurrentMap<CatalogHandle, CatalogConnector> catalogs = new ConcurrentHashMap<CatalogHandle, CatalogConnector>();
    @GuardedBy(value="catalogsUpdateLock")
    private boolean stopped;

    @Inject
    public WorkerDynamicCatalogManager(CatalogFactory catalogFactory) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
    }

    @PreDestroy
    public void stop() {
        ImmutableList catalogs;
        this.catalogsUpdateLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            catalogs = ImmutableList.copyOf(this.catalogs.values());
            this.catalogs.clear();
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
        for (CatalogConnector connector : catalogs) {
            connector.shutdown();
        }
    }

    @Override
    public void loadInitialCatalogs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureCatalogsLoaded(Session session, List<CatalogProperties> expectedCatalogs) {
        if (this.getMissingCatalogs(expectedCatalogs).isEmpty()) {
            return;
        }
        this.catalogsUpdateLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            for (CatalogProperties catalog : this.getMissingCatalogs(expectedCatalogs)) {
                Preconditions.checkArgument((!catalog.getCatalogHandle().equals((Object)GlobalSystemConnector.CATALOG_HANDLE) ? 1 : 0) != 0, (Object)"Global system catalog not registered");
                CatalogConnector newCatalog = this.catalogFactory.createCatalog(catalog);
                this.catalogs.put(catalog.getCatalogHandle(), newCatalog);
                log.info("Added catalog: " + catalog.getCatalogHandle());
            }
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneCatalogs(Set<CatalogHandle> catalogsInUse) {
        ArrayList<CatalogConnector> removedCatalogs = new ArrayList<CatalogConnector>();
        this.catalogsUpdateLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            Iterator iterator = this.catalogs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (catalogsInUse.contains(entry.getKey())) continue;
                iterator.remove();
                removedCatalogs.add((CatalogConnector)entry.getValue());
            }
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
        for (CatalogConnector removedCatalog : removedCatalogs) {
            try {
                removedCatalog.shutdown();
            }
            catch (Throwable e) {
                log.error(e, "Error shutting down catalog: %s".formatted(removedCatalog));
            }
        }
        if (!removedCatalogs.isEmpty()) {
            List<String> sortedHandles = removedCatalogs.stream().map(connector -> connector.getCatalogHandle().toString()).sorted().toList();
            log.info("Pruned catalogs: %s", new Object[]{sortedHandles});
        }
    }

    private List<CatalogProperties> getMissingCatalogs(List<CatalogProperties> expectedCatalogs) {
        return (List)expectedCatalogs.stream().filter(catalog -> !this.catalogs.containsKey(catalog.getCatalogHandle())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
        CatalogConnector catalogConnector = (CatalogConnector)this.catalogs.get(catalogHandle.getRootCatalogHandle());
        Preconditions.checkArgument((catalogConnector != null ? 1 : 0) != 0, (String)"No catalog '%s'", (Object)catalogHandle.getCatalogName());
        return catalogConnector.getMaterializedConnector(catalogHandle.getType());
    }

    public void registerGlobalSystemConnector(GlobalSystemConnector connector) {
        Objects.requireNonNull(connector, "connector is null");
        this.catalogsUpdateLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            CatalogConnector catalog = this.catalogFactory.createCatalog(GlobalSystemConnector.CATALOG_HANDLE, new ConnectorName("system"), connector);
            if (this.catalogs.putIfAbsent(GlobalSystemConnector.CATALOG_HANDLE, catalog) != null) {
                throw new IllegalStateException("Global system catalog already registered");
            }
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
    }
}

