/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.metadata.MetadataUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class TransactionsSystemTable
implements SystemTable {
    public static final SchemaTableName TRANSACTIONS_TABLE_NAME = new SchemaTableName("runtime", "transactions");
    private final ConnectorTableMetadata transactionsTable;
    private final TransactionManager transactionManager;

    @Inject
    public TransactionsSystemTable(TypeManager typeManager, TransactionManager transactionManager) {
        this.transactionsTable = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TRANSACTIONS_TABLE_NAME).column("transaction_id", (Type)VarcharType.createUnboundedVarcharType()).column("isolation_level", (Type)VarcharType.createUnboundedVarcharType()).column("read_only", (Type)BooleanType.BOOLEAN).column("auto_commit_context", (Type)BooleanType.BOOLEAN).column("create_time", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("idle_time_secs", (Type)BigintType.BIGINT).column("written_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("catalogs", typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.createUnboundedVarcharType().getTypeSignature())))).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.transactionsTable;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.transactionsTable);
        for (TransactionInfo info : this.transactionManager.getAllTransactionInfos()) {
            table.addRow(new Object[]{info.getTransactionId().toString(), info.getIsolationLevel().toString(), info.isReadOnly(), info.isAutoCommitContext(), TransactionsSystemTable.toTimestampWithTimeZoneMillis(info.getCreateTime()), (long)info.getIdleTime().getValue(TimeUnit.SECONDS), info.getWrittenCatalogName().orElse(null), TransactionsSystemTable.createStringsBlock(info.getCatalogNames())});
        }
        return table.build().cursor();
    }

    private static Block createStringsBlock(List<String> values) {
        VarcharType varchar = VarcharType.createUnboundedVarcharType();
        BlockBuilder builder = varchar.createBlockBuilder(null, values.size());
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            varchar.writeString(builder, value);
        }
        return builder.build();
    }

    private static Long toTimestampWithTimeZoneMillis(DateTime dateTime) {
        return DateTimeEncoding.packDateTimeWithZone((long)dateTime.getMillis(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }
}

