/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class DecoratingListeningExecutorService
extends ForwardingListeningExecutorService
implements ListeningExecutorService {
    @Nullable
    private static final MethodHandle CLOSE_METHOD;
    private final ListeningExecutorService delegate;
    private final TaskDecorator decorator;

    public DecoratingListeningExecutorService(ListeningExecutorService delegate, TaskDecorator decorator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.decorator = Objects.requireNonNull(decorator, "decorator is null");
    }

    protected ListeningExecutorService delegate() {
        return this.delegate;
    }

    public void execute(Runnable command) {
        this.delegate.execute(this.decorator.decorate(command));
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.delegate.submit(this.decorator.decorate(task));
    }

    public ListenableFuture<?> submit(Runnable task) {
        return this.delegate.submit(this.decorator.decorate(task));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.decorator.decorate(task), result);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll((Collection)tasks.stream().map(this.decorator::decorate).collect(ImmutableList.toImmutableList()));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll((Collection)tasks.stream().map(this.decorator::decorate).collect(ImmutableList.toImmutableList()), timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny((Collection)tasks.stream().map(this.decorator::decorate).collect(ImmutableList.toImmutableList()));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny((Collection)tasks.stream().map(this.decorator::decorate).collect(ImmutableList.toImmutableList()), timeout, unit);
    }

    public void shutdown() {
        super.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    public boolean isShutdown() {
        return super.isShutdown();
    }

    public boolean isTerminated() {
        return super.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return super.awaitTermination(timeout, unit);
    }

    public void close() {
        if (CLOSE_METHOD == null) {
            throw new UnsupportedOperationException("ExecutorService.close has close() method since Java 19. The DecoratingListeningExecutorService supports the method only when run with Java 19 runtime.");
        }
        try {
            CLOSE_METHOD.invoke(this.delegate());
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        Method closeMethod;
        try {
            closeMethod = ExecutorService.class.getMethod("close", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            closeMethod = null;
        }
        try {
            CLOSE_METHOD = closeMethod != null ? MethodHandles.lookup().unreflect(closeMethod) : null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface TaskDecorator {
        public Runnable decorate(Runnable var1);

        public <T> Callable<T> decorate(Callable<T> var1);
    }
}

