/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.Column;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Output;
import io.trino.sql.analyzer.OutputColumn;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.TableElement;
import io.trino.type.UnknownType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class CreateTableTask
implements DataDefinitionTask<CreateTable> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final ColumnPropertyManager columnPropertyManager;
    private final TablePropertyManager tablePropertyManager;

    @Inject
    public CreateTableTask(PlannerContext plannerContext, AccessControl accessControl, ColumnPropertyManager columnPropertyManager, TablePropertyManager tablePropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
    }

    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public ListenableFuture<Void> execute(CreateTable statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        return this.internalExecute(statement, stateMachine.getSession(), parameters, output -> stateMachine.setOutput(Optional.of(output)));
    }

    @VisibleForTesting
    ListenableFuture<Void> internalExecute(CreateTable statement, Session session, List<Expression> parameters, Consumer<Output> outputConsumer) {
        ConnectorTableMetadata tableMetadata;
        CatalogHandle catalogHandle;
        String catalogName;
        QualifiedObjectName tableName;
        block25: {
            Optional<TableHandle> tableHandle;
            Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
            Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterExtractor.bindParameters((Statement)statement, parameters);
            tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            try {
                tableHandle = this.plannerContext.getMetadata().getTableHandle(session, tableName);
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.UNSUPPORTED_TABLE_TYPE.toErrorCode())) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' of unsupported type already exists", tableName);
                }
                throw e;
            }
            if (tableHandle.isPresent()) {
                if (!statement.isNotExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", tableName);
                }
                return Futures.immediateVoidFuture();
            }
            catalogName = tableName.getCatalogName();
            catalogHandle = MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, catalogName);
            LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
            Object inheritedProperties = ImmutableMap.of();
            boolean includingProperties = false;
            for (TableElement element : statement.getElements()) {
                if (element instanceof ColumnDefinition) {
                    Type type;
                    ColumnDefinition column2 = (ColumnDefinition)element;
                    String name = column2.getName().getValue().toLowerCase(Locale.ENGLISH);
                    try {
                        type = this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(column2.getType()));
                    }
                    catch (TypeNotFoundException e) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (type.equals((Object)UnknownType.UNKNOWN)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (columns.containsKey(name)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)column2, "Column name '%s' specified more than once", column2.getName());
                    }
                    if (!column2.isNullable() && !this.plannerContext.getMetadata().getConnectorCapabilities(session, catalogHandle).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)column2, "Catalog '%s' does not support non-null column for column name '%s'", catalogName, column2.getName());
                    }
                    Map columnProperties = this.columnPropertyManager.getProperties(catalogName, catalogHandle, (Iterable)column2.getProperties(), session, this.plannerContext, this.accessControl, (Map)parameterLookup, true);
                    columns.put(name, ColumnMetadata.builder().setName(name).setType(type).setNullable(column2.isNullable()).setComment(column2.getComment()).setProperties(columnProperties).build());
                    continue;
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    QualifiedObjectName originalLikeTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, likeClause.getTableName());
                    if (this.plannerContext.getMetadata().getCatalogHandle(session, originalLikeTableName.getCatalogName()).isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "LIKE table catalog '%s' does not exist", originalLikeTableName.getCatalogName());
                    }
                    RedirectionAwareTableHandle redirection = this.plannerContext.getMetadata().getRedirectionAwareTableHandle(session, originalLikeTableName);
                    TableHandle likeTable = redirection.getTableHandle().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "LIKE table '%s' does not exist", originalLikeTableName));
                    LikeClause.PropertiesOption propertiesOption = likeClause.getPropertiesOption().orElse(LikeClause.PropertiesOption.EXCLUDING);
                    QualifiedObjectName likeTableName = redirection.getRedirectedTableName().orElse(originalLikeTableName);
                    if (propertiesOption == LikeClause.PropertiesOption.INCLUDING && !catalogName.equals(likeTableName.getCatalogName())) {
                        if (!originalLikeTableName.equals(likeTableName)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "CREATE TABLE LIKE table INCLUDING PROPERTIES across catalogs is not supported. LIKE table '%s' redirected to '%s'.", originalLikeTableName, likeTableName);
                        }
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "CREATE TABLE LIKE table INCLUDING PROPERTIES across catalogs is not supported", new Object[0]);
                    }
                    TableMetadata likeTableMetadata = this.plannerContext.getMetadata().getTableMetadata(session, likeTable);
                    if (propertiesOption == LikeClause.PropertiesOption.INCLUDING) {
                        if (includingProperties) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Only one LIKE clause can specify INCLUDING PROPERTIES", new Object[0]);
                        }
                        includingProperties = true;
                        inheritedProperties = likeTableMetadata.getMetadata().getProperties();
                    }
                    try {
                        this.accessControl.checkCanSelectFromColumns(session.toSecurityContext(), likeTableName, (Set)likeTableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet()));
                    }
                    catch (AccessDeniedException e) {
                        throw new AccessDeniedException("Cannot reference columns of table " + likeTableName, e);
                    }
                    if (propertiesOption == LikeClause.PropertiesOption.INCLUDING) {
                        try {
                            this.accessControl.checkCanShowCreateTable(session.toSecurityContext(), likeTableName);
                        }
                        catch (AccessDeniedException e) {
                            throw new AccessDeniedException("Cannot reference properties of table " + likeTableName, e);
                        }
                    }
                    likeTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).forEach(column -> {
                        if (columns.containsKey(column.getName().toLowerCase(Locale.ENGLISH))) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)element, "Column name '%s' specified more than once", column.getName());
                        }
                        columns.put(column.getName().toLowerCase(Locale.ENGLISH), (ColumnMetadata)column);
                    });
                    continue;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid TableElement: " + element.getClass().getName());
            }
            Map properties = this.tablePropertyManager.getProperties(catalogName, catalogHandle, (Iterable)statement.getProperties(), session, this.plannerContext, this.accessControl, (Map)parameterLookup, true);
            Set specifiedPropertyKeys = (Set)statement.getProperties().stream().map(property -> property.getName().getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            Map explicitlySetProperties = (Map)properties.keySet().stream().peek(key -> Verify.verify((boolean)key.equals(key.toLowerCase(Locale.ENGLISH)), (String)"Property name '%s' not in lower-case", (Object)key)).filter(specifiedPropertyKeys::contains).collect(ImmutableMap.toImmutableMap(Function.identity(), properties::get));
            this.accessControl.checkCanCreateTable(session.toSecurityContext(), tableName, explicitlySetProperties);
            Map<String, Object> finalProperties = CreateTableTask.combineProperties(specifiedPropertyKeys, properties, (Map<String, Object>)inheritedProperties);
            tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.copyOf(columns.values()), finalProperties, statement.getComment());
            try {
                this.plannerContext.getMetadata().createTable(session, catalogName, tableMetadata, statement.isNotExists());
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block25;
                throw e;
            }
        }
        outputConsumer.accept(new Output(catalogName, catalogHandle.getVersion(), tableName.getSchemaName(), tableName.getObjectName(), Optional.of((List)tableMetadata.getColumns().stream().map(column -> new OutputColumn(new Column(column.getName(), column.getType().toString()), (Set<Analysis.SourceColumn>)ImmutableSet.of())).collect(ImmutableList.toImmutableList()))));
        return Futures.immediateVoidFuture();
    }

    private static Map<String, Object> combineProperties(Set<String> specifiedPropertyKeys, Map<String, Object> defaultProperties, Map<String, Object> inheritedProperties) {
        HashMap<String, Object> finalProperties = new HashMap<String, Object>(inheritedProperties);
        for (Map.Entry<String, Object> entry : defaultProperties.entrySet()) {
            if (!specifiedPropertyKeys.contains(entry.getKey()) && finalProperties.containsKey(entry.getKey())) continue;
            finalProperties.put(entry.getKey(), entry.getValue());
        }
        return finalProperties;
    }
}

