/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;

public class DropColumnTask
implements DataDefinitionTask<DropColumn> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public DropColumnTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DROP COLUMN";
    }

    @Override
    public ListenableFuture<Void> execute(DropColumn statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable()));
        if (redirectionAwareTableHandle.getTableHandle().isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateVoidFuture();
        }
        TableHandle tableHandle = redirectionAwareTableHandle.getTableHandle().get();
        String column = (String)statement.getField().getParts().get(0);
        QualifiedObjectName qualifiedTableName = redirectionAwareTableHandle.getRedirectedTableName().orElse(tableName);
        this.accessControl.checkCanDropColumn(session.toSecurityContext(), qualifiedTableName);
        ColumnHandle columnHandle = this.metadata.getColumnHandles(session, tableHandle).get(column);
        if (columnHandle == null) {
            if (!statement.isColumnExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", column);
            }
            return Futures.immediateVoidFuture();
        }
        List fieldPath = (List)statement.getField().getOriginalParts().subList(1, statement.getField().getOriginalParts().size()).stream().map(Identifier::getValue).collect(ImmutableList.toImmutableList());
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle, columnHandle);
        if (columnMetadata.isHidden()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop hidden column", new Object[0]);
        }
        if (fieldPath.isEmpty()) {
            if (this.metadata.getTableMetadata(session, tableHandle).getColumns().stream().filter(info -> !info.isHidden()).count() <= 1L) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop the only column in a table", new Object[0]);
            }
            this.metadata.dropColumn(session, tableHandle, qualifiedTableName.asCatalogSchemaTableName(), columnHandle);
        } else {
            RowType containingType = null;
            Type currentType = columnMetadata.getType();
            for (String fieldName : fieldPath) {
                if (currentType instanceof RowType) {
                    RowType rowType = (RowType)currentType;
                    List candidates = (List)rowType.getFields().stream().filter(rowField -> rowField.getName().isPresent() && ((String)rowField.getName().get()).equals(fieldName)).collect(ImmutableList.toImmutableList());
                    if (candidates.size() > 1) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Field path %s within %s is ambiguous", fieldPath, columnMetadata.getType());
                    }
                    if (candidates.size() == 1) {
                        RowType.Field rowField2 = (RowType.Field)Iterables.getOnlyElement((Iterable)candidates);
                        containingType = rowType;
                        currentType = rowField2.getType();
                        continue;
                    }
                    if (statement.isColumnExists() && candidates.size() == 0) {
                        return Futures.immediateVoidFuture();
                    }
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot resolve field '%s' within %s type when dropping %s in %s", fieldName, currentType, fieldPath, columnMetadata.getType());
            }
            Verify.verifyNotNull(containingType, (String)"containingType is null", (Object[])new Object[0]);
            if (containingType.getFields().size() == 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop the only field in a row type", new Object[0]);
            }
            this.metadata.dropField(session, tableHandle, columnHandle, fieldPath);
        }
        return Futures.immediateVoidFuture();
    }
}

