/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.execution.Column;
import io.trino.spi.connector.CatalogHandle;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Input {
    private final String catalogName;
    private final CatalogHandle.CatalogVersion catalogVersion;
    private final String schema;
    private final String table;
    private final List<Column> columns;
    private final Optional<Object> connectorInfo;
    private final PlanFragmentId fragmentId;
    private final PlanNodeId planNodeId;

    @JsonCreator
    public Input(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="catalogVersion") CatalogHandle.CatalogVersion catalogVersion, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="connectorInfo") Optional<Object> connectorInfo, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="fragmentId") PlanFragmentId fragmentId, @JsonProperty(value="planNodeId") PlanNodeId planNodeId) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogVersion = Objects.requireNonNull(catalogVersion, "catalogVersion is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.connectorInfo = Objects.requireNonNull(connectorInfo, "connectorInfo is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.fragmentId = Objects.requireNonNull(fragmentId, "fragmentId is null");
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public CatalogHandle.CatalogVersion getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<Object> getConnectorInfo() {
        return this.connectorInfo;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public PlanFragmentId getFragmentId() {
        return this.fragmentId;
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.catalogName, input.catalogName) && Objects.equals(this.catalogVersion, input.catalogVersion) && Objects.equals(this.schema, input.schema) && Objects.equals(this.table, input.table) && Objects.equals(this.columns, input.columns) && Objects.equals(this.connectorInfo, input.connectorInfo) && Objects.equals(this.fragmentId, input.fragmentId) && Objects.equals(this.planNodeId, input.planNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.catalogVersion, this.schema, this.table, this.columns, this.connectorInfo, this.fragmentId, this.planNodeId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.catalogName).addValue((Object)this.catalogVersion).addValue((Object)this.schema).addValue((Object)this.table).addValue(this.columns).addValue((Object)this.fragmentId).addValue((Object)this.planNodeId).toString();
    }
}

