/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.ByteStreams;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.UnsafeSlice;
import io.airlift.slice.XxHash64;
import io.trino.block.BlockSerdeUtil;
import io.trino.execution.buffer.PageCodecMarker;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class PagesSerdeUtil {
    static final int SERIALIZED_PAGE_POSITION_COUNT_OFFSET = 0;
    static final int SERIALIZED_PAGE_CODEC_MARKERS_OFFSET = 4;
    static final int SERIALIZED_PAGE_UNCOMPRESSED_SIZE_OFFSET = 5;
    static final int SERIALIZED_PAGE_COMPRESSED_SIZE_OFFSET = 9;
    static final int SERIALIZED_PAGE_HEADER_SIZE = 13;
    static final String SERIALIZED_PAGE_CIPHER_NAME = "AES/CBC/PKCS5Padding";
    static final int SERIALIZED_PAGE_COMPRESSED_BLOCK_MASK = Integer.MIN_VALUE;
    static final int ESTIMATED_AES_CIPHER_RETAINED_SIZE = 1024;
    public static final long NO_CHECKSUM = 81985529216486895L;

    private PagesSerdeUtil() {
    }

    static void writeRawPage(Page page, SliceOutput output, BlockEncodingSerde serde) {
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock(serde, output, page.getBlock(channel));
        }
    }

    static Page readRawPage(int positionCount, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(blockEncodingSerde, input);
        }
        return new Page(positionCount, blocks);
    }

    public static long calculateChecksum(List<Slice> pages) {
        XxHash64 hash = new XxHash64();
        for (Slice page : pages) {
            hash.update(page);
        }
        long checksum = hash.hash();
        if (checksum == 81985529216486895L) {
            return checksum + 1L;
        }
        return checksum;
    }

    public static long writePages(PageSerializer serializer, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerdeUtil.writePages(serializer, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(PageSerializer serializer, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        while (pages.hasNext()) {
            Page page = pages.next();
            sliceOutput.writeBytes(serializer.serialize(page));
            size += page.getSizeInBytes();
        }
        return size;
    }

    public static Iterator<Page> readPages(PageDeserializer deserializer, InputStream inputStream) {
        return new PageReader(deserializer, inputStream);
    }

    public static int getSerializedPagePositionCount(Slice serializedPage) {
        return serializedPage.getInt(0);
    }

    public static int getSerializedPageUncompressedSizeInBytes(Slice serializedPage) {
        return serializedPage.getInt(5);
    }

    public static boolean isSerializedPageEncrypted(Slice serializedPage) {
        return PagesSerdeUtil.getSerializedPageMarkerSet(serializedPage).contains(PageCodecMarker.ENCRYPTED);
    }

    public static boolean isSerializedPageCompressed(Slice serializedPage) {
        return PagesSerdeUtil.getSerializedPageMarkerSet(serializedPage).contains(PageCodecMarker.COMPRESSED);
    }

    private static PageCodecMarker.MarkerSet getSerializedPageMarkerSet(Slice serializedPage) {
        return PageCodecMarker.MarkerSet.fromByteValue(serializedPage.getByte(4));
    }

    public static Iterator<Slice> readSerializedPages(InputStream inputStream) {
        return new SerializedPageReader(inputStream);
    }

    public static Slice readSerializedPage(Slice headerSlice, InputStream inputStream) throws IOException {
        Preconditions.checkArgument((headerSlice.length() == 13 ? 1 : 0) != 0, (String)"headerSlice length should equal to %s", (int)13);
        int compressedSize = UnsafeSlice.getIntUnchecked((Slice)headerSlice, (int)9);
        byte[] outputBuffer = new byte[13 + compressedSize];
        headerSlice.getBytes(0, outputBuffer, 0, 13);
        ByteStreams.readFully((InputStream)inputStream, (byte[])outputBuffer, (int)13, (int)compressedSize);
        return Slices.wrappedBuffer((byte[])outputBuffer);
    }

    private static class PageReader
    extends AbstractIterator<Page> {
        private final PageDeserializer deserializer;
        private final InputStream inputStream;
        private final byte[] headerBuffer = new byte[13];
        private final Slice headerSlice = Slices.wrappedBuffer((byte[])this.headerBuffer);

        PageReader(PageDeserializer deserializer, InputStream inputStream) {
            this.deserializer = Objects.requireNonNull(deserializer, "deserializer is null");
            this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        }

        protected Page computeNext() {
            try {
                int read = ByteStreams.read((InputStream)this.inputStream, (byte[])this.headerBuffer, (int)0, (int)this.headerBuffer.length);
                if (read <= 0) {
                    return (Page)this.endOfData();
                }
                if (read != this.headerBuffer.length) {
                    throw new EOFException();
                }
                return this.deserializer.deserialize(PagesSerdeUtil.readSerializedPage(this.headerSlice, this.inputStream));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class SerializedPageReader
    extends AbstractIterator<Slice> {
        private final InputStream inputStream;
        private final byte[] headerBuffer = new byte[13];
        private final Slice headerSlice = Slices.wrappedBuffer((byte[])this.headerBuffer);

        SerializedPageReader(InputStream input) {
            this.inputStream = Objects.requireNonNull(input, "inputStream is null");
        }

        protected Slice computeNext() {
            try {
                int read = ByteStreams.read((InputStream)this.inputStream, (byte[])this.headerBuffer, (int)0, (int)this.headerBuffer.length);
                if (read <= 0) {
                    return (Slice)this.endOfData();
                }
                if (read != this.headerBuffer.length) {
                    throw new EOFException();
                }
                return PagesSerdeUtil.readSerializedPage(this.headerSlice, this.inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

