/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"deprecated.legacy-system-pool-enabled", "experimental.reserved-pool-disabled", "experimental.reserved-pool-enabled", "query.max-total-memory-per-node", "query.max-memory-per-task"})
public class NodeMemoryConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    private DataSize maxQueryMemoryPerNode = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3));
    private DataSize heapHeadroom = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3));

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public NodeMemoryConfig setMaxQueryMemoryPerNode(DataSize maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = maxQueryMemoryPerNode;
        return this;
    }

    @NotNull
    public DataSize getHeapHeadroom() {
        return this.heapHeadroom;
    }

    @Config(value="memory.heap-headroom-per-node")
    @ConfigDescription(value="The amount of heap memory to set aside as headroom/buffer (e.g., for untracked allocations)")
    public NodeMemoryConfig setHeapHeadroom(DataSize heapHeadroom) {
        this.heapHeadroom = heapHeadroom;
        return this;
    }
}

