/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.opentelemetry.api.trace.Tracer;
import io.trino.Session;
import io.trino.connector.informationschema.InformationSchemaMetadata;
import io.trino.connector.system.SystemTablesMetadata;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.tracing.TracingConnectorMetadata;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

public class CatalogTransaction {
    private final Tracer tracer;
    private final CatalogHandle catalogHandle;
    private final Connector connector;
    private final ConnectorTransactionHandle transactionHandle;
    @GuardedBy(value="this")
    private ConnectorMetadata connectorMetadata;
    private final AtomicBoolean finished = new AtomicBoolean();

    public CatalogTransaction(Tracer tracer, CatalogHandle catalogHandle, Connector connector, ConnectorTransactionHandle transactionHandle) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public boolean isSingleStatementWritesOnly() {
        return this.connector.isSingleStatementWritesOnly();
    }

    public synchronized ConnectorMetadata getConnectorMetadata(Session session) {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"Already finished");
        if (this.connectorMetadata == null) {
            ConnectorSession connectorSession = session.toConnectorSession(this.catalogHandle);
            this.connectorMetadata = this.connector.getMetadata(connectorSession, this.transactionHandle);
            this.connectorMetadata = this.tracingConnectorMetadata(this.catalogHandle.getCatalogName(), this.connectorMetadata);
        }
        return this.connectorMetadata;
    }

    public ConnectorTransactionHandle getTransactionHandle() {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"Already finished");
        return this.transactionHandle;
    }

    public void commit() {
        if (this.finished.compareAndSet(false, true)) {
            this.connector.commit(this.transactionHandle);
        }
    }

    public void abort() {
        if (this.finished.compareAndSet(false, true)) {
            this.connector.rollback(this.transactionHandle);
        }
    }

    private ConnectorMetadata tracingConnectorMetadata(String catalogName, ConnectorMetadata delegate) {
        if (delegate instanceof SystemTablesMetadata || delegate instanceof InformationSchemaMetadata) {
            return delegate;
        }
        return new TracingConnectorMetadata(this.tracer, catalogName, delegate);
    }
}

