/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.inject.Inject;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.CatalogTableFunctions;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TableFunctionRegistry {
    private final CatalogServiceProvider<CatalogTableFunctions> tableFunctionsProvider;

    @Inject
    public TableFunctionRegistry(CatalogServiceProvider<CatalogTableFunctions> tableFunctionsProvider) {
        this.tableFunctionsProvider = Objects.requireNonNull(tableFunctionsProvider, "tableFunctionsProvider is null");
    }

    public Optional<ConnectorTableFunction> resolve(CatalogHandle catalogHandle, SchemaFunctionName schemaFunctionName) {
        return this.tableFunctionsProvider.getService(catalogHandle).getTableFunction(schemaFunctionName);
    }
}

