/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import io.trino.operator.GroupByHash;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.operator.SyntheticAddress;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public class MultiChannelGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MultiChannelGroupByHash.class);
    private static final float FILL_RATIO = 0.75f;
    private static final int BATCH_SIZE = 1024;
    private static final double SMALL_DICTIONARIES_MAX_CARDINALITY_RATIO = 0.25;
    private static final int VALUES_PAGE_BITS = 14;
    private static final int VALUES_PAGE_MAX_ROW_COUNT = 16384;
    private static final int VALUES_PAGE_MASK = 16383;
    private final List<Type> types;
    private final List<Type> hashTypes;
    private final int[] channels;
    private final PagesHashStrategy hashStrategy;
    private final List<ObjectArrayList<Block>> channelBuilders;
    private final Optional<Integer> inputHashChannel;
    private final HashGenerator hashGenerator;
    private final OptionalInt precomputedHashChannel;
    private final boolean processDictionary;
    private PageBuilder currentPageBuilder;
    private long completedPagesMemorySize;
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private int[] groupIdsByHash;
    private byte[] rawHashByHashPosition;
    private int nextGroupId;
    private DictionaryLookBack dictionaryLookBack;
    private final UpdateMemory updateMemory;
    private long preallocatedMemoryInBytes;
    private long currentPageSizeInBytes;

    public MultiChannelGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        this.hashTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashTypes, "hashTypes is null"));
        Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        Objects.requireNonNull(hashChannels, "hashChannels is null");
        Preconditions.checkArgument((hashTypes.size() == hashChannels.length ? 1 : 0) != 0, (Object)"hashTypes and hashChannels have different sizes");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.inputHashChannel = Objects.requireNonNull(inputHashChannel, "inputHashChannel is null");
        this.types = inputHashChannel.isPresent() ? ImmutableList.copyOf((Iterable)Iterables.concat(hashTypes, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))) : this.hashTypes;
        this.channels = (int[])hashChannels.clone();
        this.hashGenerator = inputHashChannel.isPresent() ? new PrecomputedHashGenerator(inputHashChannel.get()) : new InterpretedHashGenerator(this.hashTypes, hashChannels, blockTypeOperators);
        this.processDictionary = processDictionary;
        ImmutableList.Builder outputChannels = ImmutableList.builder();
        ImmutableList.Builder channelBuilders = ImmutableList.builder();
        for (int i = 0; i < hashChannels.length; ++i) {
            outputChannels.add((Object)i);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        }
        if (inputHashChannel.isPresent()) {
            this.precomputedHashChannel = OptionalInt.of(hashChannels.length);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        } else {
            this.precomputedHashChannel = OptionalInt.empty();
        }
        this.channelBuilders = channelBuilders.build();
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory(this.types, (List<Integer>)outputChannels.build());
        this.hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy(this.channelBuilders, this.precomputedHashChannel);
        this.startNewPage();
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = MultiChannelGroupByHash.calculateMaxFill(this.hashCapacity);
        this.mask = this.hashCapacity - 1;
        this.rawHashByHashPosition = new byte[this.hashCapacity];
        this.groupIdsByHash = new int[this.hashCapacity];
        Arrays.fill(this.groupIdsByHash, -1);
        this.updateMemory = Objects.requireNonNull(updateMemory, "updateMemory is null");
    }

    @Override
    public long getRawHash(int groupId) {
        int blockIndex = groupId >> 14;
        int position = groupId & 0x3FFF;
        return this.hashStrategy.hashPosition(blockIndex, position);
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.channelBuilders.get(0).elements()) * (long)this.channelBuilders.size() + this.completedPagesMemorySize + this.currentPageBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])this.groupIdsByHash) + SizeOf.sizeOf((byte[])this.rawHashByHashPosition) + this.preallocatedMemoryInBytes + (this.dictionaryLookBack != null ? this.dictionaryLookBack.getRetainedSizeInBytes() : 0L);
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public int getGroupCount() {
        return this.nextGroupId;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder) {
        int blockIndex = groupId >> 14;
        int position = groupId & 0x3FFF;
        this.hashStrategy.appendTo(blockIndex, position, pageBuilder, 0);
    }

    @Override
    public Work<?> addPage(Page page) {
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        if (this.isRunLengthEncoded(page)) {
            return new AddRunLengthEncodedPageWork(page);
        }
        if (this.canProcessDictionary(page)) {
            return new AddDictionaryPageWork(page);
        }
        if (this.canProcessLowCardinalityDictionary(page)) {
            return new AddLowCardinalityDictionaryPageWork(page);
        }
        return new AddNonDictionaryPageWork(page);
    }

    @Override
    public Work<int[]> getGroupIds(Page page) {
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        if (this.isRunLengthEncoded(page)) {
            return new GetRunLengthEncodedGroupIdsWork(page);
        }
        if (this.canProcessDictionary(page)) {
            return new GetDictionaryGroupIdsWork(page);
        }
        if (this.canProcessLowCardinalityDictionary(page)) {
            return new GetLowCardinalityDictionaryGroupIdsWork(page);
        }
        return new GetNonDictionaryGroupIdsWork(page);
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels) {
        long rawHash = this.hashStrategy.hashRow(position, page);
        return this.contains(position, page, hashChannels, rawHash);
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels, long rawHash) {
        int hashPosition = MultiChannelGroupByHash.getHashPosition(rawHash, this.mask);
        while (this.groupIdsByHash[hashPosition] != -1) {
            if (this.positionNotDistinctFromCurrentRow(this.groupIdsByHash[hashPosition], hashPosition, position, page, (byte)rawHash, hashChannels)) {
                return true;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        return false;
    }

    @Override
    @VisibleForTesting
    public int getCapacity() {
        return this.hashCapacity;
    }

    private int putIfAbsent(int position, Page page) {
        long rawHash = this.hashGenerator.hashPosition(position, page);
        return this.putIfAbsent(position, page, rawHash);
    }

    private int putIfAbsent(int position, Page page, long rawHash) {
        int hashPosition = MultiChannelGroupByHash.getHashPosition(rawHash, this.mask);
        int groupId = -1;
        while (this.groupIdsByHash[hashPosition] != -1) {
            if (this.positionNotDistinctFromCurrentRow(this.groupIdsByHash[hashPosition], hashPosition, position, page, (byte)rawHash, this.channels)) {
                groupId = this.groupIdsByHash[hashPosition];
                break;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        if (groupId < 0) {
            groupId = this.addNewGroup(hashPosition, position, page, rawHash);
        }
        return groupId;
    }

    private int addNewGroup(int hashPosition, int position, Page page, long rawHash) {
        for (int i = 0; i < this.channels.length; ++i) {
            int hashChannel = this.channels[i];
            Type type = this.types.get(i);
            type.appendTo(page.getBlock(hashChannel), position, this.currentPageBuilder.getBlockBuilder(i));
        }
        if (this.precomputedHashChannel.isPresent()) {
            BigintType.BIGINT.writeLong(this.currentPageBuilder.getBlockBuilder(this.precomputedHashChannel.getAsInt()), rawHash);
        }
        this.currentPageBuilder.declarePosition();
        int pageIndex = this.channelBuilders.get(0).size() - 1;
        int pagePosition = this.currentPageBuilder.getPositionCount() - 1;
        long address = SyntheticAddress.encodeSyntheticAddress(pageIndex, pagePosition);
        Preconditions.checkState((address != -1L ? 1 : 0) != 0, (Object)"Address cannot be -1");
        int groupId = this.nextGroupId++;
        this.rawHashByHashPosition[hashPosition] = (byte)rawHash;
        this.groupIdsByHash[hashPosition] = groupId;
        if (this.currentPageBuilder.getPositionCount() == 16384) {
            this.startNewPage();
        }
        if (this.needRehash()) {
            this.tryRehash();
        }
        return groupId;
    }

    private boolean needRehash() {
        return this.nextGroupId >= this.maxFill;
    }

    private void startNewPage() {
        if (this.currentPageBuilder != null) {
            this.completedPagesMemorySize += this.currentPageBuilder.getRetainedSizeInBytes();
            this.currentPageBuilder.reset(this.currentPageBuilder.getPositionCount());
        } else {
            this.currentPageBuilder = new PageBuilder(this.types);
        }
        for (int i = 0; i < this.types.size(); ++i) {
            this.channelBuilders.get(i).add((Object)this.currentPageBuilder.getBlockBuilder(i));
        }
    }

    private boolean tryRehash() {
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = Math.toIntExact(newCapacityLong);
        this.preallocatedMemoryInBytes = (long)newCapacity * 5L + this.currentPageSizeInBytes;
        if (!this.updateMemory.update()) {
            return false;
        }
        int newMask = newCapacity - 1;
        byte[] rawHashes = new byte[newCapacity];
        int[] newGroupIdByHash = new int[newCapacity];
        Arrays.fill(newGroupIdByHash, -1);
        for (int i = 0; i < this.hashCapacity; ++i) {
            int groupId = this.groupIdsByHash[i];
            if (groupId == -1) continue;
            long rawHash = this.hashPosition(groupId);
            int pos = MultiChannelGroupByHash.getHashPosition(rawHash, newMask);
            while (newGroupIdByHash[pos] != -1) {
                pos = pos + 1 & newMask;
            }
            rawHashes[pos] = (byte)rawHash;
            newGroupIdByHash[pos] = groupId;
        }
        this.mask = newMask;
        this.hashCapacity = newCapacity;
        this.maxFill = MultiChannelGroupByHash.calculateMaxFill(newCapacity);
        this.rawHashByHashPosition = rawHashes;
        this.groupIdsByHash = newGroupIdByHash;
        this.preallocatedMemoryInBytes = 0L;
        this.updateMemory.update();
        return true;
    }

    private long hashPosition(int groupId) {
        int blockIndex = groupId >> 14;
        int blockPosition = groupId & 0x3FFF;
        if (this.precomputedHashChannel.isPresent()) {
            return this.getRawHash(blockIndex, blockPosition, this.precomputedHashChannel.getAsInt());
        }
        return this.hashStrategy.hashPosition(blockIndex, blockPosition);
    }

    private long getRawHash(int sliceIndex, int position, int hashChannel) {
        return ((Block)this.channelBuilders.get(hashChannel).get(sliceIndex)).getLong(position, 0);
    }

    private boolean positionNotDistinctFromCurrentRow(int groupId, int hashPosition, int position, Page page, byte rawHash, int[] hashChannels) {
        if (this.rawHashByHashPosition[hashPosition] != rawHash) {
            return false;
        }
        int blockIndex = groupId >> 14;
        int blockPosition = groupId & 0x3FFF;
        return this.hashStrategy.positionNotDistinctFromRow(blockIndex, blockPosition, position, page, hashChannels);
    }

    private static int getHashPosition(long rawHash, int mask) {
        return (int)(HashCommon.murmurHash3((long)rawHash) & (long)mask);
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private void updateDictionaryLookBack(Block dictionary) {
        if (this.dictionaryLookBack == null || this.dictionaryLookBack.getDictionary() != dictionary) {
            this.dictionaryLookBack = new DictionaryLookBack(dictionary);
        }
    }

    private Page createPageWithExtractedDictionary(Page page) {
        Block dictionary;
        Block[] blocks = new Block[page.getChannelCount()];
        blocks[this.channels[0]] = dictionary = ((DictionaryBlock)page.getBlock(this.channels[0])).getDictionary();
        this.inputHashChannel.ifPresent(integer -> {
            blocks[integer.intValue()] = ((DictionaryBlock)page.getBlock(integer.intValue())).getDictionary();
        });
        return new Page(dictionary.getPositionCount(), blocks);
    }

    private boolean canProcessDictionary(Page page) {
        if (!this.processDictionary || this.channels.length > 1 || !(page.getBlock(this.channels[0]) instanceof DictionaryBlock)) {
            return false;
        }
        if (this.inputHashChannel.isPresent()) {
            Block inputHashBlock = page.getBlock(this.inputHashChannel.get().intValue());
            DictionaryBlock inputDataBlock = (DictionaryBlock)page.getBlock(this.channels[0]);
            if (!(inputHashBlock instanceof DictionaryBlock)) {
                return false;
            }
            return ((DictionaryBlock)inputHashBlock).getDictionarySourceId().equals((Object)inputDataBlock.getDictionarySourceId());
        }
        return true;
    }

    private boolean canProcessLowCardinalityDictionary(Page page) {
        int positionCount = page.getPositionCount();
        long cardinality = 1L;
        for (int channel : this.channels) {
            if (!(page.getBlock(channel) instanceof DictionaryBlock)) {
                return false;
            }
            if (!((double)(cardinality = Math.multiplyExact(cardinality, ((DictionaryBlock)page.getBlock(channel)).getDictionary().getPositionCount())) > (double)positionCount * 0.25) && cardinality <= 32767L) continue;
            return false;
        }
        return true;
    }

    private boolean isRunLengthEncoded(Page page) {
        for (int channel : this.channels) {
            if (page.getBlock(channel) instanceof RunLengthEncodedBlock) continue;
            return false;
        }
        return true;
    }

    private int registerGroupId(HashGenerator hashGenerator, Page page, int positionInDictionary) {
        if (this.dictionaryLookBack.isProcessed(positionInDictionary)) {
            return this.dictionaryLookBack.getGroupId(positionInDictionary);
        }
        int groupId = this.putIfAbsent(positionInDictionary, page, hashGenerator.hashPosition(positionInDictionary, page));
        this.dictionaryLookBack.setProcessed(positionInDictionary, groupId);
        return groupId;
    }

    private int[] calculateCombinationIdToPositionMapping(Page page) {
        short[] positionToCombinationId = new short[page.getPositionCount()];
        int maxCardinality = this.calculatePositionToCombinationIdMapping(page, positionToCombinationId);
        int[] combinationIdToPosition = new int[maxCardinality];
        Arrays.fill(combinationIdToPosition, -1);
        for (int position = 0; position < positionToCombinationId.length; ++position) {
            combinationIdToPosition[positionToCombinationId[position]] = position;
        }
        return combinationIdToPosition;
    }

    private int calculatePositionToCombinationIdMapping(Page page, short[] positionToCombinationIds) {
        Preconditions.checkArgument((positionToCombinationIds.length == page.getPositionCount() ? 1 : 0) != 0);
        int maxCardinality = 1;
        for (int channel = 0; channel < this.channels.length; ++channel) {
            int position;
            Block block = page.getBlock(this.channels[channel]);
            Verify.verify((boolean)(block instanceof DictionaryBlock), (String)"Only dictionary blocks are supported", (Object[])new Object[0]);
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            int dictionarySize = dictionaryBlock.getDictionary().getPositionCount();
            maxCardinality *= dictionarySize;
            if (channel == 0) {
                for (position = 0; position < positionToCombinationIds.length; ++position) {
                    positionToCombinationIds[position] = (short)dictionaryBlock.getId(position);
                }
                continue;
            }
            for (position = 0; position < positionToCombinationIds.length; ++position) {
                short combinationId = positionToCombinationIds[position];
                combinationId = (short)(combinationId * dictionarySize);
                positionToCombinationIds[position] = combinationId = (short)(combinationId + dictionaryBlock.getId(position));
            }
        }
        return maxCardinality;
    }

    private boolean ensureHashTableSize(int batchSize) {
        int positionCountUntilRehash = this.maxFill - this.nextGroupId;
        while (positionCountUntilRehash < batchSize) {
            if (!this.tryRehash()) {
                return false;
            }
            positionCountUntilRehash = this.maxFill - this.nextGroupId;
        }
        return true;
    }

    private static final class DictionaryLookBack {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryLookBack.class);
        private final Block dictionary;
        private final int[] processed;

        public DictionaryLookBack(Block dictionary) {
            this.dictionary = dictionary;
            this.processed = new int[dictionary.getPositionCount()];
            Arrays.fill(this.processed, -1);
        }

        public Block getDictionary() {
            return this.dictionary;
        }

        public int getGroupId(int position) {
            return this.processed[position];
        }

        public boolean isProcessed(int position) {
            return this.processed[position] != -1;
        }

        public void setProcessed(int position, int groupId) {
            this.processed[position] = groupId;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.processed) + this.dictionary.getRetainedSizeInBytes();
        }
    }

    @VisibleForTesting
    class AddRunLengthEncodedPageWork
    implements Work<Void> {
        private final Page page;
        private boolean finished;

        public AddRunLengthEncodedPageWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (this.page.getPositionCount() == 0) {
                this.finished = true;
                return true;
            }
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            MultiChannelGroupByHash.this.putIfAbsent(0, this.page);
            this.finished = true;
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    class AddDictionaryPageWork
    implements Work<Void> {
        private final Page page;
        private final Page dictionaryPage;
        private final DictionaryBlock dictionaryBlock;
        private int lastPosition;

        public AddDictionaryPageWork(Page page) {
            Verify.verify((boolean)MultiChannelGroupByHash.this.canProcessDictionary(page), (String)"invalid call to addDictionaryPage", (Object[])new Object[0]);
            this.page = Objects.requireNonNull(page, "page is null");
            this.dictionaryBlock = (DictionaryBlock)page.getBlock(MultiChannelGroupByHash.this.channels[0]);
            MultiChannelGroupByHash.this.updateDictionaryLookBack(this.dictionaryBlock.getDictionary());
            this.dictionaryPage = MultiChannelGroupByHash.this.createPageWithExtractedDictionary(page);
        }

        @Override
        public boolean process() {
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !MultiChannelGroupByHash.this.needRehash()) {
                int positionInDictionary = this.dictionaryBlock.getId(this.lastPosition);
                MultiChannelGroupByHash.this.registerGroupId(MultiChannelGroupByHash.this.hashGenerator, this.dictionaryPage, positionInDictionary);
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    class AddLowCardinalityDictionaryPageWork
    implements Work<Void> {
        private final Page page;
        @Nullable
        private int[] combinationIdToPosition;
        private int nextCombinationId;

        public AddLowCardinalityDictionaryPageWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            if (this.combinationIdToPosition == null) {
                this.combinationIdToPosition = MultiChannelGroupByHash.this.calculateCombinationIdToPositionMapping(this.page);
            }
            for (int combinationId = this.nextCombinationId; combinationId < this.combinationIdToPosition.length; ++combinationId) {
                int position = this.combinationIdToPosition[combinationId];
                if (position == -1) continue;
                if (MultiChannelGroupByHash.this.needRehash()) {
                    this.nextCombinationId = combinationId;
                    return false;
                }
                MultiChannelGroupByHash.this.putIfAbsent(position, this.page);
            }
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    class AddNonDictionaryPageWork
    implements Work<Void> {
        private final Page page;
        private int lastPosition;

        public AddNonDictionaryPageWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            int batchSize;
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            for (int remainingPositions = positionCount - this.lastPosition; remainingPositions != 0; remainingPositions -= batchSize) {
                batchSize = Math.min(remainingPositions, 1024);
                if (!MultiChannelGroupByHash.this.ensureHashTableSize(batchSize)) {
                    return false;
                }
                for (int i = this.lastPosition; i < this.lastPosition + batchSize; ++i) {
                    MultiChannelGroupByHash.this.putIfAbsent(i, this.page);
                }
                this.lastPosition += batchSize;
            }
            Verify.verify((this.lastPosition == positionCount ? 1 : 0) != 0);
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    class GetRunLengthEncodedGroupIdsWork
    implements Work<int[]> {
        private final Page page;
        int groupId = -1;
        private boolean processFinished;
        private boolean resultProduced;

        public GetRunLengthEncodedGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            Preconditions.checkState((!this.processFinished ? 1 : 0) != 0);
            if (this.page.getPositionCount() == 0) {
                this.processFinished = true;
                return true;
            }
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            this.groupId = MultiChannelGroupByHash.this.putIfAbsent(0, this.page);
            this.processFinished = true;
            return true;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((boolean)this.processFinished);
            Preconditions.checkState((!this.resultProduced ? 1 : 0) != 0);
            this.resultProduced = true;
            int[] groupIds = new int[this.page.getPositionCount()];
            Arrays.fill(groupIds, this.groupId);
            return groupIds;
        }
    }

    @VisibleForTesting
    class GetDictionaryGroupIdsWork
    implements Work<int[]> {
        private final int[] groupIds;
        private final Page page;
        private final Page dictionaryPage;
        private final DictionaryBlock dictionaryBlock;
        private boolean finished;
        private int lastPosition;

        public GetDictionaryGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            Verify.verify((boolean)MultiChannelGroupByHash.this.canProcessDictionary(page), (String)"invalid call to processDictionary", (Object[])new Object[0]);
            this.dictionaryBlock = (DictionaryBlock)page.getBlock(MultiChannelGroupByHash.this.channels[0]);
            MultiChannelGroupByHash.this.updateDictionaryLookBack(this.dictionaryBlock.getDictionary());
            this.dictionaryPage = MultiChannelGroupByHash.this.createPageWithExtractedDictionary(page);
            this.groupIds = new int[page.getPositionCount()];
        }

        @Override
        public boolean process() {
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !MultiChannelGroupByHash.this.needRehash()) {
                int positionInDictionary = this.dictionaryBlock.getId(this.lastPosition);
                this.groupIds[this.lastPosition] = MultiChannelGroupByHash.this.registerGroupId(MultiChannelGroupByHash.this.hashGenerator, this.dictionaryPage, positionInDictionary);
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((this.lastPosition == this.page.getPositionCount() ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return this.groupIds;
        }
    }

    @VisibleForTesting
    class GetLowCardinalityDictionaryGroupIdsWork
    implements Work<int[]> {
        private final Page page;
        private final int[] groupIds;
        @Nullable
        private short[] positionToCombinationId;
        @Nullable
        private int[] combinationIdToGroupId;
        private int nextPosition;
        private boolean finished;

        public GetLowCardinalityDictionaryGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.groupIds = new int[page.getPositionCount()];
        }

        @Override
        public boolean process() {
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            if (this.positionToCombinationId == null) {
                this.positionToCombinationId = new short[this.groupIds.length];
                int maxCardinality = MultiChannelGroupByHash.this.calculatePositionToCombinationIdMapping(this.page, this.positionToCombinationId);
                this.combinationIdToGroupId = new int[maxCardinality];
                Arrays.fill(this.combinationIdToGroupId, -1);
            }
            for (int position = this.nextPosition; position < this.groupIds.length; ++position) {
                short combinationId = this.positionToCombinationId[position];
                int groupId = this.combinationIdToGroupId[combinationId];
                if (groupId == -1) {
                    if (MultiChannelGroupByHash.this.needRehash()) {
                        this.nextPosition = position;
                        return false;
                    }
                    this.combinationIdToGroupId[combinationId] = groupId = MultiChannelGroupByHash.this.putIfAbsent(position, this.page);
                }
                this.groupIds[position] = groupId;
            }
            return true;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return this.groupIds;
        }
    }

    @VisibleForTesting
    class GetNonDictionaryGroupIdsWork
    implements Work<int[]> {
        private final int[] groupIds;
        private final Page page;
        private boolean finished;
        private int lastPosition;

        public GetNonDictionaryGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.groupIds = new int[page.getPositionCount()];
        }

        @Override
        public boolean process() {
            int batchSize;
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            for (int remainingPositions = positionCount - this.lastPosition; remainingPositions != 0; remainingPositions -= batchSize) {
                batchSize = Math.min(remainingPositions, 1024);
                if (!MultiChannelGroupByHash.this.ensureHashTableSize(batchSize)) {
                    return false;
                }
                for (int i = this.lastPosition; i < this.lastPosition + batchSize; ++i) {
                    this.groupIds[i] = MultiChannelGroupByHash.this.putIfAbsent(i, this.page);
                }
                this.lastPosition += batchSize;
            }
            Verify.verify((this.lastPosition == positionCount ? 1 : 0) != 0);
            return true;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((this.lastPosition == this.page.getPositionCount() ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return this.groupIds;
        }
    }
}

