/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.sql.gen.CompilerOperations;
import javax.annotation.Nullable;

public final class AggregationUtils {
    private AggregationUtils() {
    }

    @UsedByGeneratedCode
    public static Block extractMaskBlock(int maskChannel, Page page) {
        if (maskChannel < 0) {
            return null;
        }
        Block maskBlock = page.getBlock(maskChannel);
        if (page.getPositionCount() > 0 && maskBlock instanceof RunLengthEncodedBlock && CompilerOperations.testMask(maskBlock, 0)) {
            return null;
        }
        return maskBlock;
    }

    @UsedByGeneratedCode
    public static boolean maskGuaranteedToFilterAllRows(int positions, @Nullable Block maskBlock) {
        if (maskBlock == null || positions == 0) {
            return false;
        }
        return maskBlock instanceof RunLengthEncodedBlock && !CompilerOperations.testMask(maskBlock, 0);
    }
}

