/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.Driver;
import io.trino.operator.index.IndexedData;
import io.trino.operator.index.PageBuffer;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StreamingIndexedData
implements IndexedData {
    private final List<Type> outputTypes;
    private final List<BlockTypeOperators.BlockPositionEqual> indexKeyEqualOperators;
    private final Page indexKeyTuple;
    private final PageBuffer pageBuffer;
    private final Driver driver;
    private boolean started;
    private Page currentPage;

    public StreamingIndexedData(List<Type> outputTypes, List<BlockTypeOperators.BlockPositionEqual> indexKeyEqualOperators, Page indexKeyTuple, PageBuffer pageBuffer, Driver driver) {
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        this.indexKeyEqualOperators = ImmutableList.copyOf((Collection)Objects.requireNonNull(indexKeyEqualOperators, "indexKeyEqualOperators is null"));
        this.indexKeyTuple = Objects.requireNonNull(indexKeyTuple, "indexKeyTuple is null");
        Preconditions.checkArgument((indexKeyTuple.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"indexKeyTuple Page should only have one position");
        Preconditions.checkArgument((indexKeyEqualOperators.size() == indexKeyTuple.getChannelCount() ? 1 : 0) != 0, (Object)"indexKeyEqualOperators doesn't match indexKeyTuple columns");
        this.pageBuffer = Objects.requireNonNull(pageBuffer, "pageBuffer is null");
        this.driver = Objects.requireNonNull(driver, "driver is null");
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        Preconditions.checkArgument((page.getChannelCount() == this.indexKeyEqualOperators.size() ? 1 : 0) != 0, (Object)"Number of blocks does not match the number of key columns");
        if (this.started || !this.matchesExpectedKey(position, page)) {
            return -2L;
        }
        this.started = true;
        if (!this.loadNextPage()) {
            return -1L;
        }
        return 0L;
    }

    private boolean matchesExpectedKey(int position, Page page) {
        for (int i = 0; i < this.indexKeyEqualOperators.size(); ++i) {
            if (this.indexKeyEqualOperators.get(i).equal(page.getBlock(i), position, this.indexKeyTuple.getBlock(i), 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        Preconditions.checkState((this.currentPage != null ? 1 : 0) != 0, (Object)"getJoinPosition not called first");
        long nextPosition = currentPosition + 1L;
        if (nextPosition >= (long)this.currentPage.getPositionCount()) {
            if (!this.loadNextPage()) {
                return -1L;
            }
            nextPosition = 0L;
        }
        return nextPosition;
    }

    private boolean loadNextPage() {
        Page nextPage = StreamingIndexedData.extractNonEmptyPage(this.pageBuffer);
        while (nextPage == null) {
            if (this.driver.isFinished()) {
                return false;
            }
            this.driver.processForNumberOfIterations(1);
            nextPage = StreamingIndexedData.extractNonEmptyPage(this.pageBuffer);
        }
        this.currentPage = nextPage;
        return true;
    }

    private static Page extractNonEmptyPage(PageBuffer pageBuffer) {
        Page page = pageBuffer.poll();
        while (page != null && page.getPositionCount() == 0) {
            page = pageBuffer.poll();
        }
        return page;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkState((this.currentPage != null ? 1 : 0) != 0, (Object)"getJoinPosition not called first");
        int intPosition = Math.toIntExact(position);
        for (int i = 0; i < this.outputTypes.size(); ++i) {
            Type type = this.outputTypes.get(i);
            Block block = this.currentPage.getBlock(i);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i + outputChannelOffset);
            type.appendTo(block, intPosition, blockBuilder);
        }
    }

    @Override
    public void close() {
        this.driver.close();
        this.currentPage = null;
    }
}

