/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.SqlQueryExecution;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.operator.RetryPolicy;
import io.trino.operator.join.JoinUtils;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.DomainCoercer;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.roaringbitmap.RoaringBitmap;

@ThreadSafe
public class DynamicFilterService {
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final TypeOperators typeOperators;
    private final DataSize largeMaxSizePerFilter;
    private final DataSize smallMaxSizePerFilter;
    private final Map<QueryId, DynamicFilterContext> dynamicFilterContexts = new ConcurrentHashMap<QueryId, DynamicFilterContext>();

    @Inject
    public DynamicFilterService(Metadata metadata, FunctionManager functionManager, TypeOperators typeOperators, DynamicFilterConfig dynamicFilterConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.largeMaxSizePerFilter = dynamicFilterConfig.getLargeMaxSizePerFilter();
        this.smallMaxSizePerFilter = dynamicFilterConfig.getSmallMaxSizePerFilter();
    }

    public void registerQuery(SqlQueryExecution sqlQueryExecution, SubPlan fragmentedPlan) {
        PlanNode queryPlan = sqlQueryExecution.getQueryPlan().getRoot();
        Set<DynamicFilterId> dynamicFilters = DynamicFilterService.getProducedDynamicFilters(queryPlan);
        Set<DynamicFilterId> replicatedDynamicFilters = DynamicFilterService.getReplicatedDynamicFilters(queryPlan);
        Set lazyDynamicFilters = (Set)fragmentedPlan.getAllFragments().stream().flatMap(plan -> DynamicFilterService.getLazyDynamicFilters(plan).stream()).collect(ImmutableSet.toImmutableSet());
        if (!dynamicFilters.isEmpty()) {
            this.registerQuery(sqlQueryExecution.getQueryId(), sqlQueryExecution.getSession(), dynamicFilters, lazyDynamicFilters, replicatedDynamicFilters);
        }
    }

    @VisibleForTesting
    public void registerQuery(QueryId queryId, Session session, Set<DynamicFilterId> dynamicFilters, Set<DynamicFilterId> lazyDynamicFilters, Set<DynamicFilterId> replicatedDynamicFilters) {
        this.dynamicFilterContexts.putIfAbsent(queryId, new DynamicFilterContext(session, dynamicFilters, lazyDynamicFilters, replicatedDynamicFilters, this.getDynamicFilterSizeLimit(session), 0));
    }

    private DataSize getDynamicFilterSizeLimit(Session session) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            return this.largeMaxSizePerFilter;
        }
        return this.smallMaxSizePerFilter;
    }

    public void registerQueryRetry(QueryId queryId, int attemptId) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return;
        }
        Preconditions.checkState((attemptId == context.getAttemptId() + 1 ? 1 : 0) != 0, (String)"Query %s retry attempt %s was already registered", (Object)queryId, (int)attemptId);
        this.dynamicFilterContexts.put(queryId, context.createContextForQueryRetry(attemptId));
    }

    public DynamicFiltersStats getDynamicFilteringStats(QueryId queryId, Session session) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return DynamicFiltersStats.EMPTY;
        }
        int lazyFilters = context.getLazyDynamicFilters().size();
        int replicatedFilters = context.getReplicatedDynamicFilters().size();
        int totalDynamicFilters = context.getTotalDynamicFilters();
        ConnectorSession connectorSession = session.toConnectorSession();
        List dynamicFilterDomainStats = (List)context.getDynamicFilterSummaries().entrySet().stream().map(entry -> {
            DynamicFilterId dynamicFilterId = (DynamicFilterId)entry.getKey();
            return new DynamicFilterDomainStats(dynamicFilterId, ((Domain)entry.getValue()).toString(connectorSession, 2), context.getDynamicFilterCollectionDuration(dynamicFilterId));
        }).collect(ImmutableList.toImmutableList());
        return new DynamicFiltersStats(dynamicFilterDomainStats, lazyFilters, replicatedFilters, totalDynamicFilters, dynamicFilterDomainStats.size());
    }

    public void removeQuery(QueryId queryId) {
        this.dynamicFilterContexts.remove(queryId);
    }

    public boolean isCollectingTaskNeeded(QueryId queryId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return false;
        }
        return plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION) && !DynamicFilterService.getLazyDynamicFilters(plan).isEmpty();
    }

    public boolean isStageSchedulingNeededToCollectDynamicFilters(QueryId queryId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return false;
        }
        return !plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION) && !DynamicFilterService.getLazyDynamicFilters(plan).isEmpty();
    }

    public void unblockStageDynamicFilters(QueryId queryId, int attemptId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null || attemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((!context.isTaskRetriesEnabled() ? 1 : 0) != 0, (Object)"unblockStageDynamicFilters is not required for task retry mode");
        Preconditions.checkState((attemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Query %s retry attempt %s has not been registered with dynamic filter service", (Object)queryId, (int)attemptId);
        DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan).forEach(filter -> Objects.requireNonNull(context.getLazyDynamicFilters().get(filter), "Future not found").set(null));
    }

    public DynamicFilter createDynamicFilter(QueryId queryId, List<DynamicFilters.Descriptor> dynamicFilterDescriptors, Map<Symbol, ColumnHandle> columnHandles, TypeProvider typeProvider) {
        Multimap<DynamicFilterId, DynamicFilters.Descriptor> symbolsMap = DynamicFilters.extractSourceSymbols(dynamicFilterDescriptors);
        ImmutableSet dynamicFilters = ImmutableSet.copyOf((Collection)symbolsMap.keySet());
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return DynamicFilter.EMPTY;
        }
        final List lazyDynamicFilterFutures = (List)dynamicFilters.stream().map(context.getLazyDynamicFilters()::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        AtomicReference<CurrentDynamicFilter> currentDynamicFilter = new AtomicReference<CurrentDynamicFilter>(new CurrentDynamicFilter(0, (TupleDomain<ColumnHandle>)TupleDomain.all()));
        final Set columnsCovered = (Set)symbolsMap.values().stream().map(DynamicFilters.Descriptor::getInput).map(Symbol::from).map(probeSymbol -> Objects.requireNonNull((ColumnHandle)columnHandles.get(probeSymbol), () -> "Missing probe column for " + probeSymbol)).collect(ImmutableSet.toImmutableSet());
        return new DynamicFilter(){
            final /* synthetic */ Set val$dynamicFilters;
            final /* synthetic */ DynamicFilterContext val$context;
            final /* synthetic */ AtomicReference val$currentDynamicFilter;
            final /* synthetic */ Multimap val$symbolsMap;
            final /* synthetic */ Map val$columnHandles;
            final /* synthetic */ TypeProvider val$typeProvider;
            {
                this.val$dynamicFilters = set2;
                this.val$context = dynamicFilterContext;
                this.val$currentDynamicFilter = atomicReference;
                this.val$symbolsMap = multimap;
                this.val$columnHandles = map;
                this.val$typeProvider = typeProvider;
            }

            public Set<ColumnHandle> getColumnsCovered() {
                return columnsCovered;
            }

            public CompletableFuture<?> isBlocked() {
                List undoneFutures = (List)lazyDynamicFilterFutures.stream().filter(future -> !future.isDone()).collect(ImmutableList.toImmutableList());
                if (undoneFutures.isEmpty()) {
                    return NOT_BLOCKED;
                }
                return MoreFutures.unmodifiableFuture((CompletableFuture)MoreFutures.toCompletableFuture((ListenableFuture)MoreFutures.whenAnyComplete((Iterable)undoneFutures)));
            }

            public boolean isComplete() {
                return this.val$dynamicFilters.stream().allMatch(filterId -> this.val$context.getDynamicFilterSummary((DynamicFilterId)filterId).isPresent());
            }

            public boolean isAwaitable() {
                return lazyDynamicFilterFutures.stream().anyMatch(future -> !future.isDone());
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                ImmutableMap.Builder completedFiltersBuilder = ImmutableMap.builder();
                for (DynamicFilterId filterId : this.val$dynamicFilters) {
                    Optional<Domain> summary = this.val$context.getDynamicFilterSummary(filterId);
                    summary.ifPresent(domain -> completedFiltersBuilder.put((Object)filterId, domain));
                }
                ImmutableMap completedDynamicFilters = completedFiltersBuilder.buildOrThrow();
                CurrentDynamicFilter currentFilter = (CurrentDynamicFilter)this.val$currentDynamicFilter.get();
                if (currentFilter.getCompletedDynamicFiltersCount() >= completedDynamicFilters.size()) {
                    return currentFilter.getDynamicFilter();
                }
                TupleDomain dynamicFilter = TupleDomain.intersect((List)((List)completedDynamicFilters.entrySet().stream().map(filter -> DynamicFilterService.this.translateSummaryToTupleDomain(this.val$context.getSession(), (DynamicFilterId)filter.getKey(), (Domain)filter.getValue(), (Multimap<DynamicFilterId, DynamicFilters.Descriptor>)this.val$symbolsMap, this.val$columnHandles, this.val$typeProvider)).collect(ImmutableList.toImmutableList())));
                this.val$currentDynamicFilter.set(new CurrentDynamicFilter(completedDynamicFilters.size(), (TupleDomain<ColumnHandle>)dynamicFilter));
                return dynamicFilter;
            }
        };
    }

    public void registerDynamicFilterConsumer(QueryId queryId, int attemptId, Set<DynamicFilterId> dynamicFilterIds, Consumer<Map<DynamicFilterId, Domain>> consumer) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null || attemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((context.isTaskRetriesEnabled() || attemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Query %s retry attempt %s has not been registered with dynamic filter service", (Object)queryId, (int)attemptId);
        context.addDynamicFilterConsumer(dynamicFilterIds, consumer);
    }

    public void addTaskDynamicFilters(TaskId taskId, Map<DynamicFilterId, Domain> newDynamicFilters) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(taskId.getQueryId());
        int taskAttemptId = taskId.getAttemptId();
        if (context == null || taskAttemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((context.isTaskRetriesEnabled() || taskAttemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Query %s retry attempt %s has not been registered with dynamic filter service", (Object)taskId.getQueryId(), (int)taskAttemptId);
        context.addTaskDynamicFilters(taskId, newDynamicFilters);
    }

    public void stageCannotScheduleMoreTasks(StageId stageId, int attemptId, int numberOfTasks) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(stageId.getQueryId());
        if (context == null || attemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((attemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Stage %s retry attempt %s has not been registered with dynamic filter service", (Object)stageId, (int)attemptId);
        context.stageCannotScheduleMoreTasks(stageId, numberOfTasks);
    }

    public static Set<DynamicFilterId> getOutboundDynamicFilters(PlanFragment plan) {
        return ImmutableSet.copyOf((Collection)Sets.difference(DynamicFilterService.getConsumedDynamicFilters(plan.getRoot()), DynamicFilterService.getProducedDynamicFilters(plan.getRoot())));
    }

    @VisibleForTesting
    Optional<Domain> getSummary(QueryId queryId, DynamicFilterId filterId) {
        return this.dynamicFilterContexts.get(queryId).getDynamicFilterSummary(filterId);
    }

    private TupleDomain<ColumnHandle> translateSummaryToTupleDomain(Session session, DynamicFilterId filterId, Domain summary, Multimap<DynamicFilterId, DynamicFilters.Descriptor> descriptorMultimap, Map<Symbol, ColumnHandle> columnHandles, TypeProvider typeProvider) {
        Collection descriptors = descriptorMultimap.get((Object)filterId);
        return TupleDomain.withColumnDomains((Map)((Map)descriptors.stream().collect(ImmutableMap.toImmutableMap(descriptor -> {
            Symbol probeSymbol = Symbol.from(descriptor.getInput());
            return Objects.requireNonNull((ColumnHandle)columnHandles.get(probeSymbol), () -> String.format("Missing probe column for %s", probeSymbol));
        }, descriptor -> {
            Type targetType = typeProvider.get(Symbol.from(descriptor.getInput()));
            Domain updatedSummary = descriptor.applyComparison(summary);
            if (!updatedSummary.getType().equals(targetType)) {
                return DomainCoercer.applySaturatedCasts(this.metadata, this.functionManager, this.typeOperators, session, updatedSummary, targetType);
            }
            return updatedSummary;
        }))));
    }

    private static Set<DynamicFilterId> getLazyDynamicFilters(PlanFragment plan) {
        Sets.SetView interStageDynamicFilters = Sets.difference(DynamicFilterService.getProducedDynamicFilters(plan.getRoot()), DynamicFilterService.getConsumedDynamicFilters(plan.getRoot()));
        return ImmutableSet.copyOf((Collection)Sets.union((Set)interStageDynamicFilters, DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan)));
    }

    @VisibleForTesting
    static Set<DynamicFilterId> getSourceStageInnerLazyDynamicFilters(PlanFragment plan) {
        if (!plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
            return ImmutableSet.of();
        }
        PlanNode planNode = plan.getRoot();
        Sets.SetView innerStageDynamicFilters = Sets.intersection(DynamicFilterService.getProducedDynamicFilters(planNode), DynamicFilterService.getConsumedDynamicFilters(planNode));
        Set<DynamicFilterId> replicatedDynamicFilters = DynamicFilterService.getReplicatedDynamicFilters(planNode);
        return ImmutableSet.copyOf((Collection)Sets.intersection((Set)innerStageDynamicFilters, replicatedDynamicFilters));
    }

    private static Set<DynamicFilterId> getReplicatedDynamicFilters(PlanNode planNode) {
        return (Set)PlanNodeSearcher.searchFrom(planNode).whereIsInstanceOfAny(JoinNode.class, SemiJoinNode.class).findAll().stream().filter(JoinUtils::isBuildSideReplicated).flatMap(node -> DynamicFilterService.getDynamicFiltersProducedInPlanNode(node).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<DynamicFilterId> getProducedDynamicFilters(PlanNode planNode) {
        return (Set)PlanNodeSearcher.searchFrom(planNode).whereIsInstanceOfAny(JoinNode.class, SemiJoinNode.class, DynamicFilterSourceNode.class).findAll().stream().flatMap(node -> DynamicFilterService.getDynamicFiltersProducedInPlanNode(node).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<DynamicFilterId> getDynamicFiltersProducedInPlanNode(PlanNode planNode) {
        if (planNode instanceof JoinNode) {
            return ((JoinNode)planNode).getDynamicFilters().keySet();
        }
        if (planNode instanceof SemiJoinNode) {
            return (Set)((SemiJoinNode)planNode).getDynamicFilterId().map(ImmutableSet::of).orElse(ImmutableSet.of());
        }
        if (planNode instanceof DynamicFilterSourceNode) {
            return ((DynamicFilterSourceNode)planNode).getDynamicFilters().keySet();
        }
        throw new IllegalStateException("getDynamicFiltersProducedInPlanNode called with neither JoinNode nor SemiJoinNode");
    }

    private static Set<DynamicFilterId> getConsumedDynamicFilters(PlanNode planNode) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().flatMap(expression -> DynamicFilters.extractDynamicFilters(expression).getDynamicConjuncts().stream()).map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
    }

    private static class DynamicFilterContext {
        private final Session session;
        private final Set<DynamicFilterId> dynamicFilters;
        private final Set<DynamicFilterId> replicatedDynamicFilters;
        private final DataSize dynamicFilterSizeLimit;
        private final Map<DynamicFilterId, SettableFuture<Void>> lazyDynamicFilters;
        private final Map<DynamicFilterId, DynamicFilterCollectionContext> dynamicFilterCollectionContexts;
        private final Map<StageId, Set<DynamicFilterId>> stageDynamicFilters = new ConcurrentHashMap<StageId, Set<DynamicFilterId>>();
        private final Map<StageId, Integer> stageNumberOfTasks = new ConcurrentHashMap<StageId, Integer>();
        private final int attemptId;

        private DynamicFilterContext(Session session, Set<DynamicFilterId> dynamicFilters, Set<DynamicFilterId> lazyDynamicFilters, Set<DynamicFilterId> replicatedDynamicFilters, DataSize dynamicFilterSizeLimit, int attemptId) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.dynamicFilters = Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
            Objects.requireNonNull(lazyDynamicFilters, "lazyDynamicFilters is null");
            this.lazyDynamicFilters = (Map)lazyDynamicFilters.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), filter -> SettableFuture.create()));
            this.replicatedDynamicFilters = Objects.requireNonNull(replicatedDynamicFilters, "replicatedDynamicFilters is null");
            this.dynamicFilterSizeLimit = Objects.requireNonNull(dynamicFilterSizeLimit, "dynamicFilterSizeLimit is null");
            ImmutableMap.Builder collectionContexts = ImmutableMap.builder();
            for (DynamicFilterId dynamicFilterId : dynamicFilters) {
                DynamicFilterCollectionContext collectionContext = new DynamicFilterCollectionContext(replicatedDynamicFilters.contains(dynamicFilterId), dynamicFilterSizeLimit.toBytes());
                collectionContexts.put((Object)dynamicFilterId, (Object)collectionContext);
                SettableFuture<Void> lazyDynamicFilterFuture = this.lazyDynamicFilters.get(dynamicFilterId);
                if (lazyDynamicFilterFuture == null) continue;
                collectionContext.getCollectedDomainFuture().addListener(() -> lazyDynamicFilterFuture.set(null), MoreExecutors.directExecutor());
            }
            this.dynamicFilterCollectionContexts = collectionContexts.buildOrThrow();
            this.attemptId = attemptId;
        }

        DynamicFilterContext createContextForQueryRetry(int attemptId) {
            return new DynamicFilterContext(this.session, this.dynamicFilters, this.lazyDynamicFilters.keySet(), this.replicatedDynamicFilters, this.dynamicFilterSizeLimit, attemptId);
        }

        void addDynamicFilterConsumer(Set<DynamicFilterId> dynamicFilterIds, Consumer<Map<DynamicFilterId, Domain>> consumer) {
            for (DynamicFilterId dynamicFilterId : dynamicFilterIds) {
                DynamicFilterCollectionContext collectionContext = this.dynamicFilterCollectionContexts.get(dynamicFilterId);
                Verify.verify((collectionContext != null ? 1 : 0) != 0, (String)"collectionContext is missing for %s", (Object)dynamicFilterId);
                MoreFutures.addSuccessCallback(collectionContext.getCollectedDomainFuture(), domain -> consumer.accept((Map<DynamicFilterId, Domain>)ImmutableMap.of((Object)dynamicFilterId, (Object)domain)));
            }
        }

        public Session getSession() {
            return this.session;
        }

        private int getTotalDynamicFilters() {
            return this.dynamicFilters.size();
        }

        private void addTaskDynamicFilters(TaskId taskId, Map<DynamicFilterId, Domain> newDynamicFilters) {
            newDynamicFilters.forEach((dynamicFilterId, domain) -> {
                DynamicFilterCollectionContext collectionContext = this.dynamicFilterCollectionContexts.get(dynamicFilterId);
                Verify.verify((collectionContext != null ? 1 : 0) != 0, (String)"collectionContext is missing for %s", (Object)dynamicFilterId);
                collectionContext.collect(taskId, (Domain)domain);
            });
            if (this.stageDynamicFilters.computeIfAbsent(taskId.getStageId(), key -> Sets.newConcurrentHashSet()).addAll(newDynamicFilters.keySet())) {
                this.updateExpectedTaskCount();
            }
        }

        private void stageCannotScheduleMoreTasks(StageId stageId, int numberOfTasks) {
            if (this.stageNumberOfTasks.put(stageId, numberOfTasks) == null) {
                this.updateExpectedTaskCount();
            }
        }

        private void updateExpectedTaskCount() {
            this.stageNumberOfTasks.forEach((stage, taskCount) -> {
                Set<DynamicFilterId> filtersIds = this.stageDynamicFilters.get(stage);
                if (filtersIds != null) {
                    for (DynamicFilterId filterId : filtersIds) {
                        DynamicFilterCollectionContext collectionContext = this.dynamicFilterCollectionContexts.get(filterId);
                        Verify.verify((collectionContext != null ? 1 : 0) != 0, (String)"collectionContext is missing for %s", (Object)filterId);
                        collectionContext.setExpectedTaskCount((int)taskCount);
                    }
                }
            });
        }

        private Map<DynamicFilterId, Domain> getDynamicFilterSummaries() {
            return (Map)this.dynamicFilterCollectionContexts.entrySet().stream().filter(entry -> ((DynamicFilterCollectionContext)entry.getValue()).getCollectedDomainFuture().isDone()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Domain)MoreFutures.getFutureValue(((DynamicFilterCollectionContext)entry.getValue()).getCollectedDomainFuture())));
        }

        private Optional<Domain> getDynamicFilterSummary(DynamicFilterId filterId) {
            DynamicFilterCollectionContext context = this.dynamicFilterCollectionContexts.get(filterId);
            if (context == null || !context.getCollectedDomainFuture().isDone()) {
                return Optional.empty();
            }
            return Optional.of((Domain)MoreFutures.getFutureValue(context.getCollectedDomainFuture()));
        }

        private Map<DynamicFilterId, SettableFuture<Void>> getLazyDynamicFilters() {
            return this.lazyDynamicFilters;
        }

        private Set<DynamicFilterId> getReplicatedDynamicFilters() {
            return this.replicatedDynamicFilters;
        }

        private Optional<Duration> getDynamicFilterCollectionDuration(DynamicFilterId dynamicFilterId) {
            DynamicFilterCollectionContext collectionContext = this.dynamicFilterCollectionContexts.get(dynamicFilterId);
            Verify.verify((collectionContext != null ? 1 : 0) != 0, (String)"collectionContext is missing for %s", (Object)dynamicFilterId);
            return collectionContext.getCollectionDuration();
        }

        private int getAttemptId() {
            return this.attemptId;
        }

        private boolean isTaskRetriesEnabled() {
            return SystemSessionProperties.getRetryPolicy(this.session) == RetryPolicy.TASK;
        }
    }

    public static class DynamicFiltersStats {
        public static final DynamicFiltersStats EMPTY = new DynamicFiltersStats((List<DynamicFilterDomainStats>)ImmutableList.of(), 0, 0, 0, 0);
        private final List<DynamicFilterDomainStats> dynamicFilterDomainStats;
        private final int lazyDynamicFilters;
        private final int replicatedDynamicFilters;
        private final int totalDynamicFilters;
        private final int dynamicFiltersCompleted;

        @JsonCreator
        public DynamicFiltersStats(@JsonProperty(value="dynamicFilterDomainStats") List<DynamicFilterDomainStats> dynamicFilterDomainStats, @JsonProperty(value="lazyDynamicFilters") int lazyDynamicFilters, @JsonProperty(value="replicatedDynamicFilters") int replicatedDynamicFilters, @JsonProperty(value="totalDynamicFilters") int totalDynamicFilters, @JsonProperty(value="dynamicFiltersCompleted") int dynamicFiltersCompleted) {
            this.dynamicFilterDomainStats = Objects.requireNonNull(dynamicFilterDomainStats, "dynamicFilterDomainStats is null");
            this.lazyDynamicFilters = lazyDynamicFilters;
            this.replicatedDynamicFilters = replicatedDynamicFilters;
            this.totalDynamicFilters = totalDynamicFilters;
            this.dynamicFiltersCompleted = dynamicFiltersCompleted;
        }

        @JsonProperty
        public List<DynamicFilterDomainStats> getDynamicFilterDomainStats() {
            return this.dynamicFilterDomainStats;
        }

        @JsonProperty
        public int getLazyDynamicFilters() {
            return this.lazyDynamicFilters;
        }

        @JsonProperty
        public int getReplicatedDynamicFilters() {
            return this.replicatedDynamicFilters;
        }

        @JsonProperty
        public int getTotalDynamicFilters() {
            return this.totalDynamicFilters;
        }

        @JsonProperty
        public int getDynamicFiltersCompleted() {
            return this.dynamicFiltersCompleted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFiltersStats that = (DynamicFiltersStats)o;
            return this.lazyDynamicFilters == that.lazyDynamicFilters && this.replicatedDynamicFilters == that.replicatedDynamicFilters && this.totalDynamicFilters == that.totalDynamicFilters && this.dynamicFiltersCompleted == that.dynamicFiltersCompleted && Objects.equals(this.dynamicFilterDomainStats, that.dynamicFilterDomainStats);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicFilterDomainStats, this.lazyDynamicFilters, this.replicatedDynamicFilters, this.totalDynamicFilters, this.dynamicFiltersCompleted);
        }
    }

    private static class CurrentDynamicFilter {
        private final int completedDynamicFiltersCount;
        private final TupleDomain<ColumnHandle> dynamicFilter;

        private CurrentDynamicFilter(int completedDynamicFiltersCount, TupleDomain<ColumnHandle> dynamicFilter) {
            this.completedDynamicFiltersCount = completedDynamicFiltersCount;
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        }

        private int getCompletedDynamicFiltersCount() {
            return this.completedDynamicFiltersCount;
        }

        private TupleDomain<ColumnHandle> getDynamicFilter() {
            return this.dynamicFilter;
        }
    }

    public static class DynamicFilterDomainStats {
        private final DynamicFilterId dynamicFilterId;
        private final String simplifiedDomain;
        private final Optional<Duration> collectionDuration;

        @VisibleForTesting
        DynamicFilterDomainStats(DynamicFilterId dynamicFilterId, String simplifiedDomain) {
            this(dynamicFilterId, simplifiedDomain, Optional.empty());
        }

        @JsonCreator
        public DynamicFilterDomainStats(@JsonProperty(value="dynamicFilterId") DynamicFilterId dynamicFilterId, @JsonProperty(value="simplifiedDomain") String simplifiedDomain, @JsonProperty(value="collectionDuration") Optional<Duration> collectionDuration) {
            this.dynamicFilterId = Objects.requireNonNull(dynamicFilterId, "dynamicFilterId is null");
            this.simplifiedDomain = Objects.requireNonNull(simplifiedDomain, "simplifiedDomain is null");
            this.collectionDuration = Objects.requireNonNull(collectionDuration, "collectionDuration is null");
        }

        @JsonProperty
        public DynamicFilterId getDynamicFilterId() {
            return this.dynamicFilterId;
        }

        @JsonProperty
        public String getSimplifiedDomain() {
            return this.simplifiedDomain;
        }

        @JsonProperty
        public Optional<Duration> getCollectionDuration() {
            return this.collectionDuration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFilterDomainStats stats = (DynamicFilterDomainStats)o;
            return Objects.equals(this.dynamicFilterId, stats.dynamicFilterId) && Objects.equals(this.simplifiedDomain, stats.simplifiedDomain);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicFilterId, this.simplifiedDomain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dynamicFilterId", (Object)this.dynamicFilterId).add("simplifiedDomain", (Object)this.simplifiedDomain).add("collectionDuration", this.collectionDuration).toString();
        }
    }

    private static class DynamicFilterCollectionContext {
        private final boolean replicated;
        private final long domainSizeLimitInBytes;
        @GuardedBy(value="collectedTasks")
        private final RoaringBitmap collectedTasks = new RoaringBitmap();
        private final Queue<Domain> summaryDomains = new ConcurrentLinkedQueue<Domain>();
        private final AtomicLong summaryDomainsRetainedSizeInBytes = new AtomicLong();
        @GuardedBy(value="this")
        private volatile Integer expectedTaskCount;
        @GuardedBy(value="this")
        private int collectedTaskCount;
        private final long start = System.nanoTime();
        private final AtomicReference<Duration> collectionDuration = new AtomicReference();
        @GuardedBy(value="this")
        private volatile boolean collected;
        private final SettableFuture<Domain> collectedDomainsFuture = SettableFuture.create();

        private DynamicFilterCollectionContext(boolean replicated, long domainSizeLimitInBytes) {
            this.replicated = replicated;
            this.domainSizeLimitInBytes = domainSizeLimitInBytes;
        }

        public void collect(TaskId taskId, Domain domain) {
            if (this.collected) {
                return;
            }
            if (this.replicated) {
                this.collectReplicated(domain);
            } else {
                this.collectPartitioned(taskId, domain);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectReplicated(Domain domain) {
            Domain result;
            if (domain.getRetainedSizeInBytes() > this.domainSizeLimitInBytes) {
                domain = domain.simplify(1);
            }
            if (domain.getRetainedSizeInBytes() > this.domainSizeLimitInBytes) {
                domain = Domain.all((Type)domain.getType());
            }
            DynamicFilterCollectionContext dynamicFilterCollectionContext = this;
            synchronized (dynamicFilterCollectionContext) {
                if (this.collected) {
                    return;
                }
                ++this.collectedTaskCount;
                this.collected = true;
                result = domain;
            }
            this.collectionDuration.set(Duration.succinctNanos((long)(System.nanoTime() - this.start)));
            this.collectedDomainsFuture.set((Object)result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectPartitioned(TaskId taskId, Domain domain) {
            Domain result;
            RoaringBitmap roaringBitmap = this.collectedTasks;
            synchronized (roaringBitmap) {
                if (!this.collectedTasks.checkedAdd(taskId.getPartitionId())) {
                    return;
                }
            }
            this.summaryDomainsRetainedSizeInBytes.addAndGet(domain.getRetainedSizeInBytes());
            this.summaryDomains.add(domain);
            this.unionSummaryDomainsIfNecessary(false);
            DynamicFilterCollectionContext dynamicFilterCollectionContext = this;
            synchronized (dynamicFilterCollectionContext) {
                boolean collectionFinished;
                boolean allPartitionsCollected;
                if (this.collected) {
                    this.clearSummaryDomains();
                    return;
                }
                ++this.collectedTaskCount;
                boolean bl = allPartitionsCollected = this.expectedTaskCount != null && this.expectedTaskCount == this.collectedTaskCount;
                if (allPartitionsCollected) {
                    this.unionSummaryDomainsIfNecessary(true);
                }
                boolean sizeLimitExceeded = false;
                Domain allDomain = null;
                Domain summary = this.summaryDomains.poll();
                if (summary != null) {
                    long originalSize = summary.getRetainedSizeInBytes();
                    if (summary.getRetainedSizeInBytes() > this.domainSizeLimitInBytes) {
                        summary = summary.simplify(1);
                    }
                    if (summary.getRetainedSizeInBytes() > this.domainSizeLimitInBytes) {
                        sizeLimitExceeded = true;
                        allDomain = Domain.all((Type)summary.getType());
                        this.summaryDomainsRetainedSizeInBytes.addAndGet(-originalSize);
                    } else {
                        this.summaryDomainsRetainedSizeInBytes.addAndGet(summary.getRetainedSizeInBytes() - originalSize);
                        this.summaryDomains.add(summary);
                    }
                }
                boolean bl2 = collectionFinished = sizeLimitExceeded || domain.isAll() || allPartitionsCollected;
                if (!collectionFinished) {
                    return;
                }
                this.collected = true;
                if (sizeLimitExceeded) {
                    result = allDomain;
                } else if (domain.isAll()) {
                    this.clearSummaryDomains();
                    result = domain;
                } else {
                    Verify.verify((boolean)allPartitionsCollected, (String)"allPartitionsCollected is expected to be true", (Object[])new Object[0]);
                    int summaryDomainsCount = this.summaryDomains.size();
                    Verify.verify((summaryDomainsCount == 1 ? 1 : 0) != 0, (String)"summaryDomainsCount is expected to be equal to 1, got: %s", (int)summaryDomainsCount);
                    result = this.summaryDomains.poll();
                    Verify.verify((result != null ? 1 : 0) != 0);
                    long currentSize = this.summaryDomainsRetainedSizeInBytes.addAndGet(-result.getRetainedSizeInBytes());
                    Verify.verify((currentSize == 0L ? 1 : 0) != 0, (String)"currentSize is expected to be zero: %s", (long)currentSize);
                }
            }
            this.collectionDuration.set(Duration.succinctNanos((long)(System.nanoTime() - this.start)));
            this.collectedDomainsFuture.set((Object)result);
        }

        private void unionSummaryDomainsIfNecessary(boolean force) {
            Domain domain;
            if (this.summaryDomainsRetainedSizeInBytes.get() < this.domainSizeLimitInBytes && !force) {
                return;
            }
            ArrayList<Domain> domains = new ArrayList<Domain>();
            long domainsRetainedSizeInBytes = 0L;
            while ((domain = this.summaryDomains.poll()) != null) {
                domains.add(domain);
                domainsRetainedSizeInBytes += domain.getRetainedSizeInBytes();
            }
            if (domains.isEmpty()) {
                return;
            }
            Domain union = Domain.union(domains);
            this.summaryDomainsRetainedSizeInBytes.addAndGet(union.getRetainedSizeInBytes() - domainsRetainedSizeInBytes);
            long currentSize = this.summaryDomainsRetainedSizeInBytes.get();
            Verify.verify((currentSize >= 0L ? 1 : 0) != 0, (String)"currentSize is expected to be greater than or equal to zero: %s", (long)currentSize);
            this.summaryDomains.add(union);
        }

        private void clearSummaryDomains() {
            Domain domain;
            long domainsRetainedSizeInBytes = 0L;
            while ((domain = this.summaryDomains.poll()) != null) {
                domainsRetainedSizeInBytes += domain.getRetainedSizeInBytes();
            }
            this.summaryDomainsRetainedSizeInBytes.addAndGet(-domainsRetainedSizeInBytes);
            long currentSize = this.summaryDomainsRetainedSizeInBytes.get();
            Verify.verify((currentSize >= 0L ? 1 : 0) != 0, (String)"currentSize is expected to be greater than or equal to zero: %s", (long)currentSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExpectedTaskCount(int count) {
            Domain result;
            if (this.collected || this.expectedTaskCount != null) {
                return;
            }
            Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (String)"count is expected to be greater than zero: %s", (int)count);
            DynamicFilterCollectionContext dynamicFilterCollectionContext = this;
            synchronized (dynamicFilterCollectionContext) {
                if (this.collected || this.expectedTaskCount != null) {
                    return;
                }
                this.expectedTaskCount = count;
                Verify.verify((this.collectedTaskCount <= this.expectedTaskCount ? 1 : 0) != 0, (String)"collectedTaskCount is expected to be less than or equal to %s, got: %s", (Object)this.expectedTaskCount, (int)this.collectedTaskCount);
                if (this.collectedTaskCount != this.expectedTaskCount) {
                    return;
                }
                this.unionSummaryDomainsIfNecessary(true);
                Verify.verify((this.summaryDomains.size() == 1 ? 1 : 0) != 0);
                result = this.summaryDomains.poll();
                Verify.verify((result != null ? 1 : 0) != 0);
                long currentSize = this.summaryDomainsRetainedSizeInBytes.addAndGet(-result.getRetainedSizeInBytes());
                Verify.verify((currentSize == 0L ? 1 : 0) != 0, (String)"currentSize is expected to be zero: %s", (long)currentSize);
            }
            this.collectionDuration.set(Duration.succinctNanos((long)(System.nanoTime() - this.start)));
            this.collectedDomainsFuture.set((Object)result);
        }

        public ListenableFuture<Domain> getCollectedDomainFuture() {
            return this.collectedDomainsFuture;
        }

        public Optional<Duration> getCollectionDuration() {
            return Optional.ofNullable(this.collectionDuration.get());
        }
    }
}

