/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.SessionContext;
import io.trino.server.SessionSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.security.Identity;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.SqlPath;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class QuerySessionSupplier
implements SessionSupplier {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Optional<String> defaultPath;
    private final Optional<TimeZoneKey> forcedSessionTimeZone;
    private final Optional<String> defaultCatalog;
    private final Optional<String> defaultSchema;

    @Inject
    public QuerySessionSupplier(Metadata metadata, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SqlEnvironmentConfig config) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.defaultPath = Objects.requireNonNull(config.getPath(), "path is null");
        this.forcedSessionTimeZone = Objects.requireNonNull(config.getForcedSessionTimeZone(), "forcedSessionTimeZone is null");
        this.defaultCatalog = Objects.requireNonNull(config.getDefaultCatalog(), "defaultCatalog is null");
        this.defaultSchema = Objects.requireNonNull(config.getDefaultSchema(), "defaultSchema is null");
        Preconditions.checkArgument((this.defaultCatalog.isPresent() || this.defaultSchema.isEmpty() ? 1 : 0) != 0, (Object)"Default schema cannot be set if catalog is not set");
    }

    @Override
    public Session createSession(QueryId queryId, Span querySpan, SessionContext context) {
        Identity authenticatedIdentity;
        Identity identity = context.getIdentity();
        this.accessControl.checkCanSetUser(identity.getPrincipal(), identity.getUser());
        if (context.getAuthenticatedIdentity().isPresent() && !(authenticatedIdentity = context.getAuthenticatedIdentity().get()).getUser().equals(identity.getUser())) {
            authenticatedIdentity = HttpRequestSessionContextFactory.addEnabledRoles(authenticatedIdentity, context.getSelectedRole(), this.metadata);
            this.accessControl.checkCanImpersonateUser(authenticatedIdentity, identity.getUser());
        }
        identity = HttpRequestSessionContextFactory.addEnabledRoles(identity, context.getSelectedRole(), this.metadata);
        Session.SessionBuilder sessionBuilder = Session.builder(this.sessionPropertyManager).setQueryId(queryId).setQuerySpan(querySpan).setIdentity(identity).setPath(context.getPath().or(() -> this.defaultPath).map(SqlPath::new)).setSource(context.getSource()).setRemoteUserAddress(context.getRemoteUserAddress()).setUserAgent(context.getUserAgent()).setClientInfo(context.getClientInfo()).setClientTags(context.getClientTags()).setClientCapabilities(context.getClientCapabilities()).setTraceToken(context.getTraceToken()).setResourceEstimates(context.getResourceEstimates()).setProtocolHeaders(context.getProtocolHeaders());
        if (context.getCatalog().isPresent()) {
            sessionBuilder.setCatalog(context.getCatalog());
            sessionBuilder.setSchema(context.getSchema());
        } else {
            this.defaultCatalog.ifPresent(sessionBuilder::setCatalog);
            this.defaultSchema.ifPresent(sessionBuilder::setSchema);
        }
        if (this.forcedSessionTimeZone.isPresent()) {
            sessionBuilder.setTimeZoneKey(this.forcedSessionTimeZone.get());
        } else {
            String sessionTimeZoneId = context.getSystemProperties().get("time_zone_id");
            if (sessionTimeZoneId != null) {
                sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionTimeZoneId));
            } else {
                sessionBuilder.setTimeZoneKey(context.getTimeZoneId().map(TimeZoneKey::getTimeZoneKey));
            }
        }
        context.getLanguage().ifPresent(s -> sessionBuilder.setLocale(Locale.forLanguageTag(s)));
        for (Map.Entry<String, String> entry : context.getSystemProperties().entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : context.getCatalogSessionProperties().entrySet()) {
            String catalog = entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : context.getPreparedStatements().entrySet()) {
            sessionBuilder.addPreparedStatement(entry.getKey(), (String)entry.getValue());
        }
        if (context.supportClientTransaction()) {
            sessionBuilder.setClientTransactionSupport();
        }
        return sessionBuilder.build();
    }
}

