/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.client.ProtocolHeaders;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.transaction.TransactionId;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SessionContext {
    private final ProtocolHeaders protocolHeaders;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<String> path;
    private final Optional<Identity> authenticatedIdentity;
    private final Identity identity;
    private final SelectedRole selectedRole;
    private final Optional<String> source;
    private final Optional<String> traceToken;
    private final Optional<String> userAgent;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> timeZoneId;
    private final Optional<String> language;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final ResourceEstimates resourceEstimates;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Map<String, String> preparedStatements;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final Optional<String> clientInfo;

    public SessionContext(ProtocolHeaders protocolHeaders, Optional<String> catalog, Optional<String> schema, Optional<String> path, Optional<Identity> authenticatedIdentity, Identity identity, SelectedRole selectedRole, Optional<String> source, Optional<String> traceToken, Optional<String> userAgent, Optional<String> remoteUserAddress, Optional<String> timeZoneId, Optional<String> language, Set<String> clientTags, Set<String> clientCapabilities, ResourceEstimates resourceEstimates, Map<String, String> systemProperties, Map<String, Map<String, String>> catalogSessionProperties, Map<String, String> preparedStatements, Optional<TransactionId> transactionId, boolean clientTransactionSupport, Optional<String> clientInfo) {
        this.protocolHeaders = Objects.requireNonNull(protocolHeaders, "protocolHeaders is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.authenticatedIdentity = Objects.requireNonNull(authenticatedIdentity, "authenticatedIdentity is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.selectedRole = Objects.requireNonNull(selectedRole, "selectedRole is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.timeZoneId = Objects.requireNonNull(timeZoneId, "timeZoneId is null");
        this.language = Objects.requireNonNull(language, "language is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientCapabilities = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientCapabilities, "clientCapabilities is null"));
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        Objects.requireNonNull(catalogSessionProperties, "catalogSessionProperties is null");
        this.catalogSessionProperties = (Map)catalogSessionProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.preparedStatements = ImmutableMap.copyOf(Objects.requireNonNull(preparedStatements, "preparedStatements is null"));
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
    }

    public ProtocolHeaders getProtocolHeaders() {
        return this.protocolHeaders;
    }

    public Optional<Identity> getAuthenticatedIdentity() {
        return this.authenticatedIdentity;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public SelectedRole getSelectedRole() {
        return this.selectedRole;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Optional<String> getTimeZoneId() {
        return this.timeZoneId;
    }

    public Optional<String> getLanguage() {
        return this.language;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        return this.catalogSessionProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public boolean supportClientTransaction() {
        return this.clientTransactionSupport;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }
}

