/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2TokenExchangeResource;
import io.trino.server.security.oauth2.TokenPairSerializer;
import io.trino.server.security.oauth2.TokenRefresher;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.net.URI;
import java.security.Principal;
import java.sql.Date;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class OAuth2Authenticator
extends AbstractBearerAuthenticator {
    private static final Logger log = Logger.get(OAuth2Authenticator.class);
    private final OAuth2Client client;
    private final String principalField;
    private final Optional<String> groupsField;
    private final UserMapping userMapping;
    private final TokenPairSerializer tokenPairSerializer;
    private final TokenRefresher tokenRefresher;

    @Inject
    public OAuth2Authenticator(OAuth2Client client, OAuth2Config config, TokenRefresher tokenRefresher, TokenPairSerializer tokenPairSerializer) {
        this.client = Objects.requireNonNull(client, "service is null");
        this.principalField = config.getPrincipalField();
        this.tokenRefresher = Objects.requireNonNull(tokenRefresher, "tokenRefresher is null");
        this.tokenPairSerializer = Objects.requireNonNull(tokenPairSerializer, "tokenPairSerializer is null");
        this.groupsField = Objects.requireNonNull(config.getGroupsField(), "groupsField is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
    }

    @Override
    protected Optional<Identity> createIdentity(String token) throws UserMappingException {
        Optional<TokenPairSerializer.TokenPair> deserializeToken = this.deserializeToken(token);
        if (deserializeToken.isEmpty()) {
            return Optional.empty();
        }
        TokenPairSerializer.TokenPair tokenPair = deserializeToken.get();
        if (tokenPair.getExpiration().before(Date.from(Instant.now()))) {
            return Optional.empty();
        }
        Optional<Map<String, Object>> claims = this.client.getClaims(tokenPair.getAccessToken());
        if (claims.isEmpty()) {
            return Optional.empty();
        }
        String principal = (String)claims.get().get(this.principalField);
        Identity.Builder builder = Identity.forUser((String)this.userMapping.mapUser(principal));
        builder.withPrincipal((Principal)new BasicPrincipal(principal));
        this.groupsField.flatMap(field -> Optional.ofNullable((List)((Map)claims.get()).get(field))).ifPresent(groups -> builder.withGroups((Set)ImmutableSet.copyOf((Collection)groups)));
        return Optional.of(builder.build());
    }

    private Optional<TokenPairSerializer.TokenPair> deserializeToken(String token) {
        try {
            return Optional.of(this.tokenPairSerializer.deserialize(token));
        }
        catch (RuntimeException ex) {
            log.debug((Throwable)ex, "Failed to deserialize token");
            return Optional.empty();
        }
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, Optional<String> currentToken, String message) {
        return currentToken.flatMap(this::deserializeToken).flatMap(this.tokenRefresher::refreshToken).map(refreshId -> request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getTokenUri(refreshId))).map(tokenUri -> new AuthenticationException(message, String.format("Bearer x_token_server=\"%s\"", tokenUri))).orElseGet(() -> this.needAuthentication(request, message));
    }

    private AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        UUID authId = UUID.randomUUID();
        URI initiateUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getInitiateUri(authId));
        URI tokenUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getTokenUri(authId));
        return new AuthenticationException(message, String.format("Bearer x_redirect_server=\"%s\", x_token_server=\"%s\"", initiateUri, tokenUri));
    }
}

