/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import io.trino.server.security.ResourceSecurity;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

@Path(value="")
public class WebUiStaticResource {
    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/")
    public Response getRoot() {
        return Response.seeOther((URI)URI.create("/ui/")).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/ui")
    public Response getUi() {
        return Response.seeOther((URI)URI.create("/ui/")).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @POST
    @Path(value="/ui/{path: .*}")
    public Response postFile(@PathParam(value="path") String path) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/ui/assets/{path: .*}")
    public Response getAssetsFile(@PathParam(value="path") String path, @Context ServletContext servletContext) throws IOException {
        return this.getFile("assets/" + path, servletContext);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/ui/vendor/{path: .*}")
    public Response getVendorFile(@PathParam(value="path") String path, @Context ServletContext servletContext) throws IOException {
        return this.getFile("vendor/" + path, servletContext);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Path(value="/ui/{path: .*}")
    public Response getFile(@PathParam(value="path") String path, @Context ServletContext servletContext) throws IOException {
        String fullPath;
        if (path.isEmpty()) {
            path = "index.html";
        }
        if (!WebUiStaticResource.isCanonical(fullPath = "/webapp/" + path)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        URL resource = this.getClass().getResource(fullPath);
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)resource.openStream(), (String)servletContext.getMimeType(resource.toString())).build();
    }

    private static boolean isCanonical(String fullPath) {
        try {
            return new URI(fullPath).normalize().getPath().equals(fullPath);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

