/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.log.Logger;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexComparator;
import io.trino.operator.PagesIndexOrdering;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.operator.SimplePagesIndexComparator;
import io.trino.operator.SyntheticAddress;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.util.CompilerUtils;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class OrderingCompiler {
    private static final Logger log = Logger.get(OrderingCompiler.class);
    private final NonEvictableLoadingCache<PagesIndexComparatorCacheKey, PagesIndexOrdering> pagesIndexOrderings = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> this.internalCompilePagesIndexOrdering(key.getSortTypes(), key.getSortChannels(), key.getSortOrders())));
    private final NonEvictableLoadingCache<PagesIndexComparatorCacheKey, PageWithPositionComparator> pageWithPositionComparators = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> this.internalCompilePageWithPositionComparator(key.getSortTypes(), key.getSortChannels(), key.getSortOrders())));
    private final TypeOperators typeOperators;

    @Inject
    public OrderingCompiler(TypeOperators typeOperators) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
    }

    @Managed
    @Nested
    public CacheStatsMBean getPagesIndexOrderingsStats() {
        return new CacheStatsMBean(this.pagesIndexOrderings);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPageWithPositionsComparatorsStats() {
        return new CacheStatsMBean(this.pageWithPositionComparators);
    }

    public PagesIndexOrdering compilePagesIndexOrdering(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Objects.requireNonNull(sortTypes, "sortTypes is null");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        return (PagesIndexOrdering)this.pagesIndexOrderings.getUnchecked((Object)new PagesIndexComparatorCacheKey(sortTypes, sortChannels, sortOrders));
    }

    @VisibleForTesting
    public PagesIndexOrdering internalCompilePagesIndexOrdering(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        PagesIndexComparator comparator;
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        try {
            Class<? extends PagesIndexComparator> pagesHashStrategyClass = this.compilePagesIndexComparator(sortTypes, sortChannels, sortOrders);
            comparator = pagesHashStrategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            log.error(e, "Error compiling comparator for channels %s with order %s", new Object[]{sortChannels, sortOrders});
            comparator = new SimplePagesIndexComparator(sortTypes, sortChannels, sortOrders, this.typeOperators);
        }
        return new PagesIndexOrdering(comparator);
    }

    private Class<? extends PagesIndexComparator> compilePagesIndexComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("PagesIndexComparator"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PagesIndexComparator.class)});
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        this.generatePageIndexCompareTo(classDefinition, callSiteBinder, sortTypes, sortChannels, sortOrders);
        return CompilerUtils.defineClass(classDefinition, PagesIndexComparator.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generatePageIndexCompareTo(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Parameter pagesIndex = Parameter.arg((String)"pagesIndex", PagesIndex.class);
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        MethodDefinition compareToMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "compareTo", ParameterizedType.type(Integer.TYPE), new Parameter[]{pagesIndex, leftPosition, rightPosition});
        Scope scope = compareToMethod.getScope();
        Variable valueAddresses = scope.declareVariable(LongArrayList.class, "valueAddresses");
        compareToMethod.getBody().comment("LongArrayList valueAddresses = pagesIndex.valueAddresses").append((BytecodeNode)valueAddresses.set(pagesIndex.invoke("getValueAddresses", LongArrayList.class, new BytecodeExpression[0])));
        Variable leftPageAddress = scope.declareVariable(Long.TYPE, "leftPageAddress");
        compareToMethod.getBody().comment("long leftPageAddress = valueAddresses.getLong(leftPosition)").append((BytecodeNode)leftPageAddress.set(valueAddresses.invoke("getLong", Long.TYPE, new BytecodeExpression[]{leftPosition})));
        Variable leftBlockIndex = scope.declareVariable(Integer.TYPE, "leftBlockIndex");
        compareToMethod.getBody().comment("int leftBlockIndex = decodeSliceIndex(leftPageAddress)").append((BytecodeNode)leftBlockIndex.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodeSliceIndex", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftPageAddress})));
        Variable leftBlockPosition = scope.declareVariable(Integer.TYPE, "leftBlockPosition");
        compareToMethod.getBody().comment("int leftBlockPosition = decodePosition(leftPageAddress)").append((BytecodeNode)leftBlockPosition.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodePosition", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftPageAddress})));
        Variable rightPageAddress = scope.declareVariable(Long.TYPE, "rightPageAddress");
        compareToMethod.getBody().comment("long rightPageAddress = valueAddresses.getLong(rightPosition);").append((BytecodeNode)rightPageAddress.set(valueAddresses.invoke("getLong", Long.TYPE, new BytecodeExpression[]{rightPosition})));
        Variable rightBlockIndex = scope.declareVariable(Integer.TYPE, "rightBlockIndex");
        compareToMethod.getBody().comment("int rightBlockIndex = decodeSliceIndex(rightPageAddress)").append((BytecodeNode)rightBlockIndex.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodeSliceIndex", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{rightPageAddress})));
        Variable rightBlockPosition = scope.declareVariable(Integer.TYPE, "rightBlockPosition");
        compareToMethod.getBody().comment("int rightBlockPosition = decodePosition(rightPageAddress)").append((BytecodeNode)rightBlockPosition.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodePosition", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{rightPageAddress})));
        for (int i = 0; i < sortChannels.size(); ++i) {
            int sortChannel = sortChannels.get(i);
            SortOrder sortOrder = sortOrders.get(i);
            Type sortType = sortTypes.get(i);
            MethodHandle compareBlockValue = this.getBlockPositionOrderingOperator(sortOrder, sortType);
            BytecodeBlock block = new BytecodeBlock().setDescription("compare channel " + sortChannel + " " + sortOrder);
            BytecodeExpression leftBlock = pagesIndex.invoke("getChannel", ObjectArrayList.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)}).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = pagesIndex.invoke("getChannel", ObjectArrayList.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)}).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
            block.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(compareBlockValue).getBindingId()), (String)"compareBlockValue", (MethodType)compareBlockValue.type(), (BytecodeExpression[])new BytecodeExpression[]{leftBlock, leftBlockPosition, rightBlock, rightBlockPosition}));
            LabelNode equal = new LabelNode("equal");
            block.comment("if (compare != 0) return compare").dup().ifZeroGoto(equal).retInt().visitLabel(equal).pop(Integer.TYPE);
            compareToMethod.getBody().append((BytecodeNode)block);
        }
        compareToMethod.getBody().push(0).retInt();
    }

    private MethodHandle getBlockPositionOrderingOperator(SortOrder sortOrder, Type sortType) {
        return this.typeOperators.getOrderingOperator(sortType, sortOrder, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
    }

    public PageWithPositionComparator compilePageWithPositionComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Objects.requireNonNull(sortTypes, "sortTypes is null");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        return (PageWithPositionComparator)this.pageWithPositionComparators.getUnchecked((Object)new PagesIndexComparatorCacheKey(sortTypes, sortChannels, sortOrders));
    }

    private PageWithPositionComparator internalCompilePageWithPositionComparator(List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        PageWithPositionComparator comparator;
        try {
            Class<? extends PageWithPositionComparator> pageWithPositionsComparatorClass = this.generatePageWithPositionComparatorClass(types, sortChannels, sortOrders);
            comparator = pageWithPositionsComparatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            log.error(t, "Error compiling comparator for channels %s with order %s", new Object[]{sortChannels, sortChannels});
            comparator = new SimplePageWithPositionComparator(types, sortChannels, sortOrders, this.typeOperators);
        }
        return comparator;
    }

    private Class<? extends PageWithPositionComparator> generatePageWithPositionComparatorClass(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("PageWithPositionComparator"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PageWithPositionComparator.class)});
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        this.generateMergeSortCompareTo(classDefinition, callSiteBinder, sortTypes, sortChannels, sortOrders);
        return CompilerUtils.defineClass(classDefinition, PageWithPositionComparator.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateMergeSortCompareTo(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Parameter leftPage = Parameter.arg((String)"leftPage", Page.class);
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        MethodDefinition compareToMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "compareTo", ParameterizedType.type(Integer.TYPE), new Parameter[]{leftPage, leftPosition, rightPage, rightPosition});
        for (int i = 0; i < sortChannels.size(); ++i) {
            int sortChannel = sortChannels.get(i);
            SortOrder sortOrder = sortOrders.get(i);
            Type sortType = types.get(sortChannel);
            MethodHandle compareBlockValue = this.getBlockPositionOrderingOperator(sortOrder, sortType);
            BytecodeBlock block = new BytecodeBlock().setDescription("compare channel " + sortChannel + " " + sortOrder);
            BytecodeExpression leftBlock = leftPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)});
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)});
            block.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(compareBlockValue).getBindingId()), (String)"compareBlockValue", (MethodType)compareBlockValue.type(), (BytecodeExpression[])new BytecodeExpression[]{leftBlock, leftPosition, rightBlock, rightPosition}));
            LabelNode equal = new LabelNode("equal");
            block.comment("if (compare != 0) return compare").dup().ifZeroGoto(equal).retInt().visitLabel(equal).pop(Integer.TYPE);
            compareToMethod.getBody().append((BytecodeNode)block);
        }
        compareToMethod.getBody().push(0).retInt();
    }

    private static final class PagesIndexComparatorCacheKey {
        private final List<Type> sortTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;

        private PagesIndexComparatorCacheKey(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.sortTypes = ImmutableList.copyOf(sortTypes);
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrders = ImmutableList.copyOf(sortOrders);
        }

        public List<Type> getSortTypes() {
            return this.sortTypes;
        }

        public List<Integer> getSortChannels() {
            return this.sortChannels;
        }

        public List<SortOrder> getSortOrders() {
            return this.sortOrders;
        }

        public int hashCode() {
            return Objects.hash(this.sortTypes, this.sortChannels, this.sortOrders);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PagesIndexComparatorCacheKey other = (PagesIndexComparatorCacheKey)obj;
            return Objects.equals(this.sortTypes, other.sortTypes) && Objects.equals(this.sortChannels, other.sortChannels) && Objects.equals(this.sortOrders, other.sortOrders);
        }
    }
}

