/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.likematcher.LikeMatcher;
import io.trino.metadata.ResolvedFunction;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.LiteralInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.type.JoniRegexp;
import io.trino.type.JoniRegexpType;
import io.trino.type.LikePatternType;
import io.trino.type.Re2JRegexp;
import io.trino.type.Re2JRegexpType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorExpressionTranslator {
    private ConnectorExpressionTranslator() {
    }

    public static Expression translate(Session session, ConnectorExpression expression, PlannerContext plannerContext, Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
        return new ConnectorToSqlExpressionTranslator(session, plannerContext, literalEncoder, variableMappings).translate(expression).orElseThrow(() -> new UnsupportedOperationException("Expression is not supported: " + expression.toString()));
    }

    public static Optional<ConnectorExpression> translate(Session session, Expression expression, TypeProvider types, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        return (Optional)new SqlToConnectorExpressionTranslator(session, typeAnalyzer.getTypes(session, types, expression), plannerContext).process((Node)expression);
    }

    public static ConnectorExpressionTranslation translateConjuncts(Session session, Expression expression, TypeProvider types, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        Map<NodeRef<Expression>, Type> remainingExpressionTypes = typeAnalyzer.getTypes(session, types, expression);
        SqlToConnectorExpressionTranslator translator = new SqlToConnectorExpressionTranslator(session, remainingExpressionTypes, plannerContext);
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression);
        ArrayList<Expression> remaining = new ArrayList<Expression>();
        ArrayList<ConnectorExpression> converted = new ArrayList<ConnectorExpression>(conjuncts.size());
        for (Expression conjunct : conjuncts) {
            Optional connectorExpression = (Optional)translator.process((Node)conjunct);
            if (connectorExpression.isPresent()) {
                converted.add((ConnectorExpression)connectorExpression.get());
                continue;
            }
            remaining.add(conjunct);
        }
        return new ConnectorExpressionTranslation(ConnectorExpressions.and(converted), ExpressionUtils.combineConjuncts(plannerContext.getMetadata(), remaining));
    }

    @VisibleForTesting
    static FunctionName functionNameForComparisonOperator(ComparisonExpression.Operator operator) {
        return switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case ComparisonExpression.Operator.EQUAL -> StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.NOT_EQUAL -> StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.LESS_THAN -> StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.GREATER_THAN -> StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME;
        };
    }

    @VisibleForTesting
    static FunctionName functionNameForArithmeticBinaryOperator(ArithmeticBinaryExpression.Operator operator) {
        return switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case ArithmeticBinaryExpression.Operator.ADD -> StandardFunctions.ADD_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.SUBTRACT -> StandardFunctions.SUBTRACT_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.MULTIPLY -> StandardFunctions.MULTIPLY_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.DIVIDE -> StandardFunctions.DIVIDE_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.MODULUS -> StandardFunctions.MODULUS_FUNCTION_NAME;
        };
    }

    private static class ConnectorToSqlExpressionTranslator {
        private final Session session;
        private final PlannerContext plannerContext;
        private final LiteralEncoder literalEncoder;
        private final Map<String, Symbol> variableMappings;

        public ConnectorToSqlExpressionTranslator(Session session, PlannerContext plannerContext, LiteralEncoder literalEncoder, Map<String, Symbol> variableMappings) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
            this.variableMappings = Objects.requireNonNull(variableMappings, "variableMappings is null");
        }

        public Optional<Expression> translate(ConnectorExpression expression) {
            if (expression instanceof Variable) {
                String name = ((Variable)expression).getName();
                return Optional.of(this.variableMappings.get(name).toSymbolReference());
            }
            if (expression instanceof Constant) {
                return Optional.of(this.literalEncoder.toExpression(this.session, ((Constant)expression).getValue(), expression.getType()));
            }
            if (expression instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)expression;
                return this.translate(dereference.getTarget()).map(base -> new SubscriptExpression(base, (Expression)new LongLiteral(Long.toString(dereference.getField() + 1))));
            }
            if (expression instanceof Call) {
                return this.translateCall((Call)expression);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateCall(Call call) {
            Optional<ComparisonExpression.Operator> operator;
            if (call.getFunctionName().getCatalogSchema().isPresent()) {
                return Optional.empty();
            }
            if (StandardFunctions.AND_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(LogicalExpression.Operator.AND, call.getArguments());
            }
            if (StandardFunctions.OR_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(LogicalExpression.Operator.OR, call.getArguments());
            }
            if (StandardFunctions.NOT_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                Call innerCall;
                ConnectorExpression expression = (ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments());
                if (expression instanceof Call && (innerCall = (Call)expression).getFunctionName().equals((Object)StandardFunctions.IS_NULL_FUNCTION_NAME) && innerCall.getArguments().size() == 1) {
                    return this.translateIsNotNull((ConnectorExpression)innerCall.getArguments().get(0));
                }
                return this.translateNot(expression);
            }
            if (StandardFunctions.IS_NULL_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateIsNull((ConnectorExpression)call.getArguments().get(0));
            }
            if (StandardFunctions.NULLIF_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateNullIf((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.CAST_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateCast(call.getType(), (ConnectorExpression)call.getArguments().get(0));
            }
            if (call.getArguments().size() == 2 && (operator = this.comparisonOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateComparison(operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (call.getArguments().size() == 2 && (operator = this.arithmeticBinaryOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateArithmeticBinary((ArithmeticBinaryExpression.Operator)operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.NEGATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translate((ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments())).map(argument -> new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, argument));
            }
            if (StandardFunctions.LIKE_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return switch (call.getArguments().size()) {
                    case 2 -> this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.empty());
                    case 3 -> this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.of((ConnectorExpression)call.getArguments().get(2)));
                    default -> Optional.empty();
                };
            }
            if (StandardFunctions.IN_PREDICATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateInPredicate((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            QualifiedName name = QualifiedName.of((String)call.getFunctionName().getName());
            List argumentTypes = (List)call.getArguments().stream().map(argument -> argument.getType().getTypeSignature()).collect(ImmutableList.toImmutableList());
            ResolvedFunction resolved = this.plannerContext.getMetadata().resolveFunction(this.session, name, TypeSignatureProvider.fromTypeSignatures(argumentTypes));
            FunctionCallBuilder builder = FunctionCallBuilder.resolve(this.session, this.plannerContext.getMetadata()).setName(name);
            for (int i = 0; i < call.getArguments().size(); ++i) {
                ConnectorExpression argument2 = (ConnectorExpression)call.getArguments().get(i);
                Type formalType = (Type)resolved.getSignature().getArgumentTypes().get(i);
                Type argumentType = argument2.getType();
                Optional<Expression> translated = this.translate(argument2);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                Expression expression = translated.get();
                if ((formalType == JoniRegexpType.JONI_REGEXP || formalType instanceof Re2JRegexpType) && argumentType instanceof VarcharType) {
                    expression = new Cast(expression, TypeSignatureTranslator.toSqlType(formalType));
                } else if (!argumentType.equals(formalType)) {
                    throw new IllegalArgumentException(String.format("Unexpected type %s for argument %s of type %s of %s", argumentType, formalType, i, name));
                }
                builder.addArgument(formalType, expression);
            }
            return Optional.of(builder.build());
        }

        private Optional<Expression> translateIsNotNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNotNullPredicate(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateIsNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNullPredicate(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateNot(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (argument.getType().equals(BooleanType.BOOLEAN) && translatedArgument.isPresent()) {
                return Optional.of(new NotExpression(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateCast(Type type, ConnectorExpression expression) {
            Optional<Expression> translatedExpression = this.translate(expression);
            if (translatedExpression.isPresent()) {
                return Optional.of(new Cast(translatedExpression.get(), TypeSignatureTranslator.toSqlType(type)));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateLogicalExpression(LogicalExpression.Operator operator, List<ConnectorExpression> arguments) {
            Optional<List<Expression>> translatedArguments = this.translateExpressions(arguments);
            return translatedArguments.map(expressions -> new LogicalExpression(operator, expressions));
        }

        private Optional<Expression> translateComparison(ComparisonExpression.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new ComparisonExpression(operator, leftTranslated, rightTranslated)));
        }

        private Optional<Expression> translateNullIf(ConnectorExpression first, ConnectorExpression second) {
            Optional<Expression> firstExpression = this.translate(first);
            Optional<Expression> secondExpression = this.translate(second);
            if (firstExpression.isPresent() && secondExpression.isPresent()) {
                return Optional.of(new NullIfExpression(firstExpression.get(), secondExpression.get()));
            }
            return Optional.empty();
        }

        private Optional<ComparisonExpression.Operator> comparisonOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.EQUAL);
            }
            if (StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.NOT_EQUAL);
            }
            if (StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.LESS_THAN);
            }
            if (StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL);
            }
            if (StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.GREATER_THAN);
            }
            if (StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL);
            }
            if (StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM);
            }
            return Optional.empty();
        }

        private Optional<Expression> translateArithmeticBinary(ArithmeticBinaryExpression.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new ArithmeticBinaryExpression(operator, leftTranslated, rightTranslated)));
        }

        private Optional<ArithmeticBinaryExpression.Operator> arithmeticBinaryOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.ADD_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.ADD);
            }
            if (StandardFunctions.SUBTRACT_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.SUBTRACT);
            }
            if (StandardFunctions.MULTIPLY_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.MULTIPLY);
            }
            if (StandardFunctions.DIVIDE_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.DIVIDE);
            }
            if (StandardFunctions.MODULUS_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.MODULUS);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateLike(ConnectorExpression value, ConnectorExpression pattern, Optional<ConnectorExpression> escape) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<Expression> translatedPattern = this.translate(pattern);
            if (translatedValue.isPresent() && translatedPattern.isPresent()) {
                FunctionCall patternCall;
                if (escape.isPresent()) {
                    Optional<Expression> translatedEscape = this.translate(escape.get());
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    patternCall = FunctionCallBuilder.resolve(this.session, this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$like_pattern")).addArgument(pattern.getType(), translatedPattern.get()).addArgument(escape.get().getType(), translatedEscape.get()).build();
                } else {
                    patternCall = FunctionCallBuilder.resolve(this.session, this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$like_pattern")).addArgument(pattern.getType(), translatedPattern.get()).build();
                }
                FunctionCall call = FunctionCallBuilder.resolve(this.session, this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$like")).addArgument(value.getType(), translatedValue.get()).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
                return Optional.of(call);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateInPredicate(ConnectorExpression value, ConnectorExpression values) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<List<Expression>> translatedValues = this.extractExpressionsFromArrayCall(values);
            if (translatedValue.isPresent() && translatedValues.isPresent()) {
                return Optional.of(new InPredicate(translatedValue.get(), (Expression)new InListExpression(translatedValues.get())));
            }
            return Optional.empty();
        }

        protected Optional<List<Expression>> extractExpressionsFromArrayCall(ConnectorExpression expression) {
            if (!(expression instanceof Call)) {
                return Optional.empty();
            }
            Call call = (Call)expression;
            if (!call.getFunctionName().equals((Object)StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME)) {
                return Optional.empty();
            }
            return this.translateExpressions(call.getArguments());
        }

        protected Optional<List<Expression>> translateExpressions(List<ConnectorExpression> expressions) {
            ImmutableList.Builder translatedExpressions = ImmutableList.builderWithExpectedSize((int)expressions.size());
            for (ConnectorExpression expression : expressions) {
                Optional<Expression> translated = this.translate(expression);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                translatedExpressions.add((Object)translated.get());
            }
            return Optional.of(translatedExpressions.build());
        }
    }

    public static class SqlToConnectorExpressionTranslator
    extends AstVisitor<Optional<ConnectorExpression>, Void> {
        private final Session session;
        private final Map<NodeRef<Expression>, Type> types;
        private final PlannerContext plannerContext;
        private final LiteralInterpreter literalInterpreter;

        public SqlToConnectorExpressionTranslator(Session session, Map<NodeRef<Expression>, Type> types, PlannerContext plannerContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
        }

        protected Optional<ConnectorExpression> visitSymbolReference(SymbolReference node, Void context) {
            return Optional.of(new Variable(node.getName(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitLiteral(Literal node, Void context) {
            Type type = this.typeOf((Expression)node);
            return Optional.of(new Constant(this.literalInterpreter.evaluate((Expression)node, type), type));
        }

        protected Optional<ConnectorExpression> visitLogicalExpression(LogicalExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            ImmutableList.Builder arguments = ImmutableList.builderWithExpectedSize((int)node.getTerms().size());
            for (Node argument : node.getChildren()) {
                Optional translated = (Optional)this.process(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translated.get()));
            }
            return switch (node.getOperator()) {
                default -> throw new IncompatibleClassChangeError();
                case LogicalExpression.Operator.AND -> Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)arguments.build()));
                case LogicalExpression.Operator.OR -> Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.OR_FUNCTION_NAME, (List)arguments.build()));
            };
        }

        protected Optional<ConnectorExpression> visitComparisonExpression(ComparisonExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process((Node)node.getLeft())).flatMap(left -> ((Optional)this.process((Node)node.getRight())).map(right -> new Call(this.typeOf((Expression)node), ConnectorExpressionTranslator.functionNameForComparisonOperator(node.getOperator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        protected Optional<ConnectorExpression> visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process((Node)node.getLeft())).flatMap(left -> ((Optional)this.process((Node)node.getRight())).map(right -> new Call(this.typeOf((Expression)node), ConnectorExpressionTranslator.functionNameForArithmeticBinaryOperator(node.getOperator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        protected Optional<ConnectorExpression> visitBetweenPredicate(BetweenPredicate node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process((Node)node.getValue())).flatMap(value -> ((Optional)this.process((Node)node.getMin())).flatMap(min -> ((Optional)this.process((Node)node.getMax())).map(max -> new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)ImmutableList.of((Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)min)), (Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)max)))))));
        }

        protected Optional<ConnectorExpression> visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return switch (node.getSign()) {
                default -> throw new IncompatibleClassChangeError();
                case ArithmeticUnaryExpression.Sign.PLUS -> (Optional<ConnectorExpression>)this.process((Node)node.getValue());
                case ArithmeticUnaryExpression.Sign.MINUS -> ((Optional)this.process((Node)node.getValue())).map(value -> new Call(this.typeOf((Expression)node), StandardFunctions.NEGATE_FUNCTION_NAME, (List)ImmutableList.of((Object)value)));
            };
        }

        protected Optional<ConnectorExpression> visitCast(Cast node, Void context) {
            if (ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, (Expression)node)) {
                return Optional.of(this.constantFor((Expression)node));
            }
            if (node.isSafe()) {
                return Optional.empty();
            }
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            Optional translatedExpression = (Optional)this.process((Node)node.getExpression());
            if (translatedExpression.isPresent()) {
                Type type = this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
                return Optional.of(new Call(type, StandardFunctions.CAST_FUNCTION_NAME, List.of((ConnectorExpression)translatedExpression.get())));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitFunctionCall(FunctionCall node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            if (ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, (Expression)node)) {
                return Optional.of(this.constantFor((Expression)node));
            }
            if (node.getFilter().isPresent() || node.getOrderBy().isPresent() || node.getWindow().isPresent() || node.getNullTreatment().isPresent() || node.isDistinct()) {
                return Optional.empty();
            }
            String functionName = ResolvedFunction.extractFunctionName(node.getName());
            Preconditions.checkArgument((!"$internal$dynamic_filter_function".equals(functionName) ? 1 : 0) != 0, (Object)"Dynamic filter has no meaning for a connector, it should not be translated into ConnectorExpression");
            Preconditions.checkArgument((!"$literal$".equalsIgnoreCase(functionName) ? 1 : 0) != 0, (Object)"Unexpected literal function");
            if (functionName.equals("$like")) {
                return this.translateLike(node);
            }
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (Expression argumentExpression : node.getArguments()) {
                Optional argument = (Optional)this.process((Node)argumentExpression);
                if (argument.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)argument.get()));
            }
            FunctionName name = new FunctionName(functionName);
            return Optional.of(new Call(this.typeOf((Expression)node), name, (List)arguments.build()));
        }

        private Optional<ConnectorExpression> translateLike(FunctionCall node) {
            FunctionCall call;
            ImmutableList.Builder arguments = ImmutableList.builder();
            Optional value = (Optional)this.process((Node)node.getArguments().get(0));
            if (value.isEmpty()) {
                return Optional.empty();
            }
            arguments.add((Object)((ConnectorExpression)value.get()));
            Expression patternArgument = (Expression)node.getArguments().get(1);
            if (ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, patternArgument)) {
                LikeMatcher matcher = (LikeMatcher)ExpressionInterpreter.evaluateConstantExpression(patternArgument, this.typeOf(patternArgument), this.plannerContext, this.session, new AllowAllAccessControl(), (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of());
                arguments.add((Object)new Constant((Object)Slices.utf8Slice((String)matcher.getPattern()), (Type)VarcharType.createVarcharType((int)matcher.getPattern().length())));
                if (matcher.getEscape().isPresent()) {
                    arguments.add((Object)new Constant((Object)Slices.utf8Slice((String)matcher.getEscape().get().toString()), (Type)VarcharType.createVarcharType((int)1)));
                }
            } else if (patternArgument instanceof FunctionCall && ResolvedFunction.extractFunctionName((call = (FunctionCall)patternArgument).getName()).equals("$like_pattern")) {
                Optional translatedPattern = (Optional)this.process((Node)call.getArguments().get(0));
                if (translatedPattern.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translatedPattern.get()));
                if (call.getArguments().size() == 2) {
                    Optional translatedEscape = (Optional)this.process((Node)call.getArguments().get(1));
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    arguments.add((Object)((ConnectorExpression)translatedEscape.get()));
                }
            } else {
                return Optional.empty();
            }
            return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.LIKE_FUNCTION_NAME, (List)arguments.build()));
        }

        protected Optional<ConnectorExpression> visitIsNullPredicate(IsNullPredicate node, Void context) {
            Optional translatedValue = (Optional)this.process((Node)node.getValue());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)translatedValue.get()))));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            Optional translatedValue = (Optional)this.process((Node)node.getValue());
            if (translatedValue.isPresent()) {
                Call isNullCall = new Call(this.typeOf((Expression)node), StandardFunctions.IS_NULL_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get()));
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(isNullCall)));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitNotExpression(NotExpression node, Void context) {
            Optional translatedValue = (Optional)this.process((Node)node.getValue());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get())));
            }
            return Optional.empty();
        }

        private ConnectorExpression constantFor(Expression node) {
            Type type = this.typeOf(node);
            Object value = ExpressionInterpreter.evaluateConstantExpression(node, type, this.plannerContext, this.session, new AllowAllAccessControl(), (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of());
            if (type == JoniRegexpType.JONI_REGEXP) {
                Slice pattern = ((JoniRegexp)value).pattern();
                return new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            if (type instanceof Re2JRegexpType) {
                Slice pattern = Slices.utf8Slice((String)((Re2JRegexp)value).pattern());
                return new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            return new Constant(value, type);
        }

        protected Optional<ConnectorExpression> visitLikePredicate(LikePredicate node, Void context) {
            Optional value = (Optional)this.process((Node)node.getValue());
            Optional pattern = (Optional)this.process((Node)node.getPattern());
            if (value.isPresent() && pattern.isPresent()) {
                if (node.getEscape().isEmpty()) {
                    return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.LIKE_FUNCTION_NAME, List.of((ConnectorExpression)value.get(), (ConnectorExpression)pattern.get())));
                }
                Optional escape = (Optional)this.process((Node)node.getEscape().get());
                if (escape.isPresent()) {
                    return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.LIKE_FUNCTION_NAME, List.of((ConnectorExpression)value.get(), (ConnectorExpression)pattern.get(), (ConnectorExpression)escape.get())));
                }
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitNullIfExpression(NullIfExpression node, Void context) {
            Optional firstValue = (Optional)this.process((Node)node.getFirst());
            Optional secondValue = (Optional)this.process((Node)node.getSecond());
            if (firstValue.isPresent() && secondValue.isPresent()) {
                return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.NULLIF_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)firstValue.get()), (Object)((ConnectorExpression)secondValue.get()))));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitSubscriptExpression(SubscriptExpression node, Void context) {
            if (!(this.typeOf(node.getBase()) instanceof RowType)) {
                return Optional.empty();
            }
            Optional translatedBase = (Optional)this.process((Node)node.getBase());
            if (translatedBase.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new FieldDereference(this.typeOf((Expression)node), (ConnectorExpression)translatedBase.get(), Math.toIntExact(((LongLiteral)node.getIndex()).getParsedValue() - 1L)));
        }

        protected Optional<ConnectorExpression> visitInPredicate(InPredicate node, Void context) {
            InListExpression valueList = (InListExpression)node.getValueList();
            Optional valueExpression = (Optional)this.process((Node)node.getValue());
            if (valueExpression.isEmpty()) {
                return Optional.empty();
            }
            ImmutableList.Builder values = ImmutableList.builderWithExpectedSize((int)valueList.getValues().size());
            for (Expression value : valueList.getValues()) {
                if (value == null || value instanceof NullLiteral) {
                    return Optional.empty();
                }
                Optional processedValue = (Optional)this.process((Node)value);
                if (processedValue.isEmpty()) {
                    return Optional.empty();
                }
                values.add((Object)((ConnectorExpression)processedValue.get()));
            }
            Call arrayExpression = new Call((Type)new ArrayType(this.typeOf(node.getValueList())), StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME, (List)values.build());
            return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.IN_PREDICATE_FUNCTION_NAME, List.of((ConnectorExpression)valueExpression.get(), arrayExpression)));
        }

        protected Optional<ConnectorExpression> visitExpression(Expression node, Void context) {
            return Optional.empty();
        }

        private Type typeOf(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }
    }

    public record ConnectorExpressionTranslation(ConnectorExpression connectorExpression, Expression remainingExpression) {
        public ConnectorExpressionTranslation {
            Objects.requireNonNull(connectorExpression, "connectorExpression is null");
            Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }
    }
}

