/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import io.trino.metadata.ResolvedFunction;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(RowExpression expression) {
        return expression.accept(new Visitor(), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Boolean, Void> {
        private Visitor() {
        }

        @Override
        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        @Override
        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        @Override
        public Boolean visitCall(CallExpression call, Void context) {
            ResolvedFunction resolvedFunction = call.getResolvedFunction();
            if (!resolvedFunction.isDeterministic()) {
                return false;
            }
            return call.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        @Override
        public Boolean visitSpecialForm(SpecialForm specialForm, Void context) {
            return specialForm.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        @Override
        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda.getBody().accept(this, context);
        }

        @Override
        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return true;
        }
    }
}

