/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.trino.likematcher.LikeMatcher;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Chars;
import io.trino.util.Failures;
import java.util.Optional;

public final class LikeFunctions {
    public static final String LIKE_FUNCTION_NAME = "$like";
    public static final String LIKE_PATTERN_FUNCTION_NAME = "$like_pattern";

    private LikeFunctions() {
    }

    @ScalarFunction(value="$like", hidden=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean likeChar(@LiteralParameter(value="x") Long x, @SqlType(value="char(x)") Slice value, @SqlType(value="LikePattern") LikeMatcher pattern) {
        return LikeFunctions.likeVarchar(Chars.padSpaces((Slice)value, (int)x.intValue()), pattern);
    }

    @ScalarFunction(value="$like", hidden=true)
    @SqlType(value="boolean")
    public static boolean likeVarchar(@SqlType(value="varchar") Slice value, @SqlType(value="LikePattern") LikeMatcher matcher) {
        if (value.hasByteArray()) {
            return matcher.match(value.byteArray(), value.byteArrayOffset(), value.length());
        }
        return matcher.match(value.getBytes(), 0, value.length());
    }

    @ScalarFunction(value="$like_pattern", hidden=true)
    @SqlType(value="LikePattern")
    public static LikeMatcher likePattern(@SqlType(value="varchar") Slice pattern) {
        return LikeMatcher.compile(pattern.toStringUtf8(), Optional.empty(), false);
    }

    @ScalarFunction(value="$like_pattern", hidden=true)
    @SqlType(value="LikePattern")
    public static LikeMatcher likePattern(@SqlType(value="varchar") Slice pattern, @SqlType(value="varchar") Slice escape) {
        try {
            return LikeMatcher.compile(pattern.toStringUtf8(), LikeFunctions.getEscapeCharacter(Optional.of(escape)), false);
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    public static boolean isMatchAllPattern(Slice pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            byte current = pattern.getByte(i);
            if (current == 37) continue;
            return false;
        }
        return true;
    }

    public static boolean isLikePattern(Slice pattern, Optional<Slice> escape) {
        return LikeFunctions.patternConstantPrefixBytes(pattern, escape) < pattern.length();
    }

    public static int patternConstantPrefixBytes(Slice pattern, Optional<Slice> escape) {
        int position;
        int currentChar;
        int escapeChar = LikeFunctions.getEscapeCharacter(escape).map(c -> c.charValue()).orElse(-1);
        boolean escaped = false;
        for (position = 0; position < pattern.length(); position += SliceUtf8.lengthOfCodePoint((int)currentChar)) {
            currentChar = SliceUtf8.getCodePointAt((Slice)pattern, (int)position);
            if (!escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            if (escaped) {
                LikeFunctions.checkEscape(currentChar == 37 || currentChar == 95 || currentChar == escapeChar);
                escaped = false;
                continue;
            }
            if (currentChar != 37 && currentChar != 95) continue;
            return position;
        }
        LikeFunctions.checkEscape(!escaped);
        return position;
    }

    public static Slice unescapeLiteralLikePattern(Slice pattern, Optional<Slice> escape) {
        int lengthOfCodePoint;
        if (escape.isEmpty()) {
            return pattern;
        }
        int escapeChar = LikeFunctions.getEscapeCharacter(escape).map(c -> c.charValue()).orElse(-1);
        DynamicSliceOutput output = new DynamicSliceOutput(pattern.length());
        boolean escaped = false;
        for (int position = 0; position < pattern.length(); position += lengthOfCodePoint) {
            int currentChar = SliceUtf8.getCodePointAt((Slice)pattern, (int)position);
            lengthOfCodePoint = SliceUtf8.lengthOfCodePoint((int)currentChar);
            if (!escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            output.writeBytes(pattern, position, lengthOfCodePoint);
            escaped = false;
        }
        LikeFunctions.checkEscape(!escaped);
        return output.slice();
    }

    private static Optional<Character> getEscapeCharacter(Optional<Slice> escape) {
        if (escape.isEmpty()) {
            return Optional.empty();
        }
        String escapeString = escape.get().toStringUtf8();
        if (escapeString.length() != 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character");
        }
        return Optional.of(Character.valueOf(escapeString.charAt(0)));
    }

    private static void checkEscape(boolean condition) {
        Failures.checkCondition(condition, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape character must be followed by '%%', '_' or the escape character itself", new Object[0]);
    }
}

