/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import java.util.List;

public final class SpatialJoinUtils {
    public static final String ST_CONTAINS = "st_contains";
    public static final String ST_WITHIN = "st_within";
    public static final String ST_INTERSECTS = "st_intersects";
    public static final String ST_DISTANCE = "st_distance";

    private SpatialJoinUtils() {
    }

    public static List<FunctionCall> extractSupportedSpatialFunctions(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).filter(SpatialJoinUtils::isSupportedSpatialFunction).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(FunctionCall functionCall) {
        String functionName = ResolvedFunction.extractFunctionName(functionCall.getName());
        return functionName.equalsIgnoreCase(ST_CONTAINS) || functionName.equalsIgnoreCase(ST_WITHIN) || functionName.equalsIgnoreCase(ST_INTERSECTS);
    }

    public static List<ComparisonExpression> extractSupportedSpatialComparisons(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(ComparisonExpression.class::isInstance).map(ComparisonExpression.class::cast).filter(SpatialJoinUtils::isSupportedSpatialComparison).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(ComparisonExpression expression) {
        switch (expression.getOperator()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getLeft());
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getRight());
            }
        }
        return false;
    }

    private static boolean isSTDistance(Expression expression) {
        if (expression instanceof FunctionCall) {
            return ResolvedFunction.extractFunctionName(((FunctionCall)expression).getName()).equalsIgnoreCase(ST_DISTANCE);
        }
        return false;
    }
}

