/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.SetColumnTypeTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SetColumnType;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSetColumnTypeTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testSetDataType() {
        QualifiedObjectName tableName = TestSetColumnTypeTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestSetColumnTypeTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("test", (Type)BigintType.BIGINT)));
        MoreFutures.getFutureValue(this.executeSetColumnType(TestSetColumnTypeTask.asQualifiedName(tableName), new Identifier("test"), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("test", (Type)IntegerType.INTEGER)));
        MoreFutures.getFutureValue(this.executeSetColumnType(TestSetColumnTypeTask.asQualifiedName(tableName), new Identifier("test"), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("test", (Type)IntegerType.INTEGER)));
    }

    @Test
    public void testSetDataTypeNotExistingTable() {
        QualifiedObjectName tableName = TestSetColumnTypeTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeSetColumnType(TestSetColumnTypeTask.asQualifiedName(tableName), new Identifier("test"), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testSetDataTypeNotExistingTableIfExists() {
        QualifiedName tableName = TestSetColumnTypeTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeSetColumnType(tableName, new Identifier("test"), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), true));
    }

    @Test
    public void testSetDataTypeNotExistingColumn() {
        QualifiedObjectName tableName = TestSetColumnTypeTask.qualifiedObjectName("existing_table");
        Identifier columnName = new Identifier("not_existing_column");
        this.metadata.createTable(this.testSession, "test-catalog", TestSetColumnTypeTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeSetColumnType(TestSetColumnTypeTask.asQualifiedName(tableName), columnName, TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column '%s' does not exist", new Object[]{columnName});
    }

    @Test
    public void testSetDataTypeOnView() {
        QualifiedObjectName viewName = TestSetColumnTypeTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestSetColumnTypeTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeSetColumnType(TestSetColumnTypeTask.asQualifiedName(viewName), new Identifier("test"), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist, but a view with that name exists.", new Object[]{viewName});
    }

    @Test
    public void testSetDataTypeOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestSetColumnTypeTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeSetColumnType(TestSetColumnTypeTask.asQualifiedName(materializedViewName), new Identifier("test"), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist, but a materialized view with that name exists.", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeSetColumnType(QualifiedName table, Identifier column, DataType type, boolean exists) {
        return new SetColumnTypeTask((Metadata)this.metadata, this.plannerContext.getTypeManager(), (AccessControl)new AllowAllAccessControl()).execute(new SetColumnType(new NodeLocation(1, 1), table, column, type, exists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

