/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.execution.buffer.BenchmarkDataGenerator;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchTables;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@OperationsPerInvocation(value=10000000)
public class BenchmarkBlockSerde {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)30, (int)5);
    public static final int ROWS = 10000000;

    @Benchmark
    public Object serializeLongDecimal(LongDecimalBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeLongDecimal(LongDecimalBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeFixed12(LongTimestampBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeInt96(LongTimestampBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeLong(BigintBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeLong(BigintBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeInteger(IntegerBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeInteger(IntegerBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeShort(SmallintBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeShort(SmallintBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeByte(TinyintBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeByte(TinyintBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeSliceDirect(VarcharDirectBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeSliceDirect(VarcharDirectBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeLineitem(LineitemBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeLineitem(LineitemBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    @Benchmark
    public Object serializeRow(RowTypeBenchmarkData data) {
        return BenchmarkBlockSerde.serializePages(data);
    }

    @Benchmark
    public Object deserializeRow(RowTypeBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)PagesSerdeUtil.readPages((PageDeserializer)data.getDeserializer(), (InputStream)new BasicSliceInput(data.getDataSource())));
    }

    private static List<Slice> serializePages(BenchmarkData data) {
        return (List)data.getPages().stream().map(page -> data.getSerializer().serialize(page)).collect(ImmutableList.toImmutableList());
    }

    @Test
    public void test() {
        LineitemBenchmarkData data = new LineitemBenchmarkData();
        data.setup();
        this.deserializeLineitem(data);
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkBlockSerde.class).run();
    }

    public static abstract class BenchmarkData {
        private Slice dataSource;
        private PageSerializer serializer;
        private PageDeserializer deserializer;
        private List<Page> pages;

        public void setup(Slice dataSource, PageSerializer serializer, PageDeserializer deserializer, List<Page> pages) {
            this.dataSource = dataSource;
            this.serializer = serializer;
            this.deserializer = deserializer;
            this.pages = pages;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public PageSerializer getSerializer() {
            return this.serializer;
        }

        public PageDeserializer getDeserializer() {
            return this.deserializer;
        }

        public Slice getDataSource() {
            return this.dataSource;
        }
    }

    @State(value=Scope.Thread)
    public static class LongDecimalBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)LONG_DECIMAL_TYPE, BenchmarkDataGenerator::randomLongDecimal);
        }
    }

    @State(value=Scope.Thread)
    public static class LongTimestampBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)TimestampType.TIMESTAMP_PICOS, BenchmarkDataGenerator::randomTimestamp);
        }
    }

    @State(value=Scope.Thread)
    public static class BigintBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)BigintType.BIGINT, Random::nextLong);
        }
    }

    @State(value=Scope.Thread)
    public static class IntegerBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)IntegerType.INTEGER, Random::nextInt);
        }
    }

    @State(value=Scope.Thread)
    public static class SmallintBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)SmallintType.SMALLINT, BenchmarkDataGenerator::randomShort);
        }
    }

    @State(value=Scope.Thread)
    public static class TinyintBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)TinyintType.TINYINT, BenchmarkDataGenerator::randomByte);
        }
    }

    @State(value=Scope.Thread)
    public static class VarcharDirectBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            super.setup((Type)VarcharType.VARCHAR, BenchmarkDataGenerator::randomAsciiString);
        }
    }

    @State(value=Scope.Thread)
    public static class LineitemBenchmarkData
    extends BenchmarkData {
        @Setup
        public void setup() {
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new TestingBlockEncodingSerde(), false);
            PageSerializer serializer = serdeFactory.createSerializer(Optional.empty());
            PageDeserializer deserializer = serdeFactory.createDeserializer(Optional.empty());
            ImmutableList pages = ImmutableList.copyOf((Iterator)TpchTables.getTablePages((String)"lineitem", (double)0.1, (DecimalTypeMapping)DecimalTypeMapping.DOUBLE));
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(0);
            PagesSerdeUtil.writePages((PageSerializer)serializer, (SliceOutput)new OutputStreamSliceOutput((OutputStream)sliceOutput), pages.listIterator());
            this.setup(sliceOutput.slice(), serializer, deserializer, (List<Page>)pages);
        }
    }

    @State(value=Scope.Thread)
    public static class RowTypeBenchmarkData
    extends TypeBenchmarkData {
        @Setup
        public void setup() {
            RowType type = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT));
            super.setup((Type)type, random -> BenchmarkDataGenerator.randomRow(type.getTypeParameters(), random));
        }
    }

    public static abstract class TypeBenchmarkData
    extends BenchmarkData {
        @Param(value={"0", ".01", ".10", ".50", ".90", ".99"})
        private double nullChance;

        public void setup(Type type, Function<Random, ?> valueGenerator) {
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new TestingBlockEncodingSerde(), false);
            PageSerializer serializer = serdeFactory.createSerializer(Optional.empty());
            PageDeserializer deserializer = serdeFactory.createDeserializer(Optional.empty());
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
            ImmutableList.Builder pagesBuilder = ImmutableList.builder();
            Iterator<?> values = BenchmarkDataGenerator.createValues(10000000, valueGenerator, this.nullChance);
            while (values.hasNext()) {
                this.writeValue(type, values.next(), blockBuilder);
                pageBuilder.declarePosition();
                if (!pageBuilder.isFull()) continue;
                pagesBuilder.add((Object)pageBuilder.build());
                pageBuilder.reset();
                blockBuilder = pageBuilder.getBlockBuilder(0);
            }
            if (pageBuilder.getPositionCount() > 0) {
                pagesBuilder.add((Object)pageBuilder.build());
            }
            ImmutableList pages = pagesBuilder.build();
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(0);
            PagesSerdeUtil.writePages((PageSerializer)serializer, (SliceOutput)new OutputStreamSliceOutput((OutputStream)sliceOutput), pages.iterator());
            this.setup(sliceOutput.slice(), serializer, deserializer, (List<Page>)pages);
        }

        private void writeValue(Type type, Object value, BlockBuilder blockBuilder) {
            DecimalType decimalType;
            if (value == null) {
                blockBuilder.appendNull();
            } else if (BigintType.BIGINT.equals((Object)type)) {
                BigintType.BIGINT.writeLong(blockBuilder, ((Number)value).longValue());
            } else if (type instanceof DecimalType && !(decimalType = (DecimalType)type).isShort()) {
                type.writeObject(blockBuilder, (Object)Int128.valueOf((BigInteger)((SqlDecimal)value).toBigDecimal().unscaledValue()));
            } else if (type instanceof VarcharType) {
                Slice slice = Varchars.truncateToLength((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
                type.writeSlice(blockBuilder, slice);
            } else if (TimestampType.TIMESTAMP_PICOS.equals((Object)type)) {
                TimestampType.TIMESTAMP_PICOS.writeObject(blockBuilder, value);
            } else if (IntegerType.INTEGER.equals((Object)type)) {
                IntegerType.INTEGER.writeInt(blockBuilder, ((Integer)value).intValue());
            } else if (SmallintType.SMALLINT.equals((Object)type)) {
                SmallintType.SMALLINT.writeShort(blockBuilder, ((Short)value).shortValue());
            } else if (TinyintType.TINYINT.equals((Object)type)) {
                TinyintType.TINYINT.writeByte(blockBuilder, ((Byte)value).byteValue());
            } else if (type instanceof RowType) {
                List values = (List)value;
                if (values.size() != type.getTypeParameters().size()) {
                    throw new IllegalArgumentException("Size of types and values must have the same size");
                }
                ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> {
                    int i;
                    ArrayList pairs = new ArrayList();
                    for (i = 0; i < type.getTypeParameters().size(); ++i) {
                        pairs.add(new AbstractMap.SimpleEntry((Type)type.getTypeParameters().get(i), ((List)value).get(i)));
                    }
                    for (i = 0; i < pairs.size(); ++i) {
                        AbstractMap.SimpleEntry p = (AbstractMap.SimpleEntry)pairs.get(i);
                        this.writeValue((Type)p.getKey(), p.getValue(), (BlockBuilder)fieldBuilders.get(i));
                    }
                });
            } else {
                throw new IllegalArgumentException("Unsupported type " + type);
            }
        }
    }
}

