/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.json.CachingResolver;
import io.trino.json.JsonEmptySequenceNode;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.PathEvaluationContext;
import io.trino.json.PathEvaluationError;
import io.trino.json.PathEvaluationVisitor;
import io.trino.json.PathPredicateEvaluationVisitor;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicate;
import io.trino.json.ir.TypedValue;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.PathNodes;
import io.trino.testing.TestingSession;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.testng.annotations.Test;

public class TestJsonPathEvaluator {
    private static final RecursiveComparisonConfiguration COMPARISON_CONFIGURATION = RecursiveComparisonConfiguration.builder().withStrictTypeChecking(true).build();
    private static final Map<String, Object> PARAMETERS = ImmutableMap.builder().put((Object)"tinyint_parameter", (Object)new TypedValue((Type)TinyintType.TINYINT, 1L)).put((Object)"bigint_parameter", (Object)new TypedValue((Type)BigintType.BIGINT, -2L)).put((Object)"short_decimal_parameter", (Object)new TypedValue((Type)DecimalType.createDecimalType((int)3, (int)1), -123L)).put((Object)"long_decimal_parameter", (Object)new TypedValue((Type)DecimalType.createDecimalType((int)30, (int)20), (Object)Int128.valueOf((String)"100000000000000000000"))).put((Object)"double_parameter", (Object)new TypedValue((Type)DoubleType.DOUBLE, 5.0)).put((Object)"string_parameter", (Object)new TypedValue((Type)CharType.createCharType((int)5), (Object)Slices.utf8Slice((String)"xyz"))).put((Object)"boolean_parameter", (Object)new TypedValue((Type)BooleanType.BOOLEAN, true)).put((Object)"date_parameter", (Object)new TypedValue((Type)DateType.DATE, 1234L)).put((Object)"timestamp_parameter", (Object)new TypedValue((Type)TimestampType.createTimestampType((int)7), (Object)new LongTimestamp(20L, 30))).put((Object)"empty_sequence_parameter", (Object)JsonEmptySequenceNode.EMPTY_SEQUENCE).put((Object)"null_parameter", (Object)NullNode.instance).put((Object)"json_number_parameter", (Object)IntNode.valueOf((int)-6)).put((Object)"json_text_parameter", (Object)TextNode.valueOf((String)"JSON text")).put((Object)"json_boolean_parameter", (Object)BooleanNode.FALSE).put((Object)"json_array_parameter", (Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"element"), (Object)DoubleNode.valueOf((double)7.0), (Object)NullNode.instance))).put((Object)"json_object_parameter", (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"bound_value"), (Object)"key2", (Object)NullNode.instance))).buildOrThrow();
    private static final List<String> PARAMETERS_ORDER = ImmutableList.copyOf(PARAMETERS.keySet());

    @Test
    public void testLiterals() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)NullNode.instance, PathNodes.path(true, PathNodes.literal((Type)BigintType.BIGINT, 1L))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)BigintType.BIGINT, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)NullNode.instance, PathNodes.path(true, PathNodes.literal((Type)VarcharType.createVarcharType((int)5), Slices.utf8Slice((String)"abc")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"abc"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)NullNode.instance, PathNodes.path(true, PathNodes.literal((Type)BooleanType.BOOLEAN, false))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)BooleanType.BOOLEAN, false)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)NullNode.instance, PathNodes.path(true, PathNodes.literal((Type)DateType.DATE, 1000L))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DateType.DATE, 1000L)));
    }

    @Test
    public void testNullLiteral() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, PathNodes.jsonNull())))).isEqualTo(PathNodes.singletonSequence(NullNode.instance));
    }

    @Test
    public void testContextVariable() {
        ArrayNode input = new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)BooleanNode.TRUE, (Object)BooleanNode.FALSE));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)input, PathNodes.path(true, PathNodes.contextVariable())))).isEqualTo(PathNodes.singletonSequence(input));
    }

    @Test
    public void testNamedVariable() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, TestJsonPathEvaluator.variable("tinyint_parameter"))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)TinyintType.TINYINT, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, TestJsonPathEvaluator.variable("null_parameter"))))).isEqualTo(PathNodes.singletonSequence(NullNode.instance));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, TestJsonPathEvaluator.variable("json_object_parameter")))).isInstanceOf(IllegalStateException.class)).hasMessage("expected SQL value or JSON null, got non-null JSON");
    }

    @Test
    public void testNamedJsonVariable() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isEqualTo(PathNodes.singletonSequence(NullNode.instance));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, TestJsonPathEvaluator.jsonVariable("json_object_parameter"))))).isEqualTo(PathNodes.singletonSequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"bound_value"), (Object)"key2", (Object)NullNode.instance))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ArrayNode(JsonNodeFactory.instance), PathNodes.path(true, TestJsonPathEvaluator.jsonVariable("tinyint_parameter")))).isInstanceOf(IllegalStateException.class)).hasMessage("expected JSON, got SQL value");
    }

    @Test
    public void testAbsMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.abs(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 5L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.abs(TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DecimalType.createDecimalType((int)3, (int)1), 123L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.abs(TestJsonPathEvaluator.jsonVariable("json_number_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 6L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)-1.0), (Object)IntNode.valueOf((int)2), (Object)ShortNode.valueOf((short)-3))), PathNodes.path(true, PathNodes.abs(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.0), new TypedValue((Type)IntegerType.INTEGER, 2L), new TypedValue((Type)SmallintType.SMALLINT, 3L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)-1.0), (Object)IntNode.valueOf((int)2), (Object)ShortNode.valueOf((short)-3))), PathNodes.path(true, PathNodes.abs(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.0), new TypedValue((Type)IntegerType.INTEGER, 2L), new TypedValue((Type)SmallintType.SMALLINT, 3L)));
        Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.abs(PathNodes.literal((Type)TinyintType.TINYINT, -128L))))).isInstanceOf(PathEvaluationError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.abs(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: NUMBER, actual: NULL");
    }

    @Test
    public void testArithmeticBinary() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.add(PathNodes.contextVariable(), TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DecimalType.createDecimalType((int)12, (int)1), -173L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.subtract(PathNodes.literal((Type)DoubleType.DOUBLE, 0.0), TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DoubleType.DOUBLE, 12.3)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.multiply(TestJsonPathEvaluator.jsonVariable("json_number_parameter"), PathNodes.literal((Type)BigintType.BIGINT, 3L)))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)BigintType.BIGINT, -18L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.subtract(TestJsonPathEvaluator.variable("short_decimal_parameter"), TestJsonPathEvaluator.variable("long_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DecimalType.createDecimalType((int)31, (int)20), (Object)Int128.valueOf((String)"-1330000000000000000000"))));
        Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.divide(TestJsonPathEvaluator.jsonVariable("json_number_parameter"), PathNodes.literal((Type)BigintType.BIGINT, 0L))))).isInstanceOf(PathEvaluationError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.modulus(TestJsonPathEvaluator.jsonVariable("json_number_parameter"), PathNodes.literal((Type)BooleanType.BOOLEAN, true))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid operand types to MODULUS operator (integer, boolean)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.add(PathNodes.wildcardArrayAccessor(TestJsonPathEvaluator.jsonVariable("json_array_parameter")), PathNodes.literal((Type)BigintType.BIGINT, 0L))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: arithmetic binary expression requires singleton operands");
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)-5))), PathNodes.path(true, PathNodes.multiply(PathNodes.contextVariable(), PathNodes.literal((Type)BigintType.BIGINT, 3L)))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)BigintType.BIGINT, -15L)));
    }

    @Test
    public void testArithmeticUnary() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.plus(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, -5L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.minus(TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DecimalType.createDecimalType((int)3, (int)1), 123L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.plus(TestJsonPathEvaluator.jsonVariable("json_number_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, -6L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)-1.0), (Object)IntNode.valueOf((int)2), (Object)ShortNode.valueOf((short)-3))), PathNodes.path(true, PathNodes.minus(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.0), new TypedValue((Type)IntegerType.INTEGER, -2L), new TypedValue((Type)SmallintType.SMALLINT, 3L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)-1.0), (Object)IntNode.valueOf((int)2), (Object)ShortNode.valueOf((short)-3))), PathNodes.path(true, PathNodes.minus(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.0), new TypedValue((Type)IntegerType.INTEGER, -2L), new TypedValue((Type)SmallintType.SMALLINT, 3L)));
        Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.minus(PathNodes.literal((Type)TinyintType.TINYINT, -128L))))).isInstanceOf(PathEvaluationError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.plus(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: NUMBER, actual: NULL");
    }

    @Test
    public void testArrayAccessor() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)-1.0), (Object)BooleanNode.TRUE, (Object)TextNode.valueOf((String)"some_text"))), PathNodes.path(true, PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(DoubleNode.valueOf((double)-1.0), BooleanNode.TRUE, TextNode.valueOf((String)"some_text")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.wildcardArrayAccessor(TestJsonPathEvaluator.jsonVariable("json_array_parameter")))))).isEqualTo(PathNodes.sequence(TextNode.valueOf((String)"element"), DoubleNode.valueOf((double)7.0), NullNode.instance));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.arrayAccessor(TestJsonPathEvaluator.jsonVariable("json_array_parameter"), PathNodes.at(PathNodes.literal((Type)DoubleType.DOUBLE, 0.0))))))).isEqualTo(PathNodes.singletonSequence(TextNode.valueOf((String)"element")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.arrayAccessor(TestJsonPathEvaluator.jsonVariable("json_array_parameter"), PathNodes.range(PathNodes.literal((Type)DoubleType.DOUBLE, 0.0), PathNodes.literal((Type)IntegerType.INTEGER, 1L))))))).isEqualTo(PathNodes.sequence(TextNode.valueOf((String)"element"), DoubleNode.valueOf((double)7.0)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(true, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 3L), PathNodes.literal((Type)IntegerType.INTEGER, 4L)), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 1L), PathNodes.literal((Type)IntegerType.INTEGER, 2L)), PathNodes.at(PathNodes.literal((Type)IntegerType.INTEGER, 0L))))))).isEqualTo(PathNodes.sequence(TextNode.valueOf((String)"fourth"), TextNode.valueOf((String)"fifth"), TextNode.valueOf((String)"second"), TextNode.valueOf((String)"third"), TextNode.valueOf((String)"first")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"))), (Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2), (Object)IntNode.valueOf((int)3))))), PathNodes.path(true, PathNodes.arrayAccessor(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 1L), PathNodes.literal((Type)IntegerType.INTEGER, 2L))))))).isEqualTo(PathNodes.sequence(TextNode.valueOf((String)"second"), TextNode.valueOf((String)"third"), IntNode.valueOf((int)2), IntNode.valueOf((int)3)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.arrayAccessor(TestJsonPathEvaluator.jsonVariable("json_array_parameter"), PathNodes.range(PathNodes.literal((Type)DoubleType.DOUBLE, 1.0), PathNodes.last())))))).isEqualTo(PathNodes.sequence(DoubleNode.valueOf((double)7.0), NullNode.instance));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.last()))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: accessing the last array index with no enclosing array");
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)2), (Object)IntNode.valueOf((int)3), (Object)IntNode.valueOf((int)5))), (Object)IntNode.valueOf((int)7))), PathNodes.path(true, PathNodes.multiply(PathNodes.arrayAccessor(PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)IntegerType.INTEGER, 0L))), PathNodes.at(PathNodes.last())), PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.last()))))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 35L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(true, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)IntegerType.INTEGER, 100L))))))).isEqualTo(PathNodes.emptySequence());
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(true, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 3L), PathNodes.literal((Type)IntegerType.INTEGER, 100L))))))).isEqualTo(PathNodes.sequence(TextNode.valueOf((String)"fourth"), TextNode.valueOf((String)"fifth")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(true, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 3L), PathNodes.literal((Type)IntegerType.INTEGER, 2L))))))).isEqualTo(PathNodes.emptySequence());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(false, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)IntegerType.INTEGER, 100L)))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: structural error: invalid array subscript: [100, 100] for array of size 5");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(false, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 3L), PathNodes.literal((Type)IntegerType.INTEGER, 100L)))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: structural error: invalid array subscript: [3, 100] for array of size 5");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"first"), (Object)TextNode.valueOf((String)"second"), (Object)TextNode.valueOf((String)"third"), (Object)TextNode.valueOf((String)"fourth"), (Object)TextNode.valueOf((String)"fifth"))), PathNodes.path(false, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.range(PathNodes.literal((Type)IntegerType.INTEGER, 3L), PathNodes.literal((Type)IntegerType.INTEGER, 2L)))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: structural error: invalid array subscript: [3, 2] for array of size 5");
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)IntegerType.INTEGER, 0L))))))).isEqualTo(PathNodes.singletonSequence(IntNode.valueOf((int)-5)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(false, PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)IntegerType.INTEGER, 0L)))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: ARRAY, actual: NUMBER");
    }

    @Test
    public void testCeilingMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.ceiling(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, -5L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.ceiling(TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DecimalType.createDecimalType((int)3, (int)0), -12L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.ceiling(TestJsonPathEvaluator.jsonVariable("json_number_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, -6L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)DecimalNode.valueOf((BigDecimal)BigDecimal.valueOf(-15L, 1)))), PathNodes.path(true, PathNodes.ceiling(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 2.0), new TypedValue((Type)IntegerType.INTEGER, 2L), new TypedValue((Type)DecimalType.createDecimalType((int)2, (int)0), -1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)DecimalNode.valueOf((BigDecimal)BigDecimal.valueOf(-15L, 1)))), PathNodes.path(true, PathNodes.ceiling(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 2.0), new TypedValue((Type)IntegerType.INTEGER, 2L), new TypedValue((Type)DecimalType.createDecimalType((int)2, (int)0), -1L)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.ceiling(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: NUMBER, actual: NULL");
    }

    @Test
    public void testDescendantMemberAccessor() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)BooleanNode.TRUE, PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "key1"))))).isEqualTo(PathNodes.emptySequence());
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)BooleanNode.TRUE, (Object)TextNode.valueOf((String)"foo"))), PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "key1"))))).isEqualTo(PathNodes.emptySequence());
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"first", (Object)BooleanNode.TRUE, (Object)"second", (Object)IntNode.valueOf((int)42))), PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "second"))))).isEqualTo(PathNodes.singletonSequence(IntNode.valueOf((int)42)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"first", (Object)BooleanNode.TRUE, (Object)"second", (Object)IntNode.valueOf((int)42))), PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "third"))))).isEqualTo(PathNodes.emptySequence());
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)BooleanNode.TRUE, (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)IntNode.valueOf((int)42), (Object)"key2", (Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)NullNode.instance, (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key3", (Object)TextNode.valueOf((String)"foo"), (Object)"key1", (Object)BooleanNode.FALSE)))))))), PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "key1"))))).isEqualTo(PathNodes.sequence(IntNode.valueOf((int)42), BooleanNode.FALSE));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key2", (Object)BooleanNode.FALSE)), (Object)"key2", (Object)IntNode.valueOf((int)42))), PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "key2"))))).isEqualTo(PathNodes.sequence(IntNode.valueOf((int)42), BooleanNode.FALSE));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)BooleanNode.FALSE)), (Object)"key2", (Object)IntNode.valueOf((int)42))), PathNodes.path(true, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "key1"))))).isEqualTo(PathNodes.sequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)BooleanNode.FALSE)), BooleanNode.FALSE));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)BooleanNode.TRUE, PathNodes.path(false, PathNodes.descendantMemberAccessor(PathNodes.contextVariable(), "key1"))))).isEqualTo(PathNodes.emptySequence());
    }

    @Test
    public void testDoubleMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.toDouble(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DoubleType.DOUBLE, -5.0)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.toDouble(TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DoubleType.DOUBLE, -12.3)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.toDouble(TestJsonPathEvaluator.jsonVariable("json_number_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DoubleType.DOUBLE, -6.0)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)TextNode.valueOf((String)"123"), PathNodes.path(true, PathNodes.toDouble(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DoubleType.DOUBLE, 123.0)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)TextNode.valueOf((String)"-12.3e5"), PathNodes.path(true, PathNodes.toDouble(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DoubleType.DOUBLE, -1230000.0)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)DecimalNode.valueOf((BigDecimal)BigDecimal.valueOf(-15L, 1)))), PathNodes.path(true, PathNodes.toDouble(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.5), new TypedValue((Type)DoubleType.DOUBLE, 2.0), new TypedValue((Type)DoubleType.DOUBLE, -1.5)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)DecimalNode.valueOf((BigDecimal)BigDecimal.valueOf(-15L, 1)))), PathNodes.path(true, PathNodes.toDouble(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.5), new TypedValue((Type)DoubleType.DOUBLE, 2.0), new TypedValue((Type)DoubleType.DOUBLE, -1.5)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.toDouble(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: NUMBER or TEXT, actual: NULL");
    }

    @Test
    public void testFloorMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.floor(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, -5L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.floor(TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)DecimalType.createDecimalType((int)3, (int)0), -13L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.floor(TestJsonPathEvaluator.jsonVariable("json_number_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, -6L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)DecimalNode.valueOf((BigDecimal)BigDecimal.valueOf(-15L, 1)))), PathNodes.path(true, PathNodes.floor(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.0), new TypedValue((Type)IntegerType.INTEGER, 2L), new TypedValue((Type)DecimalType.createDecimalType((int)2, (int)0), -2L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)DecimalNode.valueOf((BigDecimal)BigDecimal.valueOf(-15L, 1)))), PathNodes.path(true, PathNodes.floor(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)DoubleType.DOUBLE, 1.0), new TypedValue((Type)IntegerType.INTEGER, 2L), new TypedValue((Type)DecimalType.createDecimalType((int)2, (int)0), -2L)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.floor(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: NUMBER, actual: NULL");
    }

    @Test
    public void testKeyValueMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"bound_value"), (Object)"key2", (Object)NullNode.instance)), PathNodes.path(true, PathNodes.keyValue(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key1"), (Object)"value", (Object)TextNode.valueOf((String)"bound_value"), (Object)"id", (Object)IntNode.valueOf((int)0))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key2"), (Object)"value", (Object)NullNode.instance, (Object)"id", (Object)IntNode.valueOf((int)0)))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.keyValue(TestJsonPathEvaluator.jsonVariable("json_object_parameter")))))).isEqualTo(PathNodes.sequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key1"), (Object)"value", (Object)TextNode.valueOf((String)"bound_value"), (Object)"id", (Object)IntNode.valueOf((int)0))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key2"), (Object)"value", (Object)NullNode.instance, (Object)"id", (Object)IntNode.valueOf((int)0)))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key3", (Object)IntNode.valueOf((int)1), (Object)"key4", (Object)NullNode.instance)))), PathNodes.path(true, PathNodes.keyValue(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key1"), (Object)"value", (Object)TextNode.valueOf((String)"first"), (Object)"id", (Object)IntNode.valueOf((int)0))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key2"), (Object)"value", (Object)BooleanNode.TRUE, (Object)"id", (Object)IntNode.valueOf((int)0))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key3"), (Object)"value", (Object)IntNode.valueOf((int)1), (Object)"id", (Object)IntNode.valueOf((int)1))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key4"), (Object)"value", (Object)NullNode.instance, (Object)"id", (Object)IntNode.valueOf((int)1)))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key3", (Object)IntNode.valueOf((int)1), (Object)"key4", (Object)NullNode.instance)))), PathNodes.path(true, PathNodes.keyValue(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key1"), (Object)"value", (Object)TextNode.valueOf((String)"first"), (Object)"id", (Object)IntNode.valueOf((int)0))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key2"), (Object)"value", (Object)BooleanNode.TRUE, (Object)"id", (Object)IntNode.valueOf((int)0))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key3"), (Object)"value", (Object)IntNode.valueOf((int)1), (Object)"id", (Object)IntNode.valueOf((int)1))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"key4"), (Object)"value", (Object)NullNode.instance, (Object)"id", (Object)IntNode.valueOf((int)1)))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key3", (Object)IntNode.valueOf((int)42))))), PathNodes.path(true, PathNodes.keyValue(PathNodes.keyValue(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()))))))).isEqualTo(PathNodes.sequence(new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"name"), (Object)"value", (Object)TextNode.valueOf((String)"key1"), (Object)"id", (Object)IntNode.valueOf((int)2))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"value"), (Object)"value", (Object)TextNode.valueOf((String)"first"), (Object)"id", (Object)IntNode.valueOf((int)2))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"id"), (Object)"value", (Object)IntNode.valueOf((int)0), (Object)"id", (Object)IntNode.valueOf((int)2))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"name"), (Object)"value", (Object)TextNode.valueOf((String)"key2"), (Object)"id", (Object)IntNode.valueOf((int)3))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"value"), (Object)"value", (Object)BooleanNode.TRUE, (Object)"id", (Object)IntNode.valueOf((int)3))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"id"), (Object)"value", (Object)IntNode.valueOf((int)0), (Object)"id", (Object)IntNode.valueOf((int)3))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"name"), (Object)"value", (Object)TextNode.valueOf((String)"key3"), (Object)"id", (Object)IntNode.valueOf((int)4))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"value"), (Object)"value", (Object)IntNode.valueOf((int)42), (Object)"id", (Object)IntNode.valueOf((int)4))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)"id"), (Object)"value", (Object)IntNode.valueOf((int)1), (Object)"id", (Object)IntNode.valueOf((int)4)))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.keyValue(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: OBJECT, actual: NULL");
    }

    @Test
    public void testMemberAccessor() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"bound_value"), (Object)"key2", (Object)NullNode.instance)), PathNodes.path(true, PathNodes.wildcardMemberAccessor(PathNodes.contextVariable()))))).isEqualTo(PathNodes.sequence(TextNode.valueOf((String)"bound_value"), NullNode.instance));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.memberAccessor(TestJsonPathEvaluator.jsonVariable("json_object_parameter"), "key1"))))).isEqualTo(PathNodes.singletonSequence(TextNode.valueOf((String)"bound_value")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)IntNode.valueOf((int)1), (Object)"key2", (Object)NullNode.instance)))), PathNodes.path(true, PathNodes.memberAccessor(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()), "key2"))))).isEqualTo(PathNodes.sequence(BooleanNode.TRUE, NullNode.instance));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)IntNode.valueOf((int)1), (Object)"key2", (Object)NullNode.instance)))), PathNodes.path(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "key2"))))).isEqualTo(PathNodes.sequence(BooleanNode.TRUE, NullNode.instance));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"bound_value"), (Object)"key2", (Object)NullNode.instance)), PathNodes.path(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "wrong_key"))))).isEqualTo(PathNodes.emptySequence());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"bound_value"), (Object)"key2", (Object)NullNode.instance)), PathNodes.path(false, PathNodes.memberAccessor(PathNodes.contextVariable(), "wrong_key")))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: structural error: missing member 'wrong_key' in JSON object");
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key3", (Object)IntNode.valueOf((int)1), (Object)"key4", (Object)NullNode.instance)))), PathNodes.path(true, PathNodes.memberAccessor(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()), "key2"))))).isEqualTo(PathNodes.singletonSequence(BooleanNode.TRUE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)TextNode.valueOf((String)"first"), (Object)"key2", (Object)BooleanNode.TRUE)), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key3", (Object)IntNode.valueOf((int)1), (Object)"key4", (Object)NullNode.instance)))), PathNodes.path(false, PathNodes.memberAccessor(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()), "key2")))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: structural error: missing member 'key2' in JSON object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.keyValue(TestJsonPathEvaluator.jsonVariable("null_parameter"))))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: OBJECT, actual: NULL");
    }

    @Test
    public void testSizeMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.size(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.size(TestJsonPathEvaluator.variable("short_decimal_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.size(TestJsonPathEvaluator.jsonVariable("json_boolean_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)NullNode.instance, PathNodes.path(true, PathNodes.size(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.size(TestJsonPathEvaluator.jsonVariable("json_object_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 1L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.size(TestJsonPathEvaluator.jsonVariable("json_array_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)IntegerType.INTEGER, 3L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)BooleanNode.TRUE, (Object)BooleanNode.FALSE)))), PathNodes.path(true, PathNodes.size(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)IntegerType.INTEGER, 1L), new TypedValue((Type)IntegerType.INTEGER, 2L)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(false, PathNodes.size(PathNodes.contextVariable())))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: invalid item type. Expected: ARRAY, actual: NUMBER");
    }

    @Test
    public void testTypeMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"number"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(TestJsonPathEvaluator.variable("string_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"string"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(TestJsonPathEvaluator.jsonVariable("json_boolean_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"boolean"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(TestJsonPathEvaluator.jsonVariable("json_array_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"array"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(TestJsonPathEvaluator.jsonVariable("json_object_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"object"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)NullNode.instance, PathNodes.path(true, PathNodes.type(PathNodes.contextVariable()))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"null"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(TestJsonPathEvaluator.variable("date_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"date"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.type(TestJsonPathEvaluator.variable("timestamp_parameter")))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"timestamp without time zone"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)BooleanNode.TRUE, (Object)BooleanNode.FALSE)))), PathNodes.path(true, PathNodes.type(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable())))))).isEqualTo(PathNodes.sequence(new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"number")), new TypedValue((Type)VarcharType.createVarcharType((int)27), (Object)Slices.utf8Slice((String)"array"))));
    }

    @Test
    public void testComparisonPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.equal(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.notEqual(TestJsonPathEvaluator.jsonVariable("json_number_parameter"), TestJsonPathEvaluator.variable("double_parameter"))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.lessThan(PathNodes.literal((Type)BooleanType.BOOLEAN, true), PathNodes.literal((Type)BooleanType.BOOLEAN, false))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.greaterThan(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"xyz")), PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"abc")))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.lessThanOrEqual(PathNodes.literal((Type)DateType.DATE, 0L), TestJsonPathEvaluator.variable("date_parameter"))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.greaterThanOrEqual(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 2L))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), false, PathNodes.lessThan(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.equal(PathNodes.jsonNull(), PathNodes.jsonNull())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.lessThan(PathNodes.jsonNull(), PathNodes.currentItem())))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.notEqual(PathNodes.jsonNull(), TestJsonPathEvaluator.jsonVariable("json_object_parameter"))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.notEqual(TestJsonPathEvaluator.jsonVariable("json_object_parameter"), TestJsonPathEvaluator.jsonVariable("json_object_parameter"))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.notEqual(TestJsonPathEvaluator.jsonVariable("json_array_parameter"), TestJsonPathEvaluator.jsonVariable("json_object_parameter"))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1))), LongNode.valueOf((long)1L), true, PathNodes.equal(PathNodes.contextVariable(), PathNodes.literal((Type)BigintType.BIGINT, 1L))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1))), LongNode.valueOf((long)1L), false, PathNodes.equal(PathNodes.contextVariable(), PathNodes.literal((Type)BigintType.BIGINT, 1L))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2))), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)BooleanNode.TRUE)), true, PathNodes.lessThan(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)BooleanNode.TRUE, (Object)IntNode.valueOf((int)2))), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)IntNode.valueOf((int)1))), true, PathNodes.lessThan(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)NullNode.instance)), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)NullNode.instance)), true, PathNodes.equal(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)NullNode.instance)), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)BooleanNode.TRUE)), true, PathNodes.notEqual(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2))), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)BooleanNode.TRUE)), false, PathNodes.lessThan(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.lessThan(PathNodes.contextVariable(), PathNodes.floor(PathNodes.currentItem()))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2))), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)IntNode.valueOf((int)4))), true, PathNodes.lessThan(PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)BigintType.BIGINT, 100L))), PathNodes.currentItem())))).isEqualTo((Object)false);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2))), new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)IntNode.valueOf((int)3), (Object)IntNode.valueOf((int)4))), true, PathNodes.lessThan(PathNodes.contextVariable(), PathNodes.arrayAccessor(PathNodes.currentItem(), PathNodes.at(PathNodes.literal((Type)BigintType.BIGINT, 100L))))))).isEqualTo((Object)false);
    }

    @Test
    public void testConjunctionPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.conjunction(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 1L)), PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 2L), PathNodes.literal((Type)BigintType.BIGINT, 2L)))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.conjunction(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 1L)), PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 2L), PathNodes.literal((Type)BooleanType.BOOLEAN, false)))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.conjunction(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BooleanType.BOOLEAN, false)), PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 2L), PathNodes.literal((Type)BigintType.BIGINT, 3L)))))).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testDisjunctionPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.disjunction(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 2L)), PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 2L), PathNodes.literal((Type)BigintType.BIGINT, 2L)))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.disjunction(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 2L)), PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BooleanType.BOOLEAN, false)))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.disjunction(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 2L)), PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 2L), PathNodes.literal((Type)BigintType.BIGINT, 3L)))))).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testExistsPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.exists(PathNodes.contextVariable())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.exists(PathNodes.memberAccessor(TestJsonPathEvaluator.jsonVariable("json_object_parameter"), "wrong_key"))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), false, PathNodes.exists(PathNodes.memberAccessor(TestJsonPathEvaluator.jsonVariable("json_object_parameter"), "wrong_key"))))).isEqualTo(null);
    }

    @Test
    public void testIsUnknownPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.isUnknown(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 1L)))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.isUnknown(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 2L)))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), LongNode.valueOf((long)1L), true, PathNodes.isUnknown(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BooleanType.BOOLEAN, true)))))).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testNegationPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.negation(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 1L)))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.negation(PathNodes.notEqual(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BigintType.BIGINT, 1L)))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)DoubleNode.valueOf((double)1.0), TextNode.valueOf((String)"abc"), true, PathNodes.negation(PathNodes.equal(PathNodes.literal((Type)BigintType.BIGINT, 1L), PathNodes.literal((Type)BooleanType.BOOLEAN, false)))))).isEqualTo(null);
    }

    @Test
    public void testStartsWithPredicate() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)TextNode.valueOf((String)"abcde"), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.contextVariable(), PathNodes.currentItem())))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)TextNode.valueOf((String)"abcde"), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(TestJsonPathEvaluator.jsonVariable("json_text_parameter"), PathNodes.literal((Type)CharType.createCharType((int)4), Slices.utf8Slice((String)"JSON")))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)TextNode.valueOf((String)"abcde"), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"XYZ")), TestJsonPathEvaluator.variable("string_parameter"))))).isEqualTo((Object)Boolean.FALSE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"aBC"), (Object)TextNode.valueOf((String)"abc"), (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()), PathNodes.literal((Type)VarcharType.createVarcharType((int)1), Slices.utf8Slice((String)"A")))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"aBC"), (Object)TextNode.valueOf((String)"abc"), (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.contextVariable(), PathNodes.literal((Type)VarcharType.createVarcharType((int)1), Slices.utf8Slice((String)"A")))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"Abc"), (Object)NullNode.instance)), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.contextVariable(), PathNodes.literal((Type)VarcharType.createVarcharType((int)1), Slices.utf8Slice((String)"A")))))).isEqualTo((Object)Boolean.TRUE);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"Abc"), (Object)NullNode.instance)), TextNode.valueOf((String)"abc"), false, PathNodes.startsWith(PathNodes.contextVariable(), PathNodes.literal((Type)VarcharType.createVarcharType((int)1), Slices.utf8Slice((String)"A")))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)NullNode.instance, (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.contextVariable(), PathNodes.literal((Type)VarcharType.createVarcharType((int)1), Slices.utf8Slice((String)"A")))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)NullNode.instance, (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.floor(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"x"))), PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"A")))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)NullNode.instance, (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"x")), PathNodes.floor(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"A"))))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)TextNode.valueOf((String)"A"), (Object)TextNode.valueOf((String)"B"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"x")), PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)NullNode.instance, (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"x")), PathNodes.literal((Type)BigintType.BIGINT, 1L))))).isEqualTo(null);
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.predicateResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)NullNode.instance, (Object)TextNode.valueOf((String)"Abc"))), TextNode.valueOf((String)"abc"), true, PathNodes.startsWith(PathNodes.arrayAccessor(PathNodes.contextVariable(), PathNodes.at(PathNodes.literal((Type)BigintType.BIGINT, 100L))), PathNodes.literal((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"A")))))).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testFilter() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.filter(PathNodes.literal((Type)BigintType.BIGINT, 5L), PathNodes.greaterThan(PathNodes.currentItem(), PathNodes.literal((Type)BigintType.BIGINT, 3L))))))).isEqualTo(PathNodes.singletonSequence(new TypedValue((Type)BigintType.BIGINT, 5L)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.filter(PathNodes.literal((Type)BigintType.BIGINT, 5L), PathNodes.lessThan(PathNodes.currentItem(), PathNodes.literal((Type)BigintType.BIGINT, 3L))))))).isEqualTo(PathNodes.emptySequence());
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.filter(PathNodes.literal((Type)BigintType.BIGINT, 5L), PathNodes.lessThan(PathNodes.currentItem(), PathNodes.literal((Type)BooleanType.BOOLEAN, true))))))).isEqualTo(PathNodes.emptySequence());
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)LongNode.valueOf((long)5L), (Object)ShortNode.valueOf((short)10))), PathNodes.path(true, PathNodes.filter(PathNodes.wildcardArrayAccessor(PathNodes.contextVariable()), PathNodes.greaterThan(PathNodes.currentItem(), PathNodes.literal((Type)BigintType.BIGINT, 3L))))))).isEqualTo(PathNodes.sequence(LongNode.valueOf((long)5L), ShortNode.valueOf((short)10)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestJsonPathEvaluator.pathResult((JsonNode)new ArrayNode(JsonNodeFactory.instance, (List)ImmutableList.of((Object)DoubleNode.valueOf((double)1.5), (Object)IntNode.valueOf((int)2), (Object)LongNode.valueOf((long)5L), (Object)ShortNode.valueOf((short)10))), PathNodes.path(true, PathNodes.filter(PathNodes.contextVariable(), PathNodes.greaterThan(PathNodes.currentItem(), PathNodes.literal((Type)BigintType.BIGINT, 3L))))))).isEqualTo(PathNodes.sequence(LongNode.valueOf((long)5L), ShortNode.valueOf((short)10)));
    }

    @Test
    public void testCurrentItemVariable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestJsonPathEvaluator.evaluate((JsonNode)IntNode.valueOf((int)-5), PathNodes.path(true, PathNodes.currentItem()))).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: accessing current filter item with no enclosing filter");
    }

    private static IrPathNode variable(String name) {
        return PathNodes.variable(PARAMETERS_ORDER.indexOf(name));
    }

    private static IrPathNode jsonVariable(String name) {
        return PathNodes.jsonVariable(PARAMETERS_ORDER.indexOf(name));
    }

    private static AssertProvider<? extends RecursiveComparisonAssert<?>> pathResult(JsonNode input, IrJsonPath path) {
        return () -> new RecursiveComparisonAssert(TestJsonPathEvaluator.evaluate(input, path), COMPARISON_CONFIGURATION);
    }

    private static List<Object> evaluate(JsonNode input, IrJsonPath path) {
        return (List)TestJsonPathEvaluator.createPathVisitor(input, path.isLax()).process(path.getRoot(), (Object)new PathEvaluationContext());
    }

    private static AssertProvider<? extends RecursiveComparisonAssert<?>> predicateResult(JsonNode input, Object currentItem, boolean lax, IrPredicate predicate) {
        return () -> new RecursiveComparisonAssert((Object)TestJsonPathEvaluator.evaluatePredicate(input, currentItem, lax, predicate), COMPARISON_CONFIGURATION);
    }

    private static Boolean evaluatePredicate(JsonNode input, Object currentItem, boolean lax, IrPredicate predicate) {
        return (Boolean)TestJsonPathEvaluator.createPredicateVisitor(input, lax).process((IrPathNode)predicate, (Object)new PathEvaluationContext().withCurrentItem(currentItem));
    }

    private static PathEvaluationVisitor createPathVisitor(JsonNode input, boolean lax) {
        return new PathEvaluationVisitor(lax, input, PARAMETERS.values().toArray(), new JsonPathEvaluator.Invoker(TestingSession.testSessionBuilder().build().toConnectorSession(), FunctionManager.createTestingFunctionManager()), new CachingResolver((Metadata)MetadataManager.createTestMetadataManager(), TestingSession.testSessionBuilder().build().toConnectorSession(), (TypeManager)new TestingTypeManager()));
    }

    private static PathPredicateEvaluationVisitor createPredicateVisitor(JsonNode input, boolean lax) {
        return new PathPredicateEvaluationVisitor(lax, TestJsonPathEvaluator.createPathVisitor(input, lax), new JsonPathEvaluator.Invoker(TestingSession.testSessionBuilder().build().toConnectorSession(), FunctionManager.createTestingFunctionManager()), new CachingResolver((Metadata)MetadataManager.createTestMetadataManager(), TestingSession.testSessionBuilder().build().toConnectorSession(), (TypeManager)new TestingTypeManager()));
    }
}

