/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.trino.SequencePageBuilder;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.FunctionManager;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.PageAssertions;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestColumnarPageProcessor {
    private static final int POSITIONS = 100;
    private final List<Type> types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
    private final FunctionManager functionManager = FunctionManager.createTestingFunctionManager();

    @Test
    public void testProcess() {
        PageProcessor processor = this.newPageProcessor();
        Page page = TestColumnarPageProcessor.createPage(this.types, false);
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        PageAssertions.assertPageEquals(this.types, outputPage, page);
    }

    @Test
    public void testProcessWithDictionary() {
        PageProcessor processor = this.newPageProcessor();
        Page page = TestColumnarPageProcessor.createPage(this.types, true);
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        PageAssertions.assertPageEquals(this.types, outputPage, page);
    }

    private static Page createPage(List<? extends Type> types, boolean dictionary) {
        return dictionary ? SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, 100) : SequencePageBuilder.createSequencePage(types, 100);
    }

    private PageProcessor newPageProcessor() {
        return (PageProcessor)new ExpressionCompiler(this.functionManager, new PageFunctionCompiler(this.functionManager, 0)).compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)this.types.get(0)), (Object)Expressions.field((int)1, (Type)this.types.get(1))), 8192).get();
    }
}

