/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowReferencePageManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowReferencePageManager {
    @Test
    public void testEmptyPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 0L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assert.assertFalse((boolean)cursor.advance());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RowReferencePageManager.LoadCursor)cursor).allocateRowId()).isInstanceOf(IllegalStateException.class)).hasMessage("Not yet advanced");
        }
        Assert.assertEquals((long)pageManager.getPageBytes(), (long)0L);
    }

    @Test
    public void testSinglePageRowIds() {
        long id3;
        long id1;
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        RowIdComparisonStrategy strategy = (rowId1, rowId2) -> {
            long value1 = TestRowReferencePageManager.extractValue(pageManager, rowId1);
            long value2 = TestRowReferencePageManager.extractValue(pageManager, rowId2);
            return Long.compare(value1, value2);
        };
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 4L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assert.assertTrue((boolean)cursor.advance());
            id0 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
            Assert.assertTrue((boolean)cursor.advance());
            Assert.assertTrue((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0);
            id1 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id1), (long)1L);
            Assert.assertTrue((boolean)cursor.advance());
            Assert.assertTrue((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((cursor.compareTo(strategy, id1) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)cursor.advance());
            Assert.assertTrue((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((cursor.compareTo(strategy, id1) > 0 ? 1 : 0) != 0);
            id3 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id3), (long)3L);
            Assert.assertEquals((long)pageManager.getPageBytes(), (long)0L);
        }
        Assert.assertTrue((pageManager.getPageBytes() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id1), (long)1L);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id3), (long)3L);
    }

    @Test
    public void testMultiplePageRowIds() {
        long id1;
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        RowIdComparisonStrategy strategy = (rowId1, rowId2) -> {
            long value1 = TestRowReferencePageManager.extractValue(pageManager, rowId1);
            long value2 = TestRowReferencePageManager.extractValue(pageManager, rowId2);
            return Long.compare(value1, value2);
        };
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 1L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assert.assertTrue((boolean)cursor.advance());
            id0 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
            Assert.assertFalse((boolean)cursor.advance());
            Assert.assertEquals((long)pageManager.getPageBytes(), (long)0L);
        }
        long pageBytes1 = pageManager.getPageBytes();
        Assert.assertTrue((pageBytes1 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
        page = TestRowReferencePageManager.createBigIntSingleBlockPage(1L, 2L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assert.assertTrue((boolean)cursor.advance());
            Assert.assertTrue((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0);
            id1 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id1), (long)1L);
            Assert.assertFalse((boolean)cursor.advance());
            Assert.assertEquals((long)pageManager.getPageBytes(), (long)pageBytes1);
        }
        Assert.assertTrue((pageManager.getPageBytes() > pageBytes1 ? 1 : 0) != 0);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id1), (long)1L);
    }

    @Test
    public void testSkipCompaction() {
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assert.assertTrue((boolean)cursor.advance());
            id0 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
            Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        }
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
        long pageBytesBeforeCompaction = pageManager.getPageBytes();
        Assert.assertTrue((pageBytesBeforeCompaction > 0L ? 1 : 0) != 0);
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)1);
        pageManager.compactIfNeeded();
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        Assert.assertTrue((pageManager.getPageBytes() < pageBytesBeforeCompaction ? 1 : 0) != 0);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
    }

    @Test
    public void testDereferenceCompaction() {
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        ArrayList<Long> rowIdsToDereference = new ArrayList<Long>();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (Object cursor = pageManager.add(page);){
            Assert.assertTrue((boolean)cursor.advance());
            id0 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
            while (cursor.advance()) {
                rowIdsToDereference.add(cursor.allocateRowId());
            }
        }
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        cursor = rowIdsToDereference.iterator();
        while (cursor.hasNext()) {
            long rowId = (Long)cursor.next();
            pageManager.dereference(rowId);
        }
        long pageBytesBeforeCompaction = pageManager.getPageBytes();
        Assert.assertTrue((pageBytesBeforeCompaction > 0L ? 1 : 0) != 0);
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)1);
        pageManager.compactIfNeeded();
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        Assert.assertTrue((pageManager.getPageBytes() < pageBytesBeforeCompaction ? 1 : 0) != 0);
        Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
    }

    @Test
    public void testSkipFullPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        RowReferencePageManager.LoadCursor cursor = pageManager.add(page);
        if (cursor != null) {
            cursor.close();
        }
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        Assert.assertEquals((long)pageManager.getPageBytes(), (long)0L);
    }

    @Test
    public void testDereferenceFullPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        ArrayList<Long> rowIdsToDereference = new ArrayList<Long>();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            while (cursor.advance()) {
                rowIdsToDereference.add(cursor.allocateRowId());
            }
        }
        Iterator iterator = rowIdsToDereference.iterator();
        while (iterator.hasNext()) {
            long rowId = (Long)iterator.next();
            pageManager.dereference(rowId);
        }
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        Assert.assertEquals((long)pageManager.getPageBytes(), (long)0L);
    }

    @Test
    public void testInlineDereferenceFullPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            while (cursor.advance()) {
                pageManager.dereference(cursor.allocateRowId());
            }
        }
        Assert.assertEquals((int)pageManager.getCompactionCandidateCount(), (int)0);
        Assert.assertEquals((long)pageManager.getPageBytes(), (long)0L);
    }

    @Test
    public void testRowIdRecycling() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 3L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assert.assertTrue((boolean)cursor.advance());
            long id0 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id0), (long)0L);
            Assert.assertTrue((boolean)cursor.advance());
            long id1 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id1), (long)1L);
            pageManager.dereference(id0);
            Assert.assertTrue((boolean)cursor.advance());
            long id2 = cursor.allocateRowId();
            Assert.assertEquals((long)TestRowReferencePageManager.extractValue(pageManager, id2), (long)2L);
            Assert.assertEquals((long)id0, (long)id2);
        }
    }

    private static long extractValue(RowReferencePageManager pageManager, long rowId) {
        Page page = pageManager.getPage(rowId);
        int position = pageManager.getPosition(rowId);
        return BigintType.BIGINT.getLong(page.getBlock(0), position);
    }

    private static Page createBigIntSingleBlockPage(long startInclusive, long endExclusive) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, Math.toIntExact(endExclusive - startInclusive));
        for (long i = startInclusive; i < endExclusive; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, i);
        }
        Block block = blockBuilder.build();
        return new Page(new Block[]{block});
    }
}

