/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorStats;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorSourceOperator;
import io.trino.operator.WorkProcessorSourceOperatorAdapter;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.spi.Page;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWorkProcessorSourceOperatorAdapter {
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testMetrics() {
        DriverContext driverContext = TestingTaskContext.builder((Executor)MoreExecutors.directExecutor(), (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).build().addPipelineContext(0, true, true, false).addDriverContext();
        TestWorkProcessorOperatorFactory workProcessorFactory = new TestWorkProcessorOperatorFactory();
        OperatorContext context = driverContext.addOperatorContext(workProcessorFactory.getOperatorId(), workProcessorFactory.getPlanNodeId(), workProcessorFactory.getOperatorType());
        WorkProcessorSourceOperatorAdapter operator = new WorkProcessorSourceOperatorAdapter(context, (WorkProcessorSourceOperatorAdapter.AdapterWorkProcessorSourceOperatorFactory)workProcessorFactory);
        operator.getOutput();
        Assertions.assertThat((boolean)operator.isFinished()).isFalse();
        ((MapAssert)Assertions.assertThat((Map)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getMetrics().getMetrics()).hasSize(5)).containsEntry((Object)"testOperatorMetric", (Object)new LongCount(1L));
        Assertions.assertThat((Map)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getConnectorMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"testConnectorMetric", (Object)new LongCount(2L)));
        Assertions.assertThat((Comparable)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getPhysicalInputReadTime()).isEqualTo((Object)new Duration(7.0, TimeUnit.NANOSECONDS));
        operator.getOutput();
        Assertions.assertThat((boolean)operator.isFinished()).isTrue();
        ((MapAssert)Assertions.assertThat((Map)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getMetrics().getMetrics()).hasSize(5)).containsEntry((Object)"testOperatorMetric", (Object)new LongCount(2L));
        Assertions.assertThat((Map)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getConnectorMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"testConnectorMetric", (Object)new LongCount(3L)));
        Assertions.assertThat((Comparable)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getPhysicalInputReadTime()).isEqualTo((Object)new Duration(7.0, TimeUnit.NANOSECONDS));
    }

    private static class TestWorkProcessorOperatorFactory
    implements WorkProcessorSourceOperatorAdapter.AdapterWorkProcessorSourceOperatorFactory {
        private TestWorkProcessorOperatorFactory() {
        }

        public WorkProcessorSourceOperator create(OperatorContext operatorContext, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits) {
            return new TestWorkProcessorOperator();
        }

        public int getOperatorId() {
            return 0;
        }

        public PlanNodeId getSourceId() {
            return new PlanNodeId("test");
        }

        public PlanNodeId getPlanNodeId() {
            return new PlanNodeId("test");
        }

        public String getOperatorType() {
            return "test";
        }
    }

    private static class TestWorkProcessorOperator
    implements WorkProcessorSourceOperator {
        private long count;

        private TestWorkProcessorOperator() {
        }

        public Metrics getMetrics() {
            return new Metrics((Map)ImmutableMap.of((Object)"testOperatorMetric", (Object)new LongCount(this.count)));
        }

        public Metrics getConnectorMetrics() {
            return new Metrics((Map)ImmutableMap.of((Object)"testConnectorMetric", (Object)new LongCount(this.count + 1L)));
        }

        public Duration getReadTime() {
            return new Duration(7.0, TimeUnit.NANOSECONDS);
        }

        public WorkProcessor<Page> getOutputPages() {
            return WorkProcessor.of((Object[])new Page[]{new Page(0)}).withProcessEntryMonitor(() -> ++this.count);
        }
    }
}

