/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import io.trino.operator.aggregation.minmaxbyn.TypedKeyValueHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedKeyValueHeap {
    private static final int INPUT_SIZE = 1000000;
    private static final int OUTPUT_SIZE = 1000;
    private static final TypeOperators TYPE_OPERATOR_FACTORY = new TypeOperators();
    private static final MethodHandle MAX_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonUnorderedFirstOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
    private static final MethodHandle MIN_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonUnorderedLastOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));

    @Test
    public void testAscending() {
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000), IntStream.range(0, 1000000).mapToObj(key -> Integer.toString(key * 2)), false, MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).mapToObj(key -> Integer.toString(key * 2)).iterator());
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000), IntStream.range(0, 1000000).mapToObj(key -> Integer.toString(key * 2)), true, MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).mapToObj(key -> Integer.toString(key * 2)).iterator());
    }

    @Test
    public void testDescending() {
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), IntStream.range(0, 1000000).map(x -> 999999 - x).mapToObj(key -> Integer.toString(key * 2)), false, MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).mapToObj(key -> Integer.toString(key * 2)).iterator());
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), IntStream.range(0, 1000000).map(x -> 999999 - x).mapToObj(key -> Integer.toString(key * 2)), true, MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).mapToObj(key -> Integer.toString(key * 2)).iterator());
    }

    @Test
    public void testShuffled() {
        List list = IntStream.range(0, 1000000).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.shuffle(list);
        TestTypedKeyValueHeap.test(list.stream().mapToInt(Integer::intValue), list.stream().mapToInt(Integer::intValue).mapToObj(key -> Integer.toString(key * 2)), false, MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).mapToObj(key -> Integer.toString(key * 2)).iterator());
        TestTypedKeyValueHeap.test(list.stream().mapToInt(Integer::intValue), list.stream().mapToInt(Integer::intValue).mapToObj(key -> Integer.toString(key * 2)), true, MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).mapToObj(key -> Integer.toString(key * 2)).iterator());
    }

    private static void test(IntStream keyInputStream, Stream<String> valueInputStream, boolean min, MethodHandle comparisonMethod, Iterator<String> outputIterator) {
        BlockBuilder keysBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000000);
        VariableWidthBlockBuilder valuesBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1000000);
        keyInputStream.forEach(x -> BigintType.BIGINT.writeLong(keysBlockBuilder, (long)x));
        valueInputStream.forEach(arg_0 -> TestTypedKeyValueHeap.lambda$test$20((BlockBuilder)valuesBlockBuilder, arg_0));
        TypedKeyValueHeap heap = new TypedKeyValueHeap(min, comparisonMethod, (Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, 1000);
        heap.addAll((Block)keysBlockBuilder, (Block)valuesBlockBuilder);
        VariableWidthBlockBuilder resultBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1000);
        heap.popAll((BlockBuilder)resultBlockBuilder);
        Block resultBlock = resultBlockBuilder.build();
        Assert.assertEquals((int)resultBlock.getPositionCount(), (int)1000);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((String)VarcharType.VARCHAR.getSlice(resultBlock, i).toStringUtf8(), (String)outputIterator.next());
        }
    }

    private static /* synthetic */ void lambda$test$20(BlockBuilder valuesBlockBuilder, String x) {
        VarcharType.VARCHAR.writeString(valuesBlockBuilder, x);
    }
}

