/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.stream.LongStream;
import org.testng.annotations.Test;

public class TestArrayMaxNAggregation
extends AbstractTestAggregationFunction {
    public static Block createLongArraysBlock(Long[] values) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, values.length);
        for (Long value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(elementBuilder -> BigintType.BIGINT.writeLong(elementBuilder, value.longValue()));
        }
        return blockBuilder.build();
    }

    public static Block createLongArraySequenceBlock(int start, int length) {
        return TestArrayMaxNAggregation.createLongArraysBlock((Long[])LongStream.range(start, length).boxed().toArray(Long[]::new));
    }

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{TestArrayMaxNAggregation.createLongArraySequenceBlock(start, start + length), BlockAssertions.createLongRepeatBlock(2, length)};
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BigintType.BIGINT);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return ImmutableList.of((Object)ImmutableList.of((Object)start));
        }
        return ImmutableList.of((Object)ImmutableList.of((Object)((long)start + (long)length - 1L)), (Object)ImmutableList.of((Object)((long)start + (long)length - 2L)));
    }

    @Test
    public void testMoreCornerCases() {
        this.testCustomAggregation(new Long[]{1L, 2L, null, 3L}, 5);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 0);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, -1);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 10001);
    }

    private void testInvalidAggregation(Long[] x, int n) {
        this.assertInvalidAggregation(() -> this.testAggregation(null, TestArrayMaxNAggregation.createLongArraysBlock(x), BlockAssertions.createLongRepeatBlock(n, x.length)));
    }

    private void testCustomAggregation(Long[] values, int n) {
        PriorityQueue heap = new PriorityQueue(n);
        Arrays.stream(values).filter(Objects::nonNull).forEach(heap::add);
        ImmutableList.Builder expected = ImmutableList.builder();
        for (int i = heap.size() - 1; i >= 0; --i) {
            expected.add((Object)ImmutableList.of((Object)((Long)heap.remove())));
        }
        this.testAggregation(Lists.reverse((List)expected.build()), TestArrayMaxNAggregation.createLongArraysBlock(values), BlockAssertions.createLongRepeatBlock(n, values.length));
    }
}

