/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import io.trino.operator.join.JoinOperatorInfo;
import io.trino.operator.join.LookupJoinOperatorFactory;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJoinOperatorInfo {
    @Test
    public void testMerge() {
        JoinOperatorInfo base = new JoinOperatorInfo(LookupJoinOperatorFactory.JoinType.INNER, this.makeHistogramArray(10L, 20L, 30L, 40L, 50L, 60L, 70L, 80L), this.makeHistogramArray(12L, 22L, 32L, 42L, 52L, 62L, 72L, 82L), Optional.of(1L), 2L, 3L);
        JoinOperatorInfo other = new JoinOperatorInfo(LookupJoinOperatorFactory.JoinType.INNER, this.makeHistogramArray(11L, 21L, 31L, 41L, 51L, 61L, 71L, 81L), this.makeHistogramArray(15L, 25L, 35L, 45L, 55L, 65L, 75L, 85L), Optional.of(2L), 4L, 7L);
        JoinOperatorInfo merged = base.mergeWith(other);
        Assert.assertEquals((Object)this.makeHistogramArray(21L, 41L, 61L, 81L, 101L, 121L, 141L, 161L), (Object)merged.getLogHistogramProbes());
        Assert.assertEquals((Object)this.makeHistogramArray(27L, 47L, 67L, 87L, 107L, 127L, 147L, 167L), (Object)merged.getLogHistogramOutput());
        Assert.assertEquals((Object)merged.getLookupSourcePositions(), Optional.of(3L));
        Assert.assertEquals((long)merged.getRleProbes(), (long)6L);
        Assert.assertEquals((long)merged.getTotalProbes(), (long)10L);
    }

    private long[] makeHistogramArray(long ... longArray) {
        Preconditions.checkArgument((longArray.length == 8 ? 1 : 0) != 0);
        return longArray;
    }
}

