/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testArrayConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array[" + Joiner.on((String)", ").join(Collections.nCopies(254, "rand()")) + "]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array[a, b, c]").binding("a", "1").binding("b", "2").binding("c", "3")))).matches("ARRAY[1, 2, 3]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression("array[" + Joiner.on((String)", ").join(Collections.nCopies(255, "rand()")) + "]").evaluate()).isInstanceOf(TrinoException.class)).hasMessage("Too many arguments for array constructor");
    }

    @Test
    public void testArrayConcat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(127, "array[1]")) + ")")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).matches("ARRAY[%s]".formatted(Joiner.on((String)",").join(Collections.nCopies(127, 1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[1]", "ARRAY[2]", "ARRAY[3]")))).matches("ARRAY[1, 2, 3]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(128, "array[1]")) + ")").evaluate()).isInstanceOf(TrinoException.class)).hasMessage("line 1:12: Too many arguments for function call concat()");
    }
}

