/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.UnknownType;
import java.util.Arrays;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayNgramsFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "1")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar"), (Object)ImmutableList.of((Object)"foo"), (Object)ImmutableList.of((Object)"baz"), (Object)ImmutableList.of((Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo"), (Object)ImmutableList.of((Object)"foo", (Object)"baz"), (Object)ImmutableList.of((Object)"baz", (Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "3")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz"), (Object)ImmutableList.of((Object)"foo", (Object)"baz", (Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "4")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "5")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "6")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['bar', 'foo', 'baz', 'foo']", "100000000")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['a', 'bb', 'ccc', 'dddd']", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"bb"), (Object)ImmutableList.of((Object)"bb", (Object)"ccc"), (Object)ImmutableList.of((Object)"ccc", (Object)"dddd")));
    }

    @Test
    public void testNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['foo', NULL, 'bar']", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of(Arrays.asList("foo", null), Arrays.asList(null, "bar")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY [NULL, NULL, NULL]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN))).isEqualTo(ImmutableList.of(Arrays.asList(null, null), Arrays.asList(null, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY [NULL, 3, NULL]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of(Arrays.asList(null, 3), Arrays.asList(3, null)));
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY[1, 2, 3]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)2, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY[1.1E0, 2.1E0, 3.1E0]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1.1, (Object)2.1), (Object)ImmutableList.of((Object)2.1, (Object)3.1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY[true, false, true]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)true, (Object)false), (Object)ImmutableList.of((Object)false, (Object)true)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY[ARRAY['A1', 'A2'], ARRAY['B1'], ARRAY['C1', 'C2']]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)2))))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)"A1", (Object)"A2"), (Object)ImmutableList.of((Object)"B1")), (Object)ImmutableList.of((Object)ImmutableList.of((Object)"B1"), (Object)ImmutableList.of((Object)"C1", (Object)"C2"))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['\u4fe1\u5ff5\u7231', '\u5e0c\u671b', '\u671b']", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"\u4fe1\u5ff5\u7231", (Object)"\u5e0c\u671b"), (Object)ImmutableList.of((Object)"\u5e0c\u671b", (Object)"\u671b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY[]", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN))).isEqualTo(ImmutableList.of(Arrays.asList(new Object[0])));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['']", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ngrams", "ARRAY['', '']", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"", (Object)"")));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("ngrams", "ARRAY['foo','bar']", "0").evaluate()).hasMessage("N must be positive");
    }
}

