/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Arrays;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayReduceFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)").binding("a", "ARRAY []")))).isEqualTo(0L);
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)").binding("a", "ARRAY [5, 20, 50]")))).isEqualTo(75L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)").binding("a", "ARRAY [5 + RANDOM(1), 20, 50]")))).isEqualTo(75L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, 0.0E0, (s, x) -> s + x, s -> s)").binding("a", "ARRAY [5, 6, 10, 20]")))).isEqualTo(41.0);
    }

    @Test
    public void testNulls() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)").binding("a", "ARRAY [NULL]")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> coalesce(x, 1) + s, s -> s)").binding("a", "ARRAY [NULL, NULL, NULL]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)").binding("a", "ARRAY [5, NULL, 50]")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (0 AS BIGINT), (s, x) -> coalesce(x, 0) + s, s -> s)").binding("a", "ARRAY [5, NULL, 50]")))).isEqualTo(55L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)").binding("a", "ARRAY []")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)").binding("a", "ARRAY [NULL]")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)").binding("a", "ARRAY [NULL, NULL, NULL]")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)").binding("a", "ARRAY [NULL, 6, 10, NULL, 8]")))).isEqualTo(10L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)").binding("a", "ARRAY [5, NULL, 6, 10, NULL, 8]")))).isEqualTo(10L);
    }

    @Test
    public void testTwoValueState() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(\n    a,\n    CAST(ROW(0, 0) AS ROW(sum BIGINT, count INTEGER)),\n    (s, x) -> CAST(ROW(x + s[1], s[2] + 1) AS ROW(sum BIGINT, count INTEGER)),\n    s -> s[1] / s[2])\n").binding("a", "ARRAY [5, 20, 50]")))).isEqualTo(25L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(\n        a,\n        CAST(ROW(0.0E0, 0) AS ROW(sum DOUBLE, count INTEGER)),\n        (s, x) -> CAST(ROW(x + s[1], s[2] + 1) AS ROW(sum DOUBLE, count INTEGER)),\n        s -> s[1] / s[2])\n").binding("a", "ARRAY [5, 6, 10, 20]")))).isEqualTo(10.25);
    }

    @Test
    public void testInstanceFunction() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, CAST(ARRAY[] AS ARRAY(INTEGER)), (s, x) -> concat(s, x), s -> s)").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[5, NULL, 7]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(1, 2, 3, 4, 5, null, 7));
    }

    @Test
    public void testCoercion() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("reduce(a, 0, (s, x) -> s + coalesce(x, 0), s -> s)").binding("a", "ARRAY [123456789012345, NULL, 54321]")))).isEqualTo(123456789066666L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("reduce(ARRAY [1, NULL, 2], 0, (s, x) -> CAST (s + x AS TINYINT), s -> s)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
    }
}

