/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.interval;

import io.trino.sql.query.QueryAssertions;
import io.trino.type.SqlIntervalYearMonth;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIntervalYearMonth {
    protected QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '124-30' YEAR TO MONTH")))).isEqualTo(TestIntervalYearMonth.interval(124, 30));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '124' YEAR TO MONTH")))).isEqualTo(TestIntervalYearMonth.interval(124, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '30' MONTH")))).isEqualTo(TestIntervalYearMonth.interval(0, 30));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32767' YEAR")))).isEqualTo(TestIntervalYearMonth.interval(Short.MAX_VALUE, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32767' MONTH")))).isEqualTo(TestIntervalYearMonth.interval(0, Short.MAX_VALUE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32767-32767' YEAR TO MONTH")))).isEqualTo(TestIntervalYearMonth.interval(Short.MAX_VALUE, Short.MAX_VALUE));
        Assertions.assertThatThrownBy(() -> this.assertions.expression("INTERVAL '124X' YEAR").evaluate()).hasMessage("line 1:12: '124X' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("INTERVAL '124-30' YEAR").evaluate()).hasMessage("line 1:12: '124-30' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("INTERVAL '124-X' YEAR TO MONTH").evaluate()).hasMessage("line 1:12: '124-X' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("INTERVAL '124--30' YEAR TO MONTH").evaluate()).hasMessage("line 1:12: '124--30' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("INTERVAL '--124--30' YEAR TO MONTH").evaluate()).hasMessage("line 1:12: '--124--30' is not a valid INTERVAL literal");
    }

    private static SqlIntervalYearMonth interval(int year, int month) {
        return new SqlIntervalYearMonth(year, month);
    }
}

