/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import com.google.common.collect.ImmutableList;
import io.trino.operator.scalar.AbstractTestExtract;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.query.QueryAssertions;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestExtract
extends AbstractTestExtract {
    @Override
    protected List<String> types() {
        return (List)IntStream.rangeClosed(0, 12).mapToObj(precision -> String.format("timestamp(%s) with time zone", precision)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void testYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2020'");
    }

    @Override
    public void testMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '5'");
    }

    @Override
    public void testWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '19'");
    }

    @Override
    public void testDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '10'");
    }

    @Override
    public void testDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '10'");
    }

    @Override
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '12'");
    }

    @Override
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '34'");
    }

    @Override
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '56'");
    }

    @Test
    public void testMillisecond() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression("EXTRACT(MILLISECOND FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')").evaluate()).isInstanceOf(ParsingException.class)).hasMessage("line 1:12: Invalid EXTRACT field: MILLISECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '123'");
    }

    @Override
    public void testTimezoneHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567891 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678912 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789123 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1234 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12345 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123456 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1234567 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12345678 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123456789 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1234567891 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12345678912 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123456789123 +08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567891 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678912 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789123 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1234 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12345 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123456 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1234567 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12345678 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123456789 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.1234567891 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.12345678912 -08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-10 12:34:56.123456789123 -08:35')")))).matches("BIGINT '-8'");
    }

    @Override
    public void testTimezoneMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567891 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678912 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789123 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234567 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345678 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456789 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234567891 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345678912 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456789123 +08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567891 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678912 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789123 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234567 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345678 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456789 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234567891 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345678912 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456789123 -08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567891 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678912 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789123 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234567 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345678 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456789 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.1234567891 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.12345678912 -00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-10 12:34:56.123456789123 -00:35')")))).matches("BIGINT '-35'");
    }

    @Override
    public void testDayOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '7'");
    }

    @Override
    public void testDow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '7'");
    }

    @Override
    public void testDayOfYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '131'");
    }

    @Override
    public void testDoy() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '131'");
    }

    @Override
    public void testQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2'");
    }

    @Test
    public void testWeekOfYear() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression("EXTRACT(WEEK_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')").evaluate()).isInstanceOf(ParsingException.class)).hasMessage("line 1:12: Invalid EXTRACT field: WEEK_OF_YEAR");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '19'");
    }

    @Override
    public void testYearOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2020'");
    }

    @Override
    public void testYow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("BIGINT '2020'");
    }
}

