/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.TaskContext;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=8, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=8, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkUnnestOperator {
    private static final int TOTAL_POSITIONS = 10000;

    @Benchmark
    public List<Page> unnest(BenchmarkContext context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void testBlocks() {
        Block block = BenchmarkContext.produceBlock((Type)new ArrayType((Type)VarcharType.VARCHAR), 100, 0.1f, 50);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
        block = BenchmarkContext.produceBlock((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), 100, 0.1f, 50);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
        block = BenchmarkContext.produceBlock((Type)RowType.anonymous(Arrays.asList(VarcharType.VARCHAR, VarcharType.VARCHAR)), 100, 0.1f, 50);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
        block = BenchmarkContext.produceBlock((Type)new ArrayType((Type)RowType.anonymous(Arrays.asList(VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR))), 100, 0.1f, 50);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkUnnestOperator.class).withOptions(optionsBuilder -> optionsBuilder.addProfiler(GCProfiler.class)).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkContext {
        @Param(value={"varchar"})
        private String replicateType = "bigint";
        @Param(value={"array(varchar)", "map(varchar,varchar)", "array(row(varchar,varchar,varchar))", "array(array(varchar))", "array(varchar)|array(varchar)"})
        private String nestedType = "array(varchar)";
        @Param(value={"0.0", "0.05"})
        private float nullsRatio;
        @Param(value={"1000"})
        private int positionsPerPage = 1000;
        @Param(value={"300"})
        private int nestedLengths = 300;
        @Param(value={"true"})
        private boolean withOrdinality;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            ImmutableList.Builder replicatedTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder unnestTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder replicatedChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder unnestChannelsBuilder = ImmutableList.builder();
            String[] replicatedTypes = this.replicateType.split("\\|");
            for (int i = 0; i < replicatedTypes.length; ++i) {
                Type replicateType = BenchmarkContext.getType(replicatedTypes[i]);
                typesBuilder.add((Object)replicateType);
                replicatedTypesBuilder.add((Object)replicateType);
                replicatedChannelsBuilder.add((Object)i);
            }
            String[] unnestTypes = this.nestedType.split("\\|");
            for (int i = 0; i < unnestTypes.length; ++i) {
                Type unnestType = BenchmarkContext.getType(unnestTypes[i]);
                typesBuilder.add((Object)unnestType);
                unnestTypesBuilder.add((Object)unnestType);
                unnestChannelsBuilder.add((Object)(i + replicatedTypes.length));
            }
            this.pages = BenchmarkContext.createInputPages(this.positionsPerPage, (List<Type>)typesBuilder.build(), this.nullsRatio, this.nestedLengths);
            this.operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)replicatedChannelsBuilder.build(), (List)replicatedTypesBuilder.build(), (List)unnestChannelsBuilder.build(), (List)unnestTypesBuilder.build(), this.withOrdinality, false);
        }

        public static Type getType(String typeString) {
            return InternalTypeManager.TESTING_TYPE_MANAGER.fromSqlType(typeString);
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        static List<Page> createInputPages(int positionsPerPage, List<Type> types, float nullsRatio, int maxNestedCardinality) {
            ImmutableList.Builder pages = ImmutableList.builder();
            int pageCount = 10000 / positionsPerPage;
            for (int i = 0; i < pageCount; ++i) {
                Block[] blocks = new Block[types.size()];
                blocks[0] = BenchmarkContext.produceBlock(types.get(0), positionsPerPage, 0.0f, maxNestedCardinality);
                for (int nestedColumn = 1; nestedColumn < blocks.length; ++nestedColumn) {
                    blocks[nestedColumn] = BenchmarkContext.produceBlock(types.get(nestedColumn), positionsPerPage, nullsRatio, maxNestedCardinality);
                }
                pages.add((Object)new Page(blocks));
            }
            return pages.build();
        }

        static Block produceBlock(Type type, int positionsCount, float nullsRatio, int maxNestedCardinality) {
            if (type instanceof ArrayType || type instanceof MapType) {
                return BlockAssertions.createRandomBlockForNestedType(type, positionsCount, nullsRatio, maxNestedCardinality);
            }
            return BlockAssertions.createRandomBlockForType(type, positionsCount, nullsRatio);
        }
    }
}

