/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

final class FilterMatcher
implements Matcher {
    private final Expression predicate;
    private final Optional<Expression> dynamicFilter;

    FilterMatcher(Expression predicate, Optional<Expression> dynamicFilter) {
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof FilterNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        FilterNode filterNode = (FilterNode)node;
        Expression filterPredicate = filterNode.getPredicate();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        if (this.dynamicFilter.isPresent()) {
            return new MatchResult((Boolean)verifier.process((Node)filterPredicate, ExpressionUtils.combineConjuncts((Metadata)metadata, (Expression[])new Expression[]{this.predicate, this.dynamicFilter.get()})));
        }
        DynamicFilters.ExtractResult extractResult = DynamicFilters.extractDynamicFilters((Expression)filterPredicate);
        return new MatchResult((Boolean)verifier.process((Node)ExpressionUtils.combineConjuncts((Metadata)metadata, (Collection)extractResult.getStaticConjuncts()), this.predicate));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("predicate", (Object)this.predicate).toString();
    }
}

