/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.testing.LocalQueryRunner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestUnaliasSymbolReferences
extends BasePlanTest {
    @Test
    public void testDynamicFilterIdUnAliased() {
        String probeTable = "supplier";
        String buildTable = "nation";
        this.assertOptimizedPlan((PlanOptimizer)new UnaliasSymbolReferences(this.getQueryRunner().getMetadata()), (p, session, metadata) -> {
            TpchColumnHandle column = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
            Symbol buildColumnSymbol = p.symbol("nationkey");
            Symbol buildAlias1 = p.symbol("buildAlias1");
            Symbol buildAlias2 = p.symbol("buildAlias2");
            Symbol probeColumn1 = p.symbol("s_nationkey");
            Symbol probeColumn2 = p.symbol("s_suppkey");
            DynamicFilterId dynamicFilterId1 = new DynamicFilterId("df1");
            DynamicFilterId dynamicFilterId2 = new DynamicFilterId("df2");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.filter(ExpressionUtils.and((Expression[])new Expression[]{this.dynamicFilterExpression(metadata, session, probeColumn1, dynamicFilterId1), this.dynamicFilterExpression(metadata, session, probeColumn2, dynamicFilterId2)}), (PlanNode)p.tableScan(this.tableHandle(probeTable), (List<Symbol>)ImmutableList.of((Object)probeColumn1, (Object)probeColumn2), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)probeColumn1, (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT), (Object)probeColumn2, (Object)new TpchColumnHandle("suppkey", (Type)BigintType.BIGINT))))), (PlanNode)p.project(Assignments.of((Symbol)buildAlias1, (Expression)buildColumnSymbol.toSymbolReference(), (Symbol)buildAlias2, (Expression)buildColumnSymbol.toSymbolReference()), (PlanNode)p.tableScan(this.tableHandle(buildTable), (List<Symbol>)ImmutableList.of((Object)buildColumnSymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)buildColumnSymbol, (Object)column))), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)buildAlias1, (Object)buildAlias2), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)dynamicFilterId1, (Object)buildAlias1, (Object)dynamicFilterId2, (Object)buildAlias2));
        }, PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.dynamicFilter((Map<String, String>)ImmutableMap.of((Object)"probeColumn1", (Object)"column", (Object)"probeColumn2", (Object)"column")).left(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan(probeTable, (Map<String, String>)ImmutableMap.of((Object)"probeColumn1", (Object)"suppkey", (Object)"probeColumn2", (Object)"nationkey"))))).right(PlanMatchPattern.project(PlanMatchPattern.tableScan(buildTable, (Map<String, String>)ImmutableMap.of((Object)"column", (Object)"nationkey"))))));
    }

    private void assertOptimizedPlan(PlanOptimizer optimizer, PlanCreator planCreator, PlanMatchPattern pattern) {
        LocalQueryRunner queryRunner = this.getQueryRunner();
        queryRunner.inTransaction(session -> {
            Metadata metadata = queryRunner.getMetadata();
            session.getCatalog().ifPresent(catalog -> metadata.getCatalogHandle(session, catalog));
            PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
            PlanBuilder planBuilder = new PlanBuilder(idAllocator, metadata, (Session)session);
            SymbolAllocator symbolAllocator = new SymbolAllocator();
            PlanNode plan = planCreator.create(planBuilder, (Session)session, metadata);
            PlanNode optimized = optimizer.optimize(plan, session, planBuilder.getTypes(), symbolAllocator, idAllocator, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), (TableStatsProvider)new CachingTableStatsProvider(metadata, session));
            Plan actual = new Plan(optimized, planBuilder.getTypes(), StatsAndCosts.empty());
            PlanAssert.assertPlan(session, queryRunner.getMetadata(), queryRunner.getFunctionManager(), queryRunner.getStatsCalculator(), actual, pattern);
            return null;
        });
    }

    private Expression dynamicFilterExpression(Metadata metadata, Session session, Symbol symbol, DynamicFilterId id) {
        return DynamicFilters.createDynamicFilterExpression((Session)session, (Metadata)metadata, (DynamicFilterId)id, (Type)BigintType.BIGINT, (Expression)symbol.toSymbolReference());
    }

    private TableHandle tableHandle(String tableName) {
        return this.getQueryRunner().getTableHandle("test-catalog", "tiny", tableName);
    }

    static interface PlanCreator {
        public PlanNode create(PlanBuilder var1, Session var2, Metadata var3);
    }
}

