/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCheckConstraint {
    private static final String LOCAL_CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String USER = "user";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(Identity.forUser((String)"user").build()).build();
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        LocalQueryRunner runner = LocalQueryRunner.builder((Session)SESSION).build();
        runner.createCatalog(LOCAL_CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        MockConnectorFactory mock = MockConnectorFactory.builder().withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_multiple_column_constraint"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_invalid_function"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_boolean_expression"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_subquery"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_date"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_time"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_timestamp"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtime"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtimestamp"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_deterministic"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            throw new UnsupportedOperationException();
        }).withCheckConstraints(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return ImmutableList.of((Object)"regionkey < 10");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_multiple_column_constraint"))) {
                return ImmutableList.of((Object)"nationkey > 100 AND regionkey > 50");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_invalid_function"))) {
                return ImmutableList.of((Object)"invalid_function(nationkey) > 100");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_boolean_expression"))) {
                return ImmutableList.of((Object)"1 + 1");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_subquery"))) {
                return ImmutableList.of((Object)"nationkey > (SELECT count(*) FROM nation)");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_date"))) {
                return ImmutableList.of((Object)"CURRENT_DATE > DATE '2022-12-31'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_time"))) {
                return ImmutableList.of((Object)"CURRENT_TIME > TIME '12:34:56.123+00:00'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_timestamp"))) {
                return ImmutableList.of((Object)"CURRENT_TIMESTAMP > TIMESTAMP '2022-12-31 23:59:59'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtime"))) {
                return ImmutableList.of((Object)"LOCALTIME > TIME '12:34:56.123'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtimestamp"))) {
                return ImmutableList.of((Object)"LOCALTIMESTAMP > TIMESTAMP '2022-12-31 23:59:59'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_deterministic"))) {
                return ImmutableList.of((Object)"nationkey > random()");
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_multiple_column_constraint"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).build();
        runner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mock, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testInsert() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES (101, 'POLAND', 0, 'No comment')")))).matches("SELECT BIGINT '1'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation VALUES (26, 'POLAND', 11, 'No comment')")).hasMessage("Check constraint violation: (regionkey < 10)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation VALUES\n(26, 'POLAND', 11, 'No comment'),\n(27, 'HOLLAND', 11, 'A comment')\n")).hasMessage("Check constraint violation: (regionkey < 10)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation VALUES\n(26, 'POLAND', 11, 'No comment'),\n(27, 'HOLLAND', 11, 'A comment')\n")).hasMessage("Check constraint violation: (regionkey < 10)");
    }

    @Test
    public void testMergeInsert() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (26, 'POLAND', 0, 'No comment')\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES (26, 'POLAND', 0, 'No comment'), (27, 'HOLLAND', 0, 'A comment')) t(a,b,c,d) ON nationkey = a\nWHEN NOT MATCHED THEN INSERT VALUES (a,b,c,d)\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (NULL)\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (0)\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
    }

    @Test
    public void testInsertAllowUnknown() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation(nationkey) VALUES (null)")))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation(regionkey) VALUES (0)")))).matches("SELECT BIGINT '1'");
    }

    @Test
    public void testInsertCheckMultipleColumns() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_multiple_column_constraint VALUES (101, 'POLAND', 51, 'No comment')")))).matches("SELECT BIGINT '1'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_multiple_column_constraint VALUES (101, 'POLAND', 50, 'No comment')")).hasMessage("Check constraint violation: ((nationkey > 100) AND (regionkey > 50))");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_multiple_column_constraint VALUES (100, 'POLAND', 51, 'No comment')")).hasMessage("Check constraint violation: ((nationkey > 100) AND (regionkey > 50))");
    }

    @Test
    public void testInsertSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_subquery VALUES (26, 'POLAND', 51, 'No comment')")))).matches("SELECT BIGINT '1'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_subquery VALUES (10, 'POLAND', 0, 'No comment')")).hasMessage("Check constraint violation: (nationkey > (SELECT count(*)\nFROM\n  nation\n))");
    }

    @Test
    public void testInsertUnsupportedCurrentDate() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_current_date VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedCurrentTime() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_current_time VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedCurrentTimestamp() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_current_timestamp VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedLocaltime() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_localtime VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedLocaltimestamp() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_localtimestamp VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedConstraint() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_invalid_function VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("Function 'invalid_function' not registered");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_not_boolean_expression VALUES (101, 'POLAND', 0, 'No comment')")).hasMessageContaining("to be of type BOOLEAN, but was integer");
    }

    @Test
    public void testInsertNotDeterministic() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_not_deterministic VALUES (100, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should be deterministic");
    }

    @Test
    public void testDelete() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey < 3")))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey IN (1, 2, 3)")))).matches("SELECT BIGINT '3'");
    }

    @Test
    public void testMergeDelete() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5) t(x) ON regionkey = x\nWHEN MATCHED THEN DELETE\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,11) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11,12,13,14,15) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
    }

    @Test
    public void testUpdate() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey + 1")))).matches("SELECT BIGINT '25'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey IN (1, 2, 3)")))).matches("SELECT BIGINT '3'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 10")).hasMessage("Check constraint violation: (regionkey < 10)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 10 WHERE nationkey IN (1, 11)")).hasMessage("Check constraint violation: (regionkey < 10)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 10 WHERE nationkey = 11")).hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey < 3")))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = null WHERE nationkey < 3")))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey = 10")))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey = null")))).matches("SELECT BIGINT '0'");
    }

    @Test
    public void testUpdateAllowUnknown() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = NULL")))).matches("SELECT BIGINT '25'");
    }

    @Test
    public void testUpdateSubquery() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_subquery SET nationkey = 100")).hasMessageContaining("Unexpected subquery expression in logical plan");
    }

    @Test
    public void testUpdateUnsupportedCurrentDate() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_current_date SET nationkey = 10")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedCurrentTime() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_current_time SET nationkey = 10")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedCurrentTimestamp() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_current_timestamp SET nationkey = 10")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedLocaltime() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_localtime SET nationkey = 10")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedLocaltimestamp() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_localtimestamp SET nationkey = 10")).hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedConstraint() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_invalid_function SET nationkey = 10")).hasMessageContaining("Function 'invalid_function' not registered");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_not_boolean_expression SET nationkey = 10")).hasMessageContaining("to be of type BOOLEAN, but was integer");
    }

    @Test
    public void testUpdateNotDeterministic() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_not_deterministic VALUES (100, 'POLAND', 0, 'No comment')")).hasMessageContaining("Check constraint expression should be deterministic");
    }

    @Test
    public void testMergeUpdate() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 5) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1, 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 10\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 13\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey IS NULL\nWHEN MATCHED THEN UPDATE SET nationkey = 13\n")).hasMessage("line 1:1: Cannot merge into a table with check constraints");
    }
}

